/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.ResponseLatch;
import com.yubico.client.v2.YubicoResponse;
import com.yubico.client.v2.YubicoResponseStatus;
import com.yubico.client.v2.impl.YubicoResponseImpl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YubicoValidationService {
    final ResponseLatch<YubicoResponse> result = new ResponseLatch(1L, TimeUnit.MINUTES);

    public YubicoResponse fetch(List<String> urls) throws InterruptedException {
        int len = urls.size();
        for (int i = 0; i < len; ++i) {
            VerifyTask task = new VerifyTask(urls.get(i));
            new Thread(task).start();
        }
        return this.result.getValue();
    }

    class VerifyTask
    implements Runnable {
        private final String uri;

        public VerifyTask(String uri) {
            this.uri = uri;
        }

        public void run() {
            try {
                URL url = new URL(this.uri);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(15000);
                YubicoResponseImpl resp = new YubicoResponseImpl(conn.getInputStream());
                if (!YubicoResponseStatus.REPLAYED_REQUEST.equals((Object)resp.getStatus())) {
                    YubicoValidationService.this.result.setValue(resp);
                }
            }
            catch (SocketTimeoutException e) {
                System.out.println("Connection timed out");
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

