/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.YubicoResponse;
import com.yubico.client.v2.impl.YubicoClientImpl;
import org.apache.commons.codec.binary.Base64;

public abstract class YubicoClient {
    protected Integer clientId;
    protected byte[] key;
    protected String sync;
    protected String[] wsapi_urls = new String[]{"https://api.yubico.com/wsapi/2.0/verify", "https://api2.yubico.com/wsapi/2.0/verify", "https://api3.yubico.com/wsapi/2.0/verify", "https://api4.yubico.com/wsapi/2.0/verify", "https://api5.yubico.com/wsapi/2.0/verify"};
    private static final Integer OTP_MIN_LEN = 32;
    private static final Integer OTP_MAX_LEN = 48;

    public abstract YubicoResponse verify(String var1);

    public Integer getClientId() {
        return this.clientId;
    }

    public void setClientId(Integer clientId) {
        this.clientId = clientId;
    }

    public void setKey(String key) {
        this.key = Base64.decodeBase64(key.getBytes());
    }

    public String getKey() {
        return new String(Base64.encodeBase64(this.key));
    }

    public void setSync(String sync) {
        this.sync = sync;
    }

    public String getSync() {
        return this.sync;
    }

    public String[] getWsapiUrls() {
        return this.wsapi_urls;
    }

    public void setWsapiUrls(String[] wsapi) {
        this.wsapi_urls = wsapi;
    }

    public static YubicoClient getClient(Integer clientId) {
        return new YubicoClientImpl(clientId);
    }

    public static String getPublicId(String otp) {
        Integer len = otp.length();
        return otp.substring(0, len - 32);
    }

    public static boolean isValidOTPFormat(String otp) {
        int len = otp.length();
        boolean isPrintable = true;
        for (int i = 0; i < len; ++i) {
            char c = otp.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            isPrintable = false;
            break;
        }
        return isPrintable && OTP_MIN_LEN <= len && len <= OTP_MAX_LEN;
    }
}

