/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.miniorange.twofactor.webauthn.utils.AndroidSafetyNetAttestationStatement;
import com.miniorange.twofactor.webauthn.utils.AttestationStatement;
import com.miniorange.twofactor.webauthn.utils.AttestationStatementEnum;
import com.miniorange.twofactor.webauthn.utils.AuthenticatorAttestationResponse;
import com.miniorange.twofactor.webauthn.utils.AuthenticatorResponse;
import com.miniorange.twofactor.webauthn.utils.FidoU2fAttestationStatement;
import com.miniorange.twofactor.webauthn.utils.NoneAttestationStatement;
import com.miniorange.twofactor.webauthn.utils.PackedAttestationStatement;

public class PublicKeyCredential {
    public String id;
    public String type;
    public byte[] rawId;
    AuthenticatorResponse response;

    public PublicKeyCredential(String id, String type, byte[] rawId, AuthenticatorResponse response) {
        this.id = id;
        this.type = type;
        this.rawId = rawId;
        this.response = response;
    }

    public PublicKeyCredential() {
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getRawId() {
        return this.rawId;
    }

    public AttestationStatementEnum getAttestationType() {
        try {
            AuthenticatorAttestationResponse attRsp = (AuthenticatorAttestationResponse)this.response;
            AttestationStatement attStmt = attRsp.decodedObject.getAttestationStatement();
            if (attStmt instanceof AndroidSafetyNetAttestationStatement) {
                return AttestationStatementEnum.ANDROIDSAFETYNET;
            }
            if (attStmt instanceof FidoU2fAttestationStatement) {
                return AttestationStatementEnum.FIDOU2F;
            }
            if (attStmt instanceof PackedAttestationStatement) {
                return AttestationStatementEnum.PACKED;
            }
            if (attStmt instanceof NoneAttestationStatement) {
                return AttestationStatementEnum.NONE;
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return null;
    }

    public AuthenticatorResponse getResponse() {
        return this.response;
    }

    public String encode() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(this);
    }
}

