/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.miniorange.twofactor.webauthn.utils.AttestationData;
import com.miniorange.twofactor.webauthn.utils.AttestationExtension;
import com.miniorange.twofactor.webauthn.utils.CableRegistrationData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class AuthenticatorData {
    private byte[] rpIdHash;
    private byte flags;
    private int signCount;
    AttestationData attData;
    private byte[] extensions;

    public AuthenticatorData(byte[] rpIdHash, byte flags, int signCount, AttestationData attData, byte[] extensions) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = signCount;
        this.attData = attData;
        this.extensions = extensions;
    }

    AuthenticatorData() {
        this.rpIdHash = new byte[32];
        this.attData = new AttestationData();
        this.extensions = null;
    }

    AuthenticatorData(byte[] rpIdHash, byte flags, int signCount) {
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = signCount;
        this.attData = null;
        this.extensions = null;
    }

    public byte[] getRpIdHash() {
        return this.rpIdHash;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isUP() {
        return (this.flags & 1) != 0;
    }

    public boolean isUV() {
        return (this.flags & 4) != 0;
    }

    public boolean hasAttestationData() {
        return (this.flags & 0x40) != 0;
    }

    public boolean hasExtensionData() {
        return (this.flags & 0x80) != 0;
    }

    public HashMap<String, AttestationExtension> getExtensionData() {
        return this.parseExtensions(this.extensions);
    }

    public int getSignCount() {
        return this.signCount;
    }

    public AttestationData getAttData() {
        return this.attData;
    }

    public static AuthenticatorData decode(byte[] authData) throws Exception {
        if (authData.length < 37) {
            throw new Exception("Invalid input");
        }
        int index = 0;
        byte[] rpIdHash = new byte[32];
        System.arraycopy(authData, 0, rpIdHash, 0, 32);
        index += 32;
        byte flags = authData[index++];
        int signCount = Ints.fromBytes((byte)authData[index++], (byte)authData[index++], (byte)authData[index++], (byte)authData[index++]);
        int definedIndex = index;
        AttestationData attData = null;
        if ((flags & 0x40) != 0) {
            byte[] remainder = new byte[authData.length - index];
            System.arraycopy(authData, index, remainder, 0, authData.length - index);
            try {
                attData = AttestationData.decode(remainder);
            }
            catch (CborException e) {
                throw new Exception("Error decoding");
            }
        }
        byte[] extensions = null;
        if ((flags & 0x80) != 0) {
            try {
                int start = definedIndex + attData.encode().length;
                if (authData.length > start) {
                    byte[] remainder = new byte[authData.length - start];
                    System.arraycopy(authData, start, remainder, 0, authData.length - start);
                    extensions = remainder;
                }
            }
            catch (CborException e) {
                throw new Exception("Error decoding authenticator extensions");
            }
        }
        return new AuthenticatorData(rpIdHash, flags, signCount, attData, extensions);
    }

    private HashMap<String, AttestationExtension> parseExtensions(byte[] extensions) {
        HashMap<String, AttestationExtension> extensionMap = new HashMap<String, AttestationExtension>();
        try {
            List<DataItem> dataItems = CborDecoder.decode(extensions);
            if (dataItems.size() < 1 || !(dataItems.get(0) instanceof Map)) {
                return extensionMap;
            }
            Map map = (Map)dataItems.get(0);
            for (DataItem data : map.getKeys()) {
                if (!(data instanceof UnicodeString) || !((UnicodeString)data).getString().equals("cableRegistration")) continue;
                CableRegistrationData decodedCableData = CableRegistrationData.parseFromCbor(map.get(data));
                extensionMap.put("cableRegistration", decodedCableData);
            }
        }
        catch (CborException e) {
            e.printStackTrace();
        }
        return extensionMap;
    }

    public byte[] encode() throws CborException {
        byte[] result;
        byte[] flags = new byte[]{this.flags};
        byte[] signCount = ByteBuffer.allocate(4).putInt(this.signCount).array();
        if (this.attData != null) {
            byte[] attData = this.attData.encode();
            result = Bytes.concat((byte[][])new byte[][]{this.rpIdHash, flags, signCount, attData});
        } else {
            result = Bytes.concat((byte[][])new byte[][]{this.rpIdHash, flags, signCount});
        }
        if (this.extensions != null) {
            result = Bytes.concat((byte[][])new byte[][]{result, this.extensions});
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.rpIdHash), this.flags, this.signCount, this.attData, Arrays.hashCode(this.extensions));
    }

    public boolean equals(Object obj) {
        try {
            return Arrays.equals(this.encode(), ((AuthenticatorData)obj).encode());
        }
        catch (CborException | ClassCastException e) {
            return false;
        }
    }
}

