/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationOtpOverSms
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationOtpOverSms.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_otpoversms.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationOtpOverSms(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationOtpOverSms doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_OtpOverSms").booleanValue()) {
            LOGGER.debug("inside");
            UserProfile user = this.pluginConfiguration.getCrowdUser(username);
            String displayName = user.getUsername();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("countryCode", "+1");
            context.put("mobileNumber", "");
            ArrayList errorMessage = new ArrayList();
            context.put("errorMessage", errorMessage);
            context.put("successMessage", "");
            String template = this.pluginSettings.getConfigureOtpOverSmsTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationOtpOverSms doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        HttpSession session = request.getSession();
        String countryCode = (String)session.getAttribute("countryCode");
        countryCode = MoTwoFactorUtility.sanitizeText(countryCode);
        String mobileNumber = (String)session.getAttribute("mobileNumber");
        mobileNumber = MoTwoFactorUtility.sanitizeText(mobileNumber);
        LOGGER.debug("countryCode: " + countryCode);
        LOGGER.debug("mobileNumber: " + mobileNumber);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String successMessage;
            ArrayList<String> errorMessage;
            block27: {
                errorMessage = new ArrayList<String>();
                successMessage = "";
                if (BooleanUtils.toBoolean((String)request.getParameter("resendOtpLinkClicked"))) {
                    LOGGER.debug("Resend OTP link clicked");
                    try {
                        if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmsGatewayConfigured())) {
                            this.pluginHandler.sendOtpOnSms(request, this.pluginConfiguration.getCrowdUser(username), countryCode, mobileNumber);
                            successMessage = "Successfully resent the OTP to your mobile.";
                            break block27;
                        }
                        errorMessage.add("Issue with sending SMS on mobile. SMS gateway is not Configured. Please contact the administrator.");
                    }
                    catch (Exception e) {
                        errorMessage.add("Issue with sending SMS on mobile. Please contact to admin");
                    }
                } else {
                    LOGGER.debug("Checking OTP validation");
                    String otp = StringUtils.trimToEmpty((String)request.getParameter("otpCode"));
                    if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                        LOGGER.debug("OTP is Valid = " + otp);
                        Boolean isValid = Boolean.FALSE;
                        if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
                            String txId = (String)session.getAttribute("txId");
                            txId = MoTwoFactorUtility.sanitizeText(txId);
                            LOGGER.debug("txId: " + txId);
                            try {
                                isValid = this.pluginHandler.validateOtpUsingMiniOrangeGateway(System.currentTimeMillis(), otp, txId);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error occurred while validating OTP via miniOrange Gateway");
                            }
                            if (!isValid.booleanValue()) {
                                errorMessage.add("Invalid OTP Entered.");
                            }
                        } else {
                            String storedOtpCode = (String)session.getAttribute("sms_otp_code");
                            if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)(storedOtpCode = MoTwoFactorUtility.sanitizeText(storedOtpCode)))) {
                                long storedOtpExpiryTime;
                                long currentTimeInMili = System.currentTimeMillis();
                                if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                                    isValid = Boolean.TRUE;
                                } else {
                                    isValid = Boolean.FALSE;
                                    errorMessage.add("OTP is Valid. But Time Expired.");
                                }
                            } else {
                                isValid = Boolean.FALSE;
                                errorMessage.add("Invalid OTP Entered");
                            }
                        }
                        if (isValid.booleanValue()) {
                            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "OTP Over SMS");
                            LOGGER.debug("OTP validated Successfully...");
                            session.removeAttribute("txId");
                            session.removeAttribute("otp_expiry_time");
                            session.removeAttribute("last_otp_sent_time");
                            session.removeAttribute("countryCode");
                            session.removeAttribute("mobileNumber");
                            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                            twoFactorUserClass.setConfigured2FAMethodsByUser("OtpOverSms");
                            twoFactorUserClass.setMobileNumber(mobileNumber);
                            twoFactorUserClass.setCountryCode(countryCode);
                            LOGGER.debug("twoFactorUserClass: " + twoFactorUserClass);
                            List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
                            if (session.getAttribute("considering_backup_method") != null || StringUtils.isNotBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                                LOGGER.debug("Configured Otp over sms as a Backup Method");
                                session.removeAttribute("considering_backup_method");
                            } else if (enabledBackupMethodList.size() != 0) {
                                LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                                twoFactorUserClass.setCurrent2FAMethod("OtpOverSms");
                                this.settings.setUserSettings(username, twoFactorUserClass);
                                String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser());
                                if (StringUtils.isNotBlank((CharSequence)url)) {
                                    response.sendRedirect(url);
                                    return;
                                }
                            } else {
                                LOGGER.debug("Setting up Otp over sms ad primary method");
                                twoFactorUserClass.setCurrent2FAMethod("OtpOverSms");
                            }
                            LOGGER.debug("2FA is Configured successfully");
                            session.setAttribute("2fa_verification", (Object)true);
                            session.removeAttribute("executing_2fa_flow");
                            if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                                session.setAttribute("2fa_show_remaining_methods", (Object)true);
                            }
                            this.settings.setUserSettings(username, twoFactorUserClass);
                            this.settings.addTo2FAConfiguredUsersList(username);
                            this.pluginHandler.redirectToValidUrl(request, response);
                            return;
                        }
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "OTP Over SMS");
                        if (errorMessage.size() == 0) {
                            errorMessage.add("OTP is not valid");
                        }
                    } else {
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "OTP Over SMS");
                        LOGGER.debug("OTP is Not valid");
                        errorMessage.add("Invalid OTP entered. Please enter valid OTP.");
                    }
                }
            }
            UserProfile user = this.pluginConfiguration.getCrowdUser(username);
            String displayName = user.getUsername();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", successMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("countryCode", countryCode);
            context.put("mobileNumber", mobileNumber);
            String template = this.pluginSettings.getConfigureOtpOverSmsTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

