/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationBackupMethodList
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationBackupMethodList.class);
    private static final String METHODLIST_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_backupmethodlist.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorInlineRegistrationBackupMethodList(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationBackupMethodList doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && !this.settings.getListOf2FAConfiguredUsers().contains(username)) {
            Map<String, Object> context = this.initializeContext(username, request);
            String template = this.settings.getInlineRegistration_backupMethodListTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationBackupMethodList doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String configureTwoFactor = request.getParameter("configureTwoFactor");
            if (StringUtils.isNotBlank((CharSequence)"configureTwoFactor")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"OtpOverEmail")) {
                    LOGGER.debug("Redirecting to OTP Over EMail for inline registration as a backup method");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"OtpOverSms")) {
                    LOGGER.debug("Redirecting to OTP Over SMS for inline registration as a backup method");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"SecurityQuestion")) {
                    LOGGER.debug("Redirecting to Security Question for inline registration as a backup method");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"BackupCode")) {
                    LOGGER.debug("Redirecting to Backup Code for inline registration as a backup method");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"GoogleAuthenticator")) {
                    LOGGER.debug("Redirecting to Mobile Authenticator for inline registration as a backup method ");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                    LOGGER.debug("Redirecting to Yubikey Hardware token for inline registration as a backup method ");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"WebAuthn")) {
                    LOGGER.debug("Redirecting to Web Authn for inline registration as a backup method ");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"DuoPushNotification")) {
                    LOGGER.debug("Redirecting to Duo Push Notification for inline registration as a backup method ");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification"));
                    return;
                }
            }
            String errorMessage = "Please select valid method.";
            Map<String, Object> context = this.initializeContext(username, request);
            context.put("errorMessage", errorMessage);
            String template = this.settings.getInlineRegistration_backupMethodListTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    private Map<String, Object> initializeContext(String username, HttpServletRequest request) {
        UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
        String displayName = userProfile.getFullName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = username;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("username", displayName);
        context.put("errorMessage", "");
        List<String> backupMethodList = this.settings.getBackupMethodForUserList();
        MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
        List<String> configuredMethods = twoFactorCommonUserSettings.getConfigured2FAMethodsByUser();
        context.put("securityQuestionEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("SecurityQuestion") && !configuredMethods.contains("SecurityQuestion") ? 1 : 0)));
        context.put("googleAuthenticatorEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("GoogleAuthenticator") && !configuredMethods.contains("GoogleAuthenticator") ? 1 : 0)));
        LOGGER.debug("\n googleAuthenticatorEnabled :" + BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("GoogleAuthenticator") && !configuredMethods.contains("GoogleAuthenticator") ? 1 : 0)));
        context.put("u2fHardwareTokenEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("YubikeyHardwareTokenAsU2F") && !configuredMethods.contains("YubikeyHardwareTokenAsU2F") ? 1 : 0)));
        context.put("webAuthnAs2faEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("WebAuthn") && !configuredMethods.contains("WebAuthn") ? 1 : 0)));
        context.put("pushNotificationEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("DuoPushNotification") && !configuredMethods.contains("DuoPushNotification") ? 1 : 0)));
        context.put("otpOverEmailEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("OtpOverEmail") && !configuredMethods.contains("OtpOverEmail") ? 1 : 0)));
        context.put("otpOverSmsEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("OtpOverSms") && !configuredMethods.contains("OtpOverSms") ? 1 : 0)));
        context.put("backupCodeEnabled", BooleanUtils.toBoolean((Boolean)(backupMethodList.contains("BackupCode") && !configuredMethods.contains("BackupCode") ? 1 : 0)));
        context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        return context;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

