/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.scheduler;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.scheduler.UpdateLicenseService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateLicenseTaskHandler
implements PluginJob {
    private static Log LOGGER = LogFactory.getLog(UpdateLicenseTaskHandler.class);

    public void execute(Map<String, Object> jobDataMap) {
        try {
            LOGGER.debug("Executing update License Task");
            UpdateLicenseService service = (UpdateLicenseService)jobDataMap.get(UpdateLicenseService.KEY);
            MoTwoFactorCrowdPluginSettings settings = (MoTwoFactorCrowdPluginSettings)jobDataMap.get(UpdateLicenseService.SETTINGS_KEY);
            MoTwoFactorPluginHandler pluginHandler = (MoTwoFactorPluginHandler)jobDataMap.get(UpdateLicenseService.PLUGIN_HANDLER_KEY);
            if (service != null) {
                Boolean verified = pluginHandler.verifyLicense(settings, settings.getCustomerLicenseKey());
                if (!verified.booleanValue()) {
                    LOGGER.debug("License Verification Failed!!");
                    service.unschedule();
                }
                if (!pluginHandler.checkLicenseCondition().booleanValue()) {
                    LOGGER.debug("License condition failed-No. of user exceeded");
                    service.unschedule();
                }
                LOGGER.debug("Completed update License Task");
            }
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while executing update license task" + e);
        }
    }
}

