/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.scheduler.UpdateLicenseService;
import com.opensymphony.xwork2.Validateable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorVerifyLicenseAction
extends BaseAction
implements Validateable {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorVerifyLicenseAction.class);
    private I18nHelper i18nHelper;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UpdateLicenseService updateLicenseService;
    String email;
    private String key;
    private Boolean submitted;
    private Boolean backToRegister;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;

    public MoTwoFactorVerifyLicenseAction(UserManager userManager, LoginUriProvider loginUriProvider, I18nHelper i18nHelper, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, UpdateLicenseService updateLicenseService) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nHelper = i18nHelper;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.updateLicenseService = updateLicenseService;
    }

    public String execute() throws Exception {
        LOGGER.info("verify license action execute called.");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            this.pluginSettings.getLicenseType();
            if (this.pluginSettings.isCustomerRegistered().booleanValue() && this.pluginSettings.getLicenseVerified().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue() && !this.pluginSettings.isLicenseExpired().booleanValue()) {
                LOGGER.debug("customer is registered with valid license, redirecting to the configuration page");
                return "success";
            }
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is not registered.");
                return "register";
            }
            if (BooleanUtils.toBoolean((Boolean)this.backToRegister)) {
                LOGGER.debug("back to login page");
                this.pluginSettings.removeCustomerAccount();
                return "register";
            }
            if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                LOGGER.debug("verify license action submitted");
                if (StringUtils.isBlank((CharSequence)this.key)) {
                    this.addActionError(this.i18nHelper.getText("2fa.error.verify.license.empty"));
                    this.initializeConfig();
                    return "input";
                }
                LOGGER.debug("key = " + this.key);
                Boolean valid = this.pluginHandler.verifyLicense(this.pluginSettings, this.key.trim());
                LOGGER.debug("valid = " + valid);
                if (valid.booleanValue()) {
                    this.updateLicenseService.schedule();
                    return "success";
                }
                this.addActionError(this.i18nHelper.getText("2fa.error.verify.license.invalid"));
                this.initializeConfig();
                return "input";
            }
            this.initializeConfig();
            return "input";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        this.email = this.pluginSettings.getCustomerEmail();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.pagesAccessibleToUser = new ArrayList<String>();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getBackToRegister() {
        return this.backToRegister;
    }

    public void setBackToRegister(Boolean backToRegister) {
        this.backToRegister = backToRegister;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }
}

