/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorLookAndFeelTemplates
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLookAndFeelTemplates.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UserManager userManager;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private String welcomeMessageTemplate;
    private String inlineRegistration_2faMethodListTemplate;
    private String inlineRegistration_backupMethodListTemplate;
    private String inlineRegistration_remaining2faMethodsListTemplate;
    private String validate_2faMethodListTemplate;
    private String configureGoogleAuthenticatorTemplate;
    private String validateGoogleAuthenticatorTemplate;
    private String configureSecurityQuestionTemplate;
    private String validateSecurityQuestionTemplate;
    private String configureOtpOverEmailTemplate;
    private String validateOtpOverEmailTemplate;
    private String configureBackupCodeTemplate;
    private String validateBackupCodeTemplate;
    private String configureOtpOverSMSTemplate;
    private String validateOtpOverSMSTemplate;
    private String configureDuoPushNotificationTemplate;
    private String validateDuoPushNotificationTemplate;
    private String configureU2FHardwareTokenTemplate;
    private String validateU2FHardwareTokenTemplate;
    private String configureWebAuthenticationTemplate;
    private String validateWebAuthenticationTemplate;
    private String lockedUsersTemplate;
    private String blocklistIpTemplate;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean multiLingualSupportToggle;
    private List<String> securityQuestionsList = new ArrayList<String>();

    public MoTwoFactorLookAndFeelTemplates(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginSettings = pluginSettings;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorLookAndFeelTemplates");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("LookAndFeel_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("LookAndFeel_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            try {
                LOGGER.info("Configure Action doExecute called. ");
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "verify";
                }
                if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.settingsSubmitted)) {
                    this.securityQuestionsList = this.settings.getSecurityQuestionsList();
                    for (int i = 0; i <= 10; ++i) {
                        String question = MoTwoFactorUtility.sanitizeText(this.getHttpRequest().getParameter("question_" + i).trim());
                        if (!StringUtils.isNotBlank((CharSequence)question)) continue;
                        LOGGER.debug("question_" + i + " value :" + question);
                        if (this.securityQuestionsList.contains(question)) continue;
                        this.securityQuestionsList.set(i, question.trim());
                    }
                    this.pluginHandler.save2FATemplateSettings(this.welcomeMessageTemplate, this.configureGoogleAuthenticatorTemplate, this.validateGoogleAuthenticatorTemplate, this.configureSecurityQuestionTemplate, this.validateSecurityQuestionTemplate, this.configureOtpOverEmailTemplate, this.validateOtpOverEmailTemplate, this.configureOtpOverSMSTemplate, this.validateOtpOverSMSTemplate, this.configureDuoPushNotificationTemplate, this.validateDuoPushNotificationTemplate, this.configureU2FHardwareTokenTemplate, this.validateU2FHardwareTokenTemplate, this.configureWebAuthenticationTemplate, this.validateWebAuthenticationTemplate, this.configureBackupCodeTemplate, this.validateBackupCodeTemplate, this.lockedUsersTemplate, this.blocklistIpTemplate, this.inlineRegistration_2faMethodListTemplate, this.inlineRegistration_backupMethodListTemplate, this.inlineRegistration_remaining2faMethodsListTemplate, this.validate_2faMethodListTemplate, this.securityQuestionsList);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
                this.initializeConfig();
                return "success";
            }
            catch (PluginException e) {
                LOGGER.error(e.getMessage());
                LOGGER.error("Error " + (Object)((Object)e));
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "upm";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        this.welcomeMessageTemplate = this.pluginSettings.getWelcomeMessageTemplate();
        this.inlineRegistration_2faMethodListTemplate = this.pluginSettings.getInlineRegistration_2faMethodListTemplate();
        this.inlineRegistration_backupMethodListTemplate = this.pluginSettings.getInlineRegistration_backupMethodListTemplate();
        this.inlineRegistration_remaining2faMethodsListTemplate = this.pluginSettings.getInlineRegistration_remaining2faMethodsListTemplate();
        this.validate_2faMethodListTemplate = this.pluginSettings.getValidate_2faMethodListTemplate();
        this.configureGoogleAuthenticatorTemplate = this.pluginSettings.getConfigureGoogleAuthenticatorTemplate();
        this.validateGoogleAuthenticatorTemplate = this.pluginSettings.getValidateGoogleAuthenticatorTemplate();
        this.configureSecurityQuestionTemplate = this.pluginSettings.getConfigureSecurityQuestionTemplate();
        this.validateSecurityQuestionTemplate = this.pluginSettings.getValidateSecurityQuestionTemplate();
        this.configureOtpOverEmailTemplate = this.pluginSettings.getConfigureOtpOverEmailTemplate();
        this.validateOtpOverEmailTemplate = this.pluginSettings.getValidateOtpOverEmailTemplate();
        this.configureBackupCodeTemplate = this.pluginSettings.getConfigureBackupCodeTemplate();
        this.validateBackupCodeTemplate = this.pluginSettings.getValidateBackupCodeTemplate();
        this.configureOtpOverSMSTemplate = this.pluginSettings.getConfigureOtpOverSmsTemplate();
        this.validateOtpOverSMSTemplate = this.pluginSettings.getValidateOtpOverSmsTemplate();
        this.configureDuoPushNotificationTemplate = this.pluginSettings.getConfigureDuoPushNotificationTemplate();
        this.validateDuoPushNotificationTemplate = this.pluginSettings.getValidateDuoPushNotificationTemplate();
        this.configureU2FHardwareTokenTemplate = this.pluginSettings.getConfigureWebAuthnHardwareTokenTemplate();
        this.validateU2FHardwareTokenTemplate = this.pluginSettings.getValidateWebAuthnHardwareTokenTemplate();
        this.configureWebAuthenticationTemplate = this.pluginSettings.getConfigureWebAuthnAs2faMethodTemplate();
        this.validateWebAuthenticationTemplate = this.pluginSettings.getValidateWebAuthnAs2faMethodTemplate();
        this.lockedUsersTemplate = this.pluginSettings.getLockedUserTemplate();
        this.blocklistIpTemplate = this.pluginSettings.getBlocklistIpTemplate();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
        this.securityQuestionsList = this.settings.getSecurityQuestionsList();
        if (this.securityQuestionsList.size() == 0) {
            this.securityQuestionsList = MoTwoFactorUtility.getQuestionList();
            this.settings.setSecurityQuestionsList(this.securityQuestionsList);
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public MoTwoFactorCrowdPluginSettings getTwoFactorCrowdPluginSettings() {
        return this.pluginSettings;
    }

    public void setTwoFactorCrowdPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public String getWelcomeMessageTemplate() {
        return this.welcomeMessageTemplate;
    }

    public void setWelcomeMessageTemplate(String welcomeMessageTemplate) {
        this.welcomeMessageTemplate = welcomeMessageTemplate;
    }

    public String getConfigureGoogleAuthenticatorTemplate() {
        return this.configureGoogleAuthenticatorTemplate;
    }

    public void setConfigureGoogleAuthenticatorTemplate(String configureGoogleAuthenticatorTemplate) {
        this.configureGoogleAuthenticatorTemplate = configureGoogleAuthenticatorTemplate;
    }

    public String getValidateGoogleAuthenticatorTemplate() {
        return this.validateGoogleAuthenticatorTemplate;
    }

    public void setValidateGoogleAuthenticatorTemplate(String validateGoogleAuthenticatorTemplate) {
        this.validateGoogleAuthenticatorTemplate = validateGoogleAuthenticatorTemplate;
    }

    public String getConfigureSecurityQuestionTemplate() {
        return this.configureSecurityQuestionTemplate;
    }

    public void setConfigureSecurityQuestionTemplate(String configureSecurityQuestionTemplate) {
        this.configureSecurityQuestionTemplate = configureSecurityQuestionTemplate;
    }

    public String getValidateSecurityQuestionTemplate() {
        return this.validateSecurityQuestionTemplate;
    }

    public void setValidateSecurityQuestionTemplate(String validateSecurityQuestionTemplate) {
        this.validateSecurityQuestionTemplate = validateSecurityQuestionTemplate;
    }

    public String getConfigureOtpOverEmailTemplate() {
        return this.configureOtpOverEmailTemplate;
    }

    public void setConfigureOtpOverEmailTemplate(String configureOtpOverEmailTemplate) {
        this.configureOtpOverEmailTemplate = configureOtpOverEmailTemplate;
    }

    public String getValidateOtpOverEmailTemplate() {
        return this.validateOtpOverEmailTemplate;
    }

    public void setValidateOtpOverEmailTemplate(String validateOtpOverEmailTemplate) {
        this.validateOtpOverEmailTemplate = validateOtpOverEmailTemplate;
    }

    public String getConfigureOtpOverSMSTemplate() {
        return this.configureOtpOverSMSTemplate;
    }

    public void setConfigureOtpOverSMSTemplate(String configureOtpOverSMSTemplate) {
        this.configureOtpOverSMSTemplate = configureOtpOverSMSTemplate;
    }

    public String getValidateOtpOverSMSTemplate() {
        return this.validateOtpOverSMSTemplate;
    }

    public void setValidateOtpOverSMSTemplate(String validateOtpOverSMSTemplate) {
        this.validateOtpOverSMSTemplate = validateOtpOverSMSTemplate;
    }

    public String getConfigureBackupCodeTemplate() {
        return this.configureBackupCodeTemplate;
    }

    public void setConfigureBackupCodeTemplate(String configureBackupCodeTemplate) {
        this.configureBackupCodeTemplate = configureBackupCodeTemplate;
    }

    public String getValidateBackupCodeTemplate() {
        return this.validateBackupCodeTemplate;
    }

    public void setValidateBackupCodeTemplate(String validateBackupCodeTemplate) {
        this.validateBackupCodeTemplate = validateBackupCodeTemplate;
    }

    public String getLockedUsersTemplate() {
        return this.lockedUsersTemplate;
    }

    public void setLockedUsersTemplate(String lockedUsersTemplate) {
        this.lockedUsersTemplate = lockedUsersTemplate;
    }

    public String getBlocklistIpTemplate() {
        return this.blocklistIpTemplate;
    }

    public void setBlocklistIpTemplate(String blocklistIpTemplate) {
        this.blocklistIpTemplate = blocklistIpTemplate;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getConfigureDuoPushNotificationTemplate() {
        return this.configureDuoPushNotificationTemplate;
    }

    public void setConfigureDuoPushNotificationTemplate(String configureDuoPushNotificationTemplate) {
        this.configureDuoPushNotificationTemplate = configureDuoPushNotificationTemplate;
    }

    public String getValidateDuoPushNotificationTemplate() {
        return this.validateDuoPushNotificationTemplate;
    }

    public void setValidateDuoPushNotificationTemplate(String validateDuoPushNotificationTemplate) {
        this.validateDuoPushNotificationTemplate = validateDuoPushNotificationTemplate;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public String getConfigureU2FHardwareTokenTemplate() {
        return this.configureU2FHardwareTokenTemplate;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public void setConfigureU2FHardwareTokenTemplate(String configureU2FHardwareTokenTemplate) {
        this.configureU2FHardwareTokenTemplate = configureU2FHardwareTokenTemplate;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public String getValidateU2FHardwareTokenTemplate() {
        return this.validateU2FHardwareTokenTemplate;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public void setValidateU2FHardwareTokenTemplate(String validateU2FHardwareTokenTemplate) {
        this.validateU2FHardwareTokenTemplate = validateU2FHardwareTokenTemplate;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public String getConfigureWebAuthenticationTemplate() {
        return this.configureWebAuthenticationTemplate;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public void setConfigureWebAuthenticationTemplate(String configureWebAuthenticationTemplate) {
        this.configureWebAuthenticationTemplate = configureWebAuthenticationTemplate;
    }

    public String getValidateWebAuthenticationTemplate() {
        return this.validateWebAuthenticationTemplate;
    }

    public void setValidateWebAuthenticationTemplate(String validateWebAuthenticationTemplate) {
        this.validateWebAuthenticationTemplate = validateWebAuthenticationTemplate;
    }

    public String getInlineRegistration_2faMethodListTemplate() {
        return this.inlineRegistration_2faMethodListTemplate;
    }

    public void setInlineRegistration_2faMethodListTemplate(String inlineRegistration_2faMethodListTemplate) {
        this.inlineRegistration_2faMethodListTemplate = inlineRegistration_2faMethodListTemplate;
    }

    public String getInlineRegistration_backupMethodListTemplate() {
        return this.inlineRegistration_backupMethodListTemplate;
    }

    public void setInlineRegistration_backupMethodListTemplate(String inlineRegistration_backupMethodListTemplate) {
        this.inlineRegistration_backupMethodListTemplate = inlineRegistration_backupMethodListTemplate;
    }

    public String getInlineRegistration_remaining2faMethodsListTemplate() {
        return this.inlineRegistration_remaining2faMethodsListTemplate;
    }

    public void setInlineRegistration_remaining2faMethodsListTemplate(String inlineRegistration_remaining2faMethodsListTemplate) {
        this.inlineRegistration_remaining2faMethodsListTemplate = inlineRegistration_remaining2faMethodsListTemplate;
    }

    public String getValidate_2faMethodListTemplate() {
        return this.validate_2faMethodListTemplate;
    }

    public void setValidate_2faMethodListTemplate(String validate_2faMethodListTemplate) {
        this.validate_2faMethodListTemplate = validate_2faMethodListTemplate;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }

    public List<String> getSecurityQuestionsList() {
        return this.securityQuestionsList;
    }

    public void setSecurityQuestionsList(List<String> securityQuestionsList) {
        this.securityQuestionsList = securityQuestionsList;
    }
}

