/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.mail.MailConfigurationService;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.duosecurity.client.Http;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.Customer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.utility.MoHttpUtils;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class MoTwoFactorPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorPluginHandler.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private CrowdService crowdService;
    private UserManager userManager;
    private MailConfigurationService mailConfigurationService;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MailManager mailManager;
    private TransactionTemplate transactionTemplate;
    private MoLogEntityService logEntityService;

    public MoTwoFactorPluginHandler(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, CrowdService crowdService, MailConfigurationService mailConfigurationService, MoTwoFactorCrowdPluginSettings pluginSettings, MailManager mailManager, TransactionTemplate transactionTemplate, MoLogEntityService logEntityService) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.mailConfigurationService = mailConfigurationService;
        this.pluginSettings = pluginSettings;
        this.mailManager = mailManager;
        this.transactionTemplate = transactionTemplate;
        this.logEntityService = logEntityService;
    }

    public void saveAdvanced2FASettings(Boolean enableBruteForceProtection, String bruteForceNumberOfAttempts, String bruteForceTimeInterval, String bruteForceCustomTimeInterval, String bruteForceCustomTimeDuration, String emailTemplateBruteForce, Boolean enableRememberMeDevice, String rememberMeDeviceDuration, Boolean showSupportedAppPopup, Boolean bypass2faAfterCrowdSso, String bypass2FACookieDomain, Boolean ignore2FAAfterSso, String ssoLoginUrl, String clientIpRequestHeader, String skip2faUrls, Map<String, String> pagesWithGroupAccessMapping, Boolean multiLingualSupportToggle, Boolean allowedToReconfigureMethod, Boolean enableEnforceCurrentMethod, String primaryMethodForUser, Boolean showAllConfiguredMethodsDirectly, Boolean showRemaining2FAMethodsAfterConfiguration) {
        LOGGER.debug("Saving Advanced Two Factor Settings : , showSupportedAppPopup : " + showSupportedAppPopup + ", enableRememberMeDevice : " + enableRememberMeDevice + ", rememberMeDeviceDuration : " + rememberMeDeviceDuration + ", enableBruteForceProtection : " + enableBruteForceProtection + ", bruteForceNumberOfAttempts : " + bruteForceNumberOfAttempts + ", bruteForceTimeInterval : " + bruteForceTimeInterval + ", bruteForceCustomTimeInterval : " + bruteForceCustomTimeInterval + ", bruteForceCustomTimeDuration : " + bruteForceCustomTimeDuration + ", emailTemplateBruteForce : " + emailTemplateBruteForce + ", bypass2faAfterCrowdSso : " + bypass2faAfterCrowdSso + ", ignore2FAAfterSso : " + ignore2FAAfterSso + ", ssoLoginUrl : " + ssoLoginUrl + ", clientIpRequestHeader : " + clientIpRequestHeader + ", skip2faUrls : " + skip2faUrls + ", pagesWithGroupAccessMapping :" + pagesWithGroupAccessMapping + ", multiLingualSupportToggle : " + multiLingualSupportToggle + ", allowedToReconfigureMethod: " + allowedToReconfigureMethod + ", enableEnforceCurrentMethod: " + enableEnforceCurrentMethod + ", primaryMethodForUser: " + primaryMethodForUser + ", showAllConfiguredMethodsDirectly: " + showAllConfiguredMethodsDirectly + ", showRemaining2FAMethodsAfterConfiguration: " + showRemaining2FAMethodsAfterConfiguration);
        this.settings.setEnableRememberMeDevice(enableRememberMeDevice);
        if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice)) {
            this.settings.setRememberMeDeviceDuration(Integer.parseInt(rememberMeDeviceDuration));
        }
        this.settings.setEnableBruteForceProtection(enableBruteForceProtection);
        if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection)) {
            this.settings.setBruteForceNumberOfAttempts(Integer.parseInt(bruteForceNumberOfAttempts));
            this.settings.setBruteForceTimeInterval(bruteForceTimeInterval);
            this.settings.setBruteForceCustomTimeInterval(bruteForceCustomTimeInterval);
            this.settings.setBruteForceCustomTimeDuration(Integer.parseInt(bruteForceCustomTimeDuration));
            this.settings.setEmailTemplateBruteForce(emailTemplateBruteForce);
        }
        this.settings.setBypass2faAfterCrowdSso(bypass2faAfterCrowdSso);
        this.settings.setShowSupportedAppPopup(showSupportedAppPopup);
        this.settings.setIgnore2FAAfterSso(ignore2FAAfterSso);
        if (BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso)) {
            this.settings.setSsoLoginUrl(ssoLoginUrl);
        }
        this.settings.setBypass2FACookieDomain(bypass2FACookieDomain);
        this.settings.setClientIpRequestHeader(clientIpRequestHeader);
        this.modifyAndSaveStringOfSkip2FAUrls(skip2faUrls);
        this.settings.setGroupsWithAdminPagesAccess(pagesWithGroupAccessMapping);
        this.settings.setMultiLingualSupportToggle(multiLingualSupportToggle);
        this.settings.setAllowToReconfigureConfigured2faMethod(allowedToReconfigureMethod);
        this.settings.setEnableEnforce2faMethodForUser(enableEnforceCurrentMethod);
        this.settings.setPrimary2faMethodForUser(primaryMethodForUser);
        this.settings.setShowAllConfiguredMethodToUser(showAllConfiguredMethodsDirectly);
        this.settings.setShowRemaining2FAMethodsAfterInlineRegistration(showRemaining2FAMethodsAfterConfiguration);
    }

    public void modifyAndSaveStringOfSkip2FAUrls(String skip2FAUrls) {
        List<String> skip2FAForGivenUrlList = this.settings.getSkip2FAForGivenUrlList();
        String[] urls = skip2FAUrls.split(";");
        for (int index = 0; index < urls.length; ++index) {
            urls[index] = StringUtils.trim((String)urls[index]);
            if (urls[index].isEmpty() || skip2FAForGivenUrlList.contains(urls[index])) continue;
            skip2FAForGivenUrlList.add(urls[index]);
        }
        this.settings.setSkip2FAForGivenUrlList(skip2FAForGivenUrlList);
    }

    public void save2FATemplateSettings(String welcomeMessageTemplate, String configureGoogleAuthenticatorTemplate, String validateGoogleAuthenticatorTemplate, String configureSecurityQuestionTemplate, String validateSecurityQuestionTemplate, String configureOtpOverEmailTemplate, String validateOtpOverEmailTemplate, String configureOtpOverSMSTemplate, String validateOtpOverSMSTemplate, String configureDuoPushNotificationTemplate, String validateDuoPushNotificationTemplate, String configureHardwareTokenTemplate, String validateHardwareTokenTemplate, String configureWebAuthenticationTemplate, String validateWebAuthenticationTemplate, String configureBackupCodeTemplate, String validateBackupCodeTemplate, String lockedUsersTemplate, String blocklistIpTemplate, String inlineRegistration_2faMethodListTemplate, String inlineRegistration_backupMethodListTemplate, String inlineRegistration_remaining2faMethodsListTemplate, String validate_2faMethodListTemplate, List<String> securityQuestionsList) {
        LOGGER.debug("Calling save2FATemplateSettings");
        this.pluginSettings.setWelcomeMessageTemplate(welcomeMessageTemplate);
        this.pluginSettings.setConfigureGoogleAuthenticatorTemplate(configureGoogleAuthenticatorTemplate);
        this.pluginSettings.setValidateGoogleAuthenticatorTemplate(validateGoogleAuthenticatorTemplate);
        this.pluginSettings.setConfigureSecurityQuestionTemplate(configureSecurityQuestionTemplate);
        this.pluginSettings.setValidateSecurityQuestionTemplate(validateSecurityQuestionTemplate);
        this.pluginSettings.setConfigureOtpOverEmailTemplate(configureOtpOverEmailTemplate);
        this.pluginSettings.setValidateOtpOverEmailTemplate(validateOtpOverEmailTemplate);
        this.pluginSettings.setConfigureOtpOverSmsTemplate(configureOtpOverSMSTemplate);
        this.pluginSettings.setValidateOtpOverSmsTemplate(validateOtpOverSMSTemplate);
        this.pluginSettings.setConfigureBackupCodeTemplate(configureBackupCodeTemplate);
        this.pluginSettings.setValidateBackupCodeTemplate(validateBackupCodeTemplate);
        this.pluginSettings.setConfigureWebAuthnHardwareTokenTemplate(configureHardwareTokenTemplate);
        this.pluginSettings.setValidateWebAuthnHardwareTokenTemplate(validateHardwareTokenTemplate);
        this.pluginSettings.setConfigureWebAuthnAs2faMethodTemplate(configureWebAuthenticationTemplate);
        this.pluginSettings.setValidateWebAuthnAs2faMethodTemplate(validateWebAuthenticationTemplate);
        this.pluginSettings.setConfigureDuoPushNotificationTemplate(configureDuoPushNotificationTemplate);
        this.pluginSettings.setValidateDuoPushNotificationTemplate(validateDuoPushNotificationTemplate);
        this.pluginSettings.setLockedUserTemplate(lockedUsersTemplate);
        this.pluginSettings.setBlocklistIpTemplate(blocklistIpTemplate);
        this.pluginSettings.setInlineRegistration_2faMethodListTemplate(inlineRegistration_2faMethodListTemplate);
        this.pluginSettings.setInlineRegistration_backupMethodListTemplate(inlineRegistration_backupMethodListTemplate);
        this.pluginSettings.setInlineRegistration_remaining2faMethodsListTemplate(inlineRegistration_remaining2faMethodsListTemplate);
        this.pluginSettings.setValidate_2faMethodListTemplate(validate_2faMethodListTemplate);
        if (securityQuestionsList.size() == 0) {
            securityQuestionsList = MoTwoFactorUtility.getQuestionList();
        }
        this.settings.setSecurityQuestionsList(securityQuestionsList);
    }

    public List<String> getFromList(List<String> userList, String searchKeyword, int maxCount) {
        if (StringUtils.isBlank((CharSequence)searchKeyword)) {
            int endIndex = Math.min(userList.size(), maxCount + 20);
            return userList.subList(maxCount, endIndex);
        }
        LinkedList<String> userToReturn = new LinkedList<String>();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())})).returningAtMost(-1);
        Iterable usersFromSystem = this.crowdService.search((Query)query);
        int count = 0;
        for (User user : usersFromSystem) {
            String username = user.getName();
            if (!userList.contains(username)) continue;
            if (count >= maxCount) {
                userToReturn.add(username);
                if (userToReturn.size() == 20) {
                    return userToReturn;
                }
            }
            ++count;
        }
        return userToReturn;
    }

    public Integer getSizeOfUserList(List<String> userList, String searchKeyword) {
        if (StringUtils.isBlank((CharSequence)searchKeyword.trim())) {
            return userList.size();
        }
        LOGGER.debug("Counting the size for UserList with search keyword :" + searchKeyword);
        int count = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())})).returningAtMost(-1);
        Iterable usersFromSystem = this.crowdService.search((Query)query);
        for (User user : usersFromSystem) {
            if (!userList.contains(user.getName())) continue;
            ++count;
        }
        return count;
    }

    public Integer getTotalUserCount(String searchQuery) {
        try {
            LOGGER.debug("Fetching users count with searchQuery for total users count=" + searchQuery);
            EntityQuery query = StringUtils.isBlank((CharSequence)searchQuery) || StringUtils.isEmpty((CharSequence)searchQuery) ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery.trim()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery.trim())})).returningAtMost(-1);
            return ((Collection)this.crowdService.search((Query)query)).size();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching the all users size", e);
            return 0;
        }
    }

    public List<String> getFromListForGroups(List<String> groupList, String searchKeyword, int maxCount) {
        LOGGER.debug("Inside getFromListForGroups");
        if (maxCount == -1) {
            return groupList;
        }
        LinkedList<String> groupToReturn = new LinkedList<String>();
        int currentCount = 0;
        for (String groupName : groupList) {
            if (currentCount < maxCount) {
                ++currentCount;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)searchKeyword) || StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)searchKeyword.trim())) {
                groupToReturn.add(groupName);
                ++currentCount;
            }
            if (groupToReturn.size() != 20) continue;
            LOGGER.debug("groupToReturn = " + groupToReturn);
            return groupToReturn;
        }
        LOGGER.debug("groupToReturn = " + groupToReturn);
        return groupToReturn;
    }

    public List<String> getUserFromCrowdUsingUsername(final String usernameSearchKeyword, final int userCount) {
        final ArrayList<String> availableUser = new ArrayList<String>();
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                EntityQuery query = userCount == -1 ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1) : (StringUtils.isBlank((CharSequence)usernameSearchKeyword) || StringUtils.isEmpty((CharSequence)usernameSearchKeyword) ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(userCount).returningAtMost(20) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword.trim()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword.trim())})).startingAt(userCount).returningAtMost(20));
                LOGGER.debug("Query for User : " + query);
                Iterable usersFromSystem = MoTwoFactorPluginHandler.this.crowdService.search((Query)query);
                for (User user : usersFromSystem) {
                    if (availableUser.contains(user.getName())) continue;
                    availableUser.add(user.getName());
                }
                return availableUser;
            }
        });
        return availableUser;
    }

    public Integer getSizeOfGroupsList(List<String> groupList, String searchKeyword) {
        LOGGER.debug("Inside getFromListForGroups");
        LinkedList<String> groupToReturn = new LinkedList<String>();
        if (StringUtils.isBlank((CharSequence)searchKeyword.trim())) {
            return groupList.size();
        }
        for (String groupName : groupList) {
            if (!StringUtils.isBlank((CharSequence)searchKeyword) && !StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)searchKeyword.trim())) continue;
            groupToReturn.add(groupName);
        }
        LOGGER.debug("groupToReturn = " + groupToReturn);
        return groupToReturn.size();
    }

    public Integer getTotalGroupsSize(String groupnameSearchKeyword) {
        EntityQuery query = StringUtils.isBlank((CharSequence)groupnameSearchKeyword) || StringUtils.isEmpty((CharSequence)groupnameSearchKeyword) ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1) : QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupnameSearchKeyword)).returningAtMost(-1);
        try {
            return ((Collection)this.crowdService.search((Query)query)).size();
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while fetching the users");
            return 0;
        }
    }

    public List<String> getGroupsFromCrowdUsingGroupname(String groupnameSearchKeyword, int groupCount) {
        ArrayList<String> availableGroups = new ArrayList<String>();
        EntityQuery query = groupCount == -1 ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1) : (StringUtils.isBlank((CharSequence)groupnameSearchKeyword) || StringUtils.isEmpty((CharSequence)groupnameSearchKeyword) ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(groupCount).returningAtMost(20) : QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupnameSearchKeyword)).startingAt(groupCount).returningAtMost(20));
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (availableGroups.contains(group.getName())) continue;
            availableGroups.add(group.getName());
        }
        return availableGroups;
    }

    public List<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public List<String> getAllUsersInGroup(String groupName) {
        Iterable users = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        ArrayList<String> usersPresent = new ArrayList<String>();
        for (User userObject : users) {
            usersPresent.add(userObject.getName());
        }
        return usersPresent;
    }

    public List<String> getListOf2FAConfiguredUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorConfiguredUsers = this.settings.getListOf2FAConfiguredUsers();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorConfiguredUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorEnable2FAForUsers = this.settings.getEnable2FAForUsersList();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorEnable2FAForUsers.contains(username) || selectedUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledGroupsUsingGroupname(List<String> groupnameList) {
        List<String> twoFactorEnable2FAForGroups = this.settings.getEnable2FAForGroupsList();
        ArrayList<String> selectedGroups = new ArrayList<String>();
        for (String groupName : groupnameList) {
            if (!twoFactorEnable2FAForGroups.contains(groupName) || selectedGroups.contains(groupName)) continue;
            selectedGroups.add(groupName);
        }
        return selectedGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public Map<String, String> getMapOfUsernameEmail(List<String> usernameList) {
        TreeMap<String, String> usernameEmailMap = new TreeMap<String, String>();
        for (String username : usernameList) {
            UserProfile userProfile = this.userManager.getUserProfile(username);
            if (userProfile == null) {
                usernameEmailMap.put(username, "");
                continue;
            }
            usernameEmailMap.put(username, userProfile.getEmail());
        }
        return usernameEmailMap;
    }

    public void redirectToValidUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling redirectToValidUrl for User");
        String currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isEmpty((CharSequence)currentLoggedInUser) || StringUtils.isBlank((CharSequence)currentLoggedInUser)) {
            LOGGER.debug("User is not Logged in");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        } else {
            LOGGER.debug("User is Logged in : " + currentLoggedInUser);
            HttpSession session = request.getSession();
            String referer = (String)session.getAttribute("Referer");
            LOGGER.debug("Current Referer : " + referer);
            if (StringUtils.isNotBlank((CharSequence)referer) && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/inlineregistration_") && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/validate_") && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/loadingPage")) {
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(referer);
            } else if (MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request) != null) {
                String value = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request).getValue();
                LOGGER.debug("Redirect To : " + value);
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(value);
            } else if (request.getSession() != null && request.getSession().getAttribute("RELAY_STATE") != null && StringUtils.isNotEmpty((CharSequence)request.getSession().getAttribute("RELAY_STATE").toString()) && StringUtils.isNotBlank((CharSequence)request.getSession().getAttribute("RELAY_STATE").toString())) {
                LOGGER.debug("User Logged in via SSO redirecting it to relay state");
                String relay_state = request.getSession().getAttribute("RELAY_STATE").toString();
                if (!relay_state.contains(this.pluginConfiguration.getBaseUrl())) {
                    relay_state = this.pluginConfiguration.getBaseUrl().concat(relay_state);
                }
                response.sendRedirect(relay_state);
            } else {
                LOGGER.debug("Redirecting to Base URL");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    public Boolean shouldConsiderMo2FA(String username, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)username)) {
            LOGGER.debug("User is not logged in");
            return false;
        }
        Boolean twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
        if (BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
            LOGGER.debug("2FA already performed");
            return false;
        }
        LOGGER.debug("User is logged in & valid license found.");
        MoTwoFactorCommonUserSettings twoFactorUserSettings = this.settings.getUserSettings(username);
        if (this.check2FAIsEnabledForUser(username, twoFactorUserSettings, request).booleanValue()) {
            LOGGER.debug("Two Factor is enabled");
            if (this.checkIsTwofactorUrl(request)) {
                LOGGER.debug("Is twofactor URL");
                return false;
            }
            twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
            LOGGER.debug("Is Session for Verified " + twoFactorVerified);
            if (!BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
                LOGGER.debug("Is Remember me enabled : " + BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()));
                if (this.checkAndEvaluateDeviceDetails(username, request, twoFactorUserSettings).booleanValue() && BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice())) {
                    LOGGER.debug("Current Device is in Remember My device List");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Remembered Device)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
                if (BooleanUtils.toBoolean((Boolean)this.isInStoredIpAddress(currentIpAddress, this.settings.getWhitelistIpAddressWithMessages()))) {
                    LOGGER.debug("Current IP Address is in Whitelist IP Address");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Whitelisted IP)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                LOGGER.debug("2FA not performed");
                return true;
            }
            LOGGER.debug("2FA performed");
            return false;
        }
        LOGGER.debug("Two Factor is not enabled");
        return false;
    }

    private boolean checkIsTwofactorUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String contextPath = request.getContextPath();
        LOGGER.debug("URL : " + url);
        LOGGER.debug("Context Path : " + contextPath);
        if (url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2faenabledinfo") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_googleauthenticator") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_otpoveremail") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_otpoversms") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupmethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_duopushnotification") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_u2fhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otp") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otpoveremail") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otpoversms") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_duopushnotification") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_webauthnas2famethod") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_u2fhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_webauthnhardwaretoken") || url.equals(contextPath + "/plugins/servlet/webAuthn/MoSecureUtil") || url.equals(contextPath + "/plugins/servlet/webAuthn/MoSaveCredentials") || url.equals(contextPath + "/plugins/servlet/webAuthn/DataStore") || url.equals(contextPath + "/plugins/servlet/webAuthn/FinishAssertion")) {
            LOGGER.error("Is Two factor URL");
            return Boolean.TRUE;
        }
        LOGGER.error("Is not 2FA URL");
        return Boolean.FALSE;
    }

    private Boolean checkAndEvaluateDeviceDetails(String username, HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserSettings) {
        Boolean shouldIgnore2FA = Boolean.FALSE;
        if (twoFactorUserSettings.getRememberMeDeviceDetails().size() > 0) {
            String currentDeviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
            currentDeviceDetails = currentDeviceDetails.replaceAll(" ", "");
            LOGGER.debug("Current Device Details : " + currentDeviceDetails);
            String userAgent = request.getHeader("User-Agent");
            userAgent = userAgent.replaceAll(";", ":");
            userAgent = userAgent.replaceAll(" ", "");
            if (StringUtils.isNotBlank((CharSequence)currentDeviceDetails) && !StringUtils.containsIgnoreCase((CharSequence)currentDeviceDetails, (CharSequence)userAgent)) {
                LOGGER.debug("Invalid Agent Found. " + userAgent);
                currentDeviceDetails = "";
            }
            List<String> rememberMeDeviceDetails = twoFactorUserSettings.getRememberMeDeviceDetails();
            LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
            for (int i = rememberMeDeviceDetails.size() - 1; i >= 0; --i) {
                long storeTimeInMili;
                String storedDeviceDetails = rememberMeDeviceDetails.get(i);
                storedDeviceDetails = storedDeviceDetails.replaceAll(" ", "");
                long currentTimeInMili = System.currentTimeMillis();
                if (currentTimeInMili > (storeTimeInMili = Long.parseLong(storedDeviceDetails.split("=====")[1]))) {
                    rememberMeDeviceDetails.remove(i);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)currentDeviceDetails) || !StringUtils.containsIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails) && !StringUtils.startsWithIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails)) continue;
                shouldIgnore2FA = Boolean.TRUE;
            }
            twoFactorUserSettings.setRememberMeDeviceDetails(rememberMeDeviceDetails);
            LOGGER.debug("Stored Device Details After change : " + rememberMeDeviceDetails);
            this.settings.setUserSettings(username, twoFactorUserSettings);
        }
        LOGGER.debug("Is Current Device store : " + shouldIgnore2FA);
        return shouldIgnore2FA;
    }

    public String findValidUrlToRedirect(String username, HttpServletRequest request) {
        LOGGER.debug("Calling findValidUrlToRedirect");
        List<String> twoFactorConfiguredUser = this.settings.getListOf2FAConfiguredUsers();
        Boolean is2FAConfigured = twoFactorConfiguredUser.contains(username);
        String url = "";
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        List<String> configured2FAMethodsByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
        if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
            if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
                String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
                twoFactorUserClass.setUserSalt(userSpecific_salt_key);
                this.settings.setUserSettings(username, twoFactorUserClass);
            }
            List<String> backupMethod = this.settings.getBackupMethodForUserList();
            LOGGER.debug("configured2FAMethodsByUser : " + configured2FAMethodsByUser);
            LOGGER.debug("Backup Method : " + backupMethod);
            if (configured2FAMethodsByUser.size() == 0) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Showing 2FA enabled message");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2faenabledinfo");
            } else if (backupMethod.size() > 1) {
                LOGGER.debug("2FA is Not configured. Showing Backup method list");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
            } else if (backupMethod.contains("SecurityQuestion")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Security Question");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
            } else if (backupMethod.contains("OtpOverEmail")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Security Question");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
            } else if (backupMethod.contains("OtpOverSms")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- OTP over SMS");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms");
            } else if (backupMethod.contains("GoogleAuthenticator")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Google Authenticator");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
            } else if (backupMethod.contains("WebAuthn")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Wen Authn");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
            } else if (backupMethod.contains("YubikeyHardwareTokenAsU2F")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Yubikey Hardware Token");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
            } else if (backupMethod.contains("DuoPushNotification")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Duo Push Notification");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification");
            } else if (backupMethod.contains("BackupCode")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Backup Code");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode");
            } else {
                LOGGER.debug("Backup Method is disabled after configuring primary 2FA.");
                this.settings.addTo2FAConfiguredUsersList(username);
                url = this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action");
            }
        } else {
            LOGGER.debug("2FA is Configured.");
            LOGGER.debug("Enable force 2fa method for user : " + this.settings.getEnableEnforce2faMethodForUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser())) {
                String primaryMethodForUser = this.settings.getPrimary2faMethodForUser();
                LOGGER.debug("Primary method for User : " + primaryMethodForUser);
                LOGGER.debug("Current primary User method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (!StringUtils.equalsIgnoreCase((CharSequence)primaryMethodForUser, (CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    LOGGER.debug("Configured 2fa method : " + configured2FAMethodsByUser);
                    if (configured2FAMethodsByUser.contains(primaryMethodForUser)) {
                        twoFactorUserClass.setCurrent2FAMethod(primaryMethodForUser);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                    }
                }
            }
            LOGGER.debug("Should show All Configured Method TO User : " + this.settings.getShowAllConfiguredMethodToUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getShowAllConfiguredMethodToUser()) && configured2FAMethodsByUser.size() > 1) {
                LOGGER.debug("Showing the list of configured 2FA methods");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist");
            } else {
                LOGGER.debug("Current 2FA method : " + twoFactorUserClass.getCurrent2FAMethod());
                switch (twoFactorUserClass.getCurrent2FAMethod()) {
                    case "GoogleAuthenticator": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otp");
                        break;
                    }
                    case "OtpOverEmail": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoveremail");
                        break;
                    }
                    case "OtpOverSms": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoversms");
                        break;
                    }
                    case "SecurityQuestion": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion");
                        break;
                    }
                    case "DuoPushNotification": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_duopushnotification");
                        break;
                    }
                    case "WebAuthn": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_webauthnas2famethod");
                        break;
                    }
                    case "YubikeyHardwareTokenAsU2F": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_u2fhardwaretoken");
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                if (configured2FAMethodsByUser.size() > 1) {
                    LOGGER.debug("Showing the list of configured 2FA methods");
                    url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist");
                } else {
                    LOGGER.debug("Single 2FA method is configured.");
                    if (configured2FAMethodsByUser.contains("GoogleAuthenticator")) {
                        LOGGER.debug("Validating Mobile Authentication");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otp");
                    } else if (configured2FAMethodsByUser.contains("OtpOverEmail")) {
                        LOGGER.debug("Validating OTP Over Email");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoveremail");
                    } else if (configured2FAMethodsByUser.contains("OtpOverSms")) {
                        LOGGER.debug("Validating OTP Over SMS");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoversms");
                    } else if (configured2FAMethodsByUser.contains("WebAuthn")) {
                        LOGGER.debug("Validating WebAuthn as 2fa method");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_webauthnas2famethod");
                    } else if (configured2FAMethodsByUser.contains("YubikeyHardwareTokenAsU2F")) {
                        LOGGER.debug("Validating Hardware Token");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_u2fhardwaretoken");
                    } else if (configured2FAMethodsByUser.contains("SecurityQuestion")) {
                        LOGGER.debug("Validating Security Question");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion");
                    } else if (configured2FAMethodsByUser.contains("/plugins/servlet/twofactor/validate_duopushnotification")) {
                        LOGGER.debug("Validating Duo Push Notification");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_duopushnotification");
                    } else if (configured2FAMethodsByUser.contains("BackupCode")) {
                        LOGGER.debug("Validating Backup Method");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_backupcode");
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                LOGGER.debug("Removing user from configured 2FA list.");
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                configuredUser.removeAll(Collections.singleton(username));
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
                this.settings.setUserSettings(username, new MoTwoFactorCommonUserSettings());
            }
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = this.pluginConfiguration.getBaseUrl();
        }
        return url;
    }

    public String getPrimaryConfigured2faMethod(List<String> configured2FAByUserList) {
        if (configured2FAByUserList.contains("GoogleAuthenticator")) {
            return "GoogleAuthenticator";
        }
        if (configured2FAByUserList.contains("OtpOverEmail")) {
            return "OtpOverEmail";
        }
        if (configured2FAByUserList.contains("OtpOverSms")) {
            return "OtpOverSms";
        }
        if (configured2FAByUserList.contains("WebAuthn")) {
            return "WebAuthn";
        }
        if (configured2FAByUserList.contains("YubikeyHardwareTokenAsU2F")) {
            return "YubikeyHardwareTokenAsU2F";
        }
        if (configured2FAByUserList.contains("SecurityQuestion")) {
            return "SecurityQuestion";
        }
        return "";
    }

    private Boolean check2FAIsEnabledForUser(String username, MoTwoFactorCommonUserSettings twoFactorUserSettings, HttpServletRequest request) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor())) {
            List<String> excludeGroups = this.settings.getExclude2faForGroupList();
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (excludeGroups.size() > 0) {
                LOGGER.debug("Exclude Groups : " + excludeGroups);
                List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
                LOGGER.debug("User Groups : " + userGroups);
                for (String group : excludeGroups) {
                    if (!userGroups.contains(group) || !enable2FAForUsersList.contains(username)) continue;
                    LOGGER.debug("Group is present in Exclude Groups.");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Based on group)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return Boolean.FALSE;
                }
            }
            if (enable2FAForUsersList.contains(username)) {
                return Boolean.TRUE;
            }
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!disable2FAForUsersList.contains(username)) {
                if (this.settings.getEnable2FAForAllUsers().booleanValue()) {
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
                List<String> groupsOfUser = this.pluginConfiguration.getUsersGroup(username);
                for (String g : enable2FAForGroupsList) {
                    if (!groupsOfUser.contains(g)) continue;
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
        }
        return Boolean.FALSE;
    }

    public Map<String, String> getStoredIpAddressWithMessage(Map<String, String> StoredIpAddressWithMessage, String ipSearchKeyword, int limit) {
        HashMap<String, String> searchedAddressWithMessage = new HashMap();
        if (limit == -1) {
            searchedAddressWithMessage = StoredIpAddressWithMessage;
            return searchedAddressWithMessage;
        }
        for (Map.Entry<String, String> entry : StoredIpAddressWithMessage.entrySet()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)entry.getKey(), (CharSequence)ipSearchKeyword)) continue;
            searchedAddressWithMessage.put(entry.getKey(), entry.getValue());
        }
        if (searchedAddressWithMessage.size() > limit) {
            LinkedHashMap<String, String> selectedIpAddressWithMessage = new LinkedHashMap<String, String>();
            for (Map.Entry entry : searchedAddressWithMessage.entrySet()) {
                selectedIpAddressWithMessage.put((String)entry.getKey(), (String)entry.getValue());
            }
            return selectedIpAddressWithMessage;
        }
        return searchedAddressWithMessage;
    }

    public Map<String, String> getStoredIpAddresses(Map<String, String> storedIpAddresses, String ipSearchKeyword, int limit) {
        HashMap<String, String> searchedAddressWithMessage = new HashMap();
        if (limit == -1) {
            searchedAddressWithMessage = storedIpAddresses;
            return searchedAddressWithMessage;
        }
        for (Map.Entry<String, String> entry : storedIpAddresses.entrySet()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)entry.getKey(), (CharSequence)ipSearchKeyword)) continue;
            searchedAddressWithMessage.put(entry.getKey(), entry.getValue());
        }
        if (searchedAddressWithMessage.size() > limit) {
            LinkedHashMap<String, String> selectedIpAddressWithMessage = new LinkedHashMap<String, String>();
            for (Map.Entry entry : searchedAddressWithMessage.entrySet()) {
                selectedIpAddressWithMessage.put((String)entry.getKey(), (String)entry.getValue());
            }
            return selectedIpAddressWithMessage;
        }
        return searchedAddressWithMessage;
    }

    public void saveWhitelistIpAddress(String ipAddress) {
        List<String> whitelistIpAddress = this.settings.getWhitelistIpAddresses();
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress));
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress.trim()));
        whitelistIpAddress.add(ipAddress.trim());
        this.settings.setWhitelistIpAddresses(whitelistIpAddress);
    }

    public void saveWhitelistIpAddressAndMessagesInMap(String ipAddress, String ipAddressMessage) {
        Map<String, String> whitelistIpAddressAndMessagesInMap = this.settings.getWhitelistIpAddressWithMessages();
        whitelistIpAddressAndMessagesInMap.put(ipAddress, ipAddressMessage);
        this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressAndMessagesInMap);
    }

    public void saveBlacklistIpAddressAndMessagesInMap(String ipAddress, String ipAddressMessage) {
        Map<String, String> blacklistIpAddressAndMessagesInMap = this.settings.getBlacklistIpAddressWithMessages();
        blacklistIpAddressAndMessagesInMap.put(ipAddress, ipAddressMessage);
        this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressAndMessagesInMap);
    }

    public String getValidIpAddress(String ipAddress) {
        int count = ipAddress.split("\\.").length;
        String correctIpAddress = count == 1 ? ipAddress.trim() + ".*.*.*" : (count == 2 ? ipAddress.trim() + ".*.*" : (count == 3 ? ipAddress.trim() + ".*" : ipAddress));
        return correctIpAddress;
    }

    public Map<String, String> getSelectedDetailsForPaginationForIpAddress(Map<String, String> detailsList, Integer startIndex, Integer endIndex) {
        TreeMap<String, String> selectedDetailsPagination = new TreeMap<String, String>();
        int counter = -1;
        for (String entry : detailsList.keySet()) {
            if (++counter < startIndex || counter > endIndex) continue;
            selectedDetailsPagination.put(entry, detailsList.get(entry));
        }
        LOGGER.debug("Selected Details for IP Address: " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public Boolean isInStoredIpAddress(String ipAddress, Map<String, String> storedIpAddresses) {
        Boolean isPresent = Boolean.FALSE;
        LOGGER.debug("Current IP Address : " + ipAddress);
        LOGGER.debug("Stored IP Addresses : " + storedIpAddresses);
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            if (address instanceof Inet6Address) {
                LOGGER.debug("IP Address Received is IPv6");
                return isPresent;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Address was a machine name, and couldn't be found");
        }
        int ipSize = 0;
        for (String storedIpAddress : storedIpAddresses.keySet()) {
            String[] segment = storedIpAddress.split("/");
            if (segment.length == 2) {
                SubnetUtils subnetUtils = new SubnetUtils(storedIpAddress);
                if (!subnetUtils.getInfo().isInRange(ipAddress) && !StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)subnetUtils.getInfo().getBroadcastAddress()) && !StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)subnetUtils.getInfo().getNetworkAddress())) continue;
                LOGGER.debug("IP is matched with stored CIDR IP Range: " + storedIpAddress);
                isPresent = Boolean.TRUE;
                break;
            }
            if (storedIpAddress.contains(".*")) {
                storedIpAddress = StringUtils.substringBefore((String)storedIpAddress, (String)".*");
            }
            if ((ipSize = storedIpAddress.split("\\.").length) == 4) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)storedIpAddress)) continue;
                LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
                isPresent = Boolean.TRUE;
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)(storedIpAddress + "."))) continue;
            LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
            isPresent = Boolean.TRUE;
            break;
        }
        return isPresent;
    }

    public Boolean checkBruteForceInvalidAttemptAction(HttpServletRequest request) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableBruteForceProtection())) {
            HttpSession session = request.getSession();
            int count = 0;
            if (session.getAttribute("2fa_invalid_validation_attempt_count") != null) {
                count = (Integer)session.getAttribute("2fa_invalid_validation_attempt_count");
            }
            LOGGER.debug("Count : " + ++count);
            LOGGER.debug("Count : " + this.settings.getBruteForceNumberOfAttempts());
            if (count >= this.settings.getBruteForceNumberOfAttempts()) {
                try {
                    String username = this.pluginConfiguration.getCurrentLoggedInUser();
                    Boolean isNotSoloAdmin = this.shouldLockedOutUser(username);
                    if (isNotSoloAdmin.booleanValue()) {
                        this.sendEmailBruteForce(request);
                    } else {
                        this.sendAlertEmailToSoloAdmin(request, username);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to send email : " + e);
                }
                return Boolean.FALSE;
            }
            session.setAttribute("2fa_invalid_validation_attempt_count", (Object)count);
        }
        return Boolean.TRUE;
    }

    public void performBruteForceUserLockAction(String username, HttpServletRequest request) {
        long currentTimeInMili = System.currentTimeMillis();
        LOGGER.debug("currentTimeInMili : " + currentTimeInMili);
        long newTimeInMili = this.getBruteForceLockingTimeInMili() + currentTimeInMili;
        LOGGER.debug("newTimeInMili : " + newTimeInMili);
        String currentIp = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
        LOGGER.debug("Current IP : " + currentIp);
        String fieldValue = Long.toString(newTimeInMili) + "=====" + currentIp;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        lockedUserDetails.put(username, fieldValue);
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    private long getBruteForceLockingTimeInMili() {
        long newTimeInMili = 0L;
        long minutesMilis = 60000L;
        long hoursMilis = 3600000L;
        long daysMilis = 86400000L;
        String bruteForceTimeInterval = this.settings.getBruteForceTimeInterval();
        String bruteForceCustomTimeInterval = this.settings.getBruteForceCustomTimeInterval();
        Integer bruteForceCustomTimeDuration = this.settings.getBruteForceCustomTimeDuration();
        if (StringUtils.equalsIgnoreCase((CharSequence)bruteForceTimeInterval, (CharSequence)"custom")) {
            switch (bruteForceCustomTimeInterval) {
                case "minutes": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * minutesMilis;
                    break;
                }
                case "hours": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * hoursMilis;
                    break;
                }
                case "days": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * daysMilis;
                }
            }
        } else {
            switch (bruteForceTimeInterval) {
                case "15 minutes": {
                    newTimeInMili = 15L * minutesMilis;
                    break;
                }
                case "30 minutes": {
                    newTimeInMili = 30L * minutesMilis;
                    break;
                }
                case "1 hour": {
                    newTimeInMili = hoursMilis;
                    break;
                }
                case "5 hours": {
                    newTimeInMili = 5L * hoursMilis;
                    break;
                }
                case "1 day": {
                    newTimeInMili = daysMilis;
                    break;
                }
                case "7 days": {
                    newTimeInMili = 7L * hoursMilis;
                }
            }
        }
        return newTimeInMili;
    }

    public Boolean isUserLocked(String username) {
        long currentTimeInMili;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        String fieldValue = lockedUserDetails.get(username);
        long storedTime = Long.parseLong(fieldValue.split("=====")[0]);
        if (storedTime > (currentTimeInMili = System.currentTimeMillis())) {
            return Boolean.TRUE;
        }
        lockedUserDetails.remove(username);
        this.settings.setLockedUserDetails(lockedUserDetails);
        return Boolean.FALSE;
    }

    public void performUserLogout(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        LOGGER.debug("Performing Logout for :" + username);
        HttpSession session = request.getSession();
        session.invalidate();
    }

    public Map<String, String> getLockedUserDetailsUsingUsername(String usernameSearchKeyword, int userCount) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        if (userCount == -1) {
            return lockedUserDetails;
        }
        TreeMap<String, String> tempLockedUserDetails = new TreeMap<String, String>();
        for (String username : lockedUserDetails.keySet()) {
            if (StringUtils.containsIgnoreCase((CharSequence)username, (CharSequence)usernameSearchKeyword)) {
                tempLockedUserDetails.put(username, lockedUserDetails.get(username));
            }
            if (tempLockedUserDetails.size() < userCount) continue;
            return tempLockedUserDetails;
        }
        return tempLockedUserDetails;
    }

    public Map<String, String> getSelectedDetailsForPagination(Map<String, String> detailsList, Integer startIndex, Integer endIndex) {
        TreeMap<String, String> selectedDetailsPagination = new TreeMap<String, String>();
        int count = 0;
        for (String username : detailsList.keySet()) {
            if (++count < startIndex || count > endIndex) continue;
            String fieldValue = detailsList.get(username);
            String storedDate = new Date(Long.parseLong(fieldValue.split("=====")[0])).toString();
            storedDate = storedDate + "=====" + fieldValue.split("=====")[1];
            selectedDetailsPagination.put(username, storedDate);
        }
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public void performLockedUserDetailsCleanUp() {
        LOGGER.debug("Performing Locked User Details Cleanup");
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        long currentTime = System.currentTimeMillis();
        ArrayList<String> detailsNeedsToBeRemoved = new ArrayList<String>();
        for (String username : lockedUserDetails.keySet()) {
            String fieldValue = lockedUserDetails.get(username);
            long storedValue = Long.parseLong(fieldValue.split("=====")[0]);
            if (currentTime <= storedValue) continue;
            detailsNeedsToBeRemoved.add(username);
        }
        LOGGER.debug("Locked User Details before remove : " + lockedUserDetails);
        for (String username : detailsNeedsToBeRemoved) {
            lockedUserDetails.remove(username);
        }
        LOGGER.debug("Locked User Details after remove : " + lockedUserDetails);
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    public Boolean shouldLockedOutUser(String username) {
        UserProfile user = this.userManager.getUserProfile(username);
        Boolean isAdmin = user != null && (this.userManager.isSystemAdmin(user.getUserKey()) || this.userManager.isAdmin(user.getUserKey()));
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            if (this.isOnlyUnlockedAdminUser(username).booleanValue()) {
                LOGGER.debug("Single Unlock Admin. Unable to unlock the user : " + username);
                return Boolean.FALSE;
            }
            LOGGER.debug("Not a single Admin Locked user: " + username);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    private Boolean isOnlyUnlockedAdminUser(String username) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        int numberOfUnlockedAdminUsers = 0;
        List<String> administratorUsers = this.getAllUsersInGroup("crowd-administrators");
        Iterator<String> iterator = administratorUsers.iterator();
        while (iterator.hasNext()) {
            if (numberOfUnlockedAdminUsers > 0) {
                return Boolean.FALSE;
            }
            String adminUsername = iterator.next();
            if (StringUtils.equalsIgnoreCase((CharSequence)adminUsername, (CharSequence)username) || lockedUserDetails.get(adminUsername) != null) continue;
            ++numberOfUnlockedAdminUsers;
        }
        if (numberOfUnlockedAdminUsers == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<String> generateBackupCode() {
        ArrayList<String> backupCode = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            backupCode.add(this.randomAlphaNumeric(15));
        }
        return backupCode;
    }

    public List<String> encodeBackupCode(List<String> backupCodes) {
        ArrayList<String> encryptedBackupCode = new ArrayList<String>();
        for (String backupCode : backupCodes) {
            encryptedBackupCode.add(MoTwoFactorUtility.encryptString(backupCode, this.pluginConfiguration.SECRETE_KEY));
        }
        return encryptedBackupCode;
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private String randomNumericString(int count) {
        String ALPHA_NUMERIC_STRING = "0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public Boolean isSmtpConfigured() {
        return BooleanUtils.toBoolean((Boolean)this.mailManager.isConfigured());
    }

    public Boolean isDuoPushNotificationSettingsConfigured() {
        return StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationIntegrationKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationSecretKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationHostName());
    }

    public Boolean isValidIntegrationKeyAndSecretKey(String integrationKey, String secretKey, String hostName) {
        LOGGER.info("Validating DUO IntegrationKey, SecretKey, and HostName");
        try {
            if (StringUtils.isBlank((CharSequence)integrationKey) && StringUtils.isBlank((CharSequence)secretKey) && StringUtils.isBlank((CharSequence)hostName)) {
                return true;
            }
            Http duoHttp = new Http("GET", hostName, "/auth/v2/check");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            LOGGER.debug("DUO details check Validation response: " + httpResponse);
            return jsonObject.get("stat") != null && StringUtils.equalsIgnoreCase((CharSequence)"OK", (CharSequence)jsonObject.get("stat").getAsString());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while validating Duo credentials: {}", e);
            return false;
        }
    }

    public JsonObject sendDuoPushNotificationPreauth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPushNotificationPreauth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        LOGGER.debug("integrationKey::" + integrationKey);
        LOGGER.debug("secretKey::" + secretKey);
        LOGGER.debug("hostName::" + hostName);
        Http duoHttp = new Http("POST", hostName, "/auth/v2/preauth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Push Preauth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            JsonObject result = new JsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("Json Object Response - result");
                result.addProperty("result", responseJsonObject.get("result").getAsString());
                LOGGER.debug("inside push preauth result :" + responseJsonObject.get("result").getAsString());
            }
            if (responseJsonObject.has("enroll_portal_url")) {
                LOGGER.debug("Json Object Response - enroll_portal_url");
                result.addProperty("enroll_portal_url", responseJsonObject.get("enroll_portal_url").getAsString());
                LOGGER.debug("inside push preauth enroll_portal_url :" + responseJsonObject.get("enroll_portal_url").getAsString());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return null;
        }
    }

    public Boolean sendDuoPushNotificationAuth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPushNotificationAuth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        Http duoHttp = new Http("POST", hostName, "/auth/v2/auth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("factor", "push");
        duoHttp.addParam("hostname", "Crowd Server");
        duoHttp.addParam("device", "auto");
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside sendDuoPushNotificationAuth try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Push Auth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("return::" + StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString()));
                return StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
        LOGGER.debug("return value::False");
        return Boolean.FALSE;
    }

    public Boolean sendDuoPhoneCallAuth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPhoneCallAuth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        Http duoHttp = new Http("POST", hostName, "/auth/v2/auth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("factor", "mobile_otp");
        duoHttp.addParam("hostname", "Crowd Server");
        duoHttp.addParam("device", "auto");
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside sendDuoPhoneCallAuth try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Call Auth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("return::" + StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString()));
                return StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
        LOGGER.debug("return value::False");
        return Boolean.FALSE;
    }

    public Boolean isSmsGatewayConfigured() {
        if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
            return StringUtils.isNotBlank((CharSequence)this.settings.getApiKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getCustomerKey());
        }
        return StringUtils.isNotBlank((CharSequence)this.settings.getSmsGatewayUrl());
    }

    public void sendOtpOnSms(HttpServletRequest request, UserProfile user, String countryCode, String mobileNumber) throws Exception {
        LOGGER.debug("countryCode: " + countryCode);
        LOGGER.debug("mobileNumber: " + mobileNumber);
        HttpSession session = request.getSession(true);
        long currentTimeInMili = System.currentTimeMillis();
        if (session.getAttribute("last_otp_sent_time") != null) {
            long lastOtpSentTime = (Long)session.getAttribute("last_otp_sent_time");
            LOGGER.debug("currentTimeInMili: " + currentTimeInMili);
            LOGGER.debug("lastOtpSentTime: " + lastOtpSentTime);
            if (currentTimeInMili - lastOtpSentTime < 15000L) {
                return;
            }
        } else {
            LOGGER.debug("last_otp_sent_time not found in session");
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
            HttpPost postRequest = this.sendOtpUsingMiniOrangeGateway(currentTimeInMili, user.getEmail(), countryCode, mobileNumber);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String status = IOUtils.toString(new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Response payload: " + status);
                JSONObject jsonResponseObject = new JSONObject(status);
                String txId = jsonResponseObject.get("txId").toString();
                LOGGER.debug("txId: " + txId);
                session.setAttribute("txId", (Object)txId);
            }
        } else {
            String otp = this.randomNumericString(this.settings.getOtpLength());
            String message = this.settings.getSmsTemplate();
            message = StringUtils.replace((String)message, (String)"$$username$$", (String)user.getUsername());
            message = StringUtils.replace((String)message, (String)"$$otp$$", (String)otp);
            String smsGatewayUrl = this.settings.getSmsGatewayUrl();
            smsGatewayUrl = StringUtils.replace((String)smsGatewayUrl, (String)"##phone##", (String)(countryCode + mobileNumber));
            smsGatewayUrl = StringUtils.replace((String)smsGatewayUrl, (String)"##message##", (String)URLEncoder.encode(message, "UTF-8"));
            HttpPost postRequest = new HttpPost(smsGatewayUrl);
            postRequest.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String status = IOUtils.toString(new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Response payload: " + status);
            } else {
                LOGGER.error("Response Entity NOT found. Returning EMPTY string.");
            }
            LOGGER.debug("otp: " + otp);
            session.setAttribute("sms_otp_code", (Object)otp);
        }
        httpClient.close();
        long newTimeInMili = (long)(this.settings.getOtpValidityDuration() * 60000) + currentTimeInMili;
        session.setAttribute("otp_expiry_time", (Object)newTimeInMili);
        session.setAttribute("last_otp_sent_time", (Object)currentTimeInMili);
        session.setAttribute("mobileNumber", (Object)mobileNumber);
        session.setAttribute("countryCode", (Object)countryCode);
        LOGGER.debug("SMS sent successfully");
    }

    public HttpPost sendOtpUsingMiniOrangeGateway(long currentTimeInMili, String emailAddress, String countryCode, String mobileNumber) throws Exception {
        String generateUrl = "https://login.xecurify.com/moas/api/auth/challenge";
        String customerKey = this.settings.getCustomerKey();
        String apiKey = this.settings.getApiKey();
        String jsonRequestString = "{\"customerKey\":\"" + customerKey + "\" ,\"email\" : \" " + emailAddress + "\" ,\"phone\":\"" + countryCode + mobileNumber + "\" ,\"authType\" : \"SMS\" ,\"transactionName\" : \"CUSTOM-OTP-VERIFICATION\"}";
        return this.getPostRequestObjectForMiniOrangeGateway(currentTimeInMili, jsonRequestString, generateUrl, customerKey, apiKey);
    }

    public HttpPost getPostRequestObjectForMiniOrangeGateway(long currentTimeInMili, String jsonRequestString, String url, String customerKey, String apiKey) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String stringToHash = customerKey + String.valueOf(currentTimeInMili) + apiKey;
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] messageDigest = md.digest(stringToHash.getBytes());
        BigInteger no = new BigInteger(1, messageDigest);
        String hashValue = no.toString(16);
        while (hashValue.length() < 32) {
            hashValue = "0" + hashValue;
        }
        HttpPost postRequest = new HttpPost(url);
        StringEntity input = new StringEntity(jsonRequestString);
        input.setContentType("application/json");
        postRequest.setEntity((HttpEntity)input);
        postRequest.setHeader("Customer-Key", customerKey);
        postRequest.setHeader("Timestamp", String.valueOf(currentTimeInMili));
        postRequest.setHeader("Authorization", hashValue);
        return postRequest;
    }

    public Boolean validateOtpUsingMiniOrangeGateway(long currentTimeInMili, String otp, String txId) throws Exception {
        String validateUrl = "https://login.xecurify.com/moas/api/auth/validate";
        String customerKey = this.settings.getCustomerKey();
        String apiKey = this.settings.getApiKey();
        String jsonRequestString = "{\"txId\":\"" + txId + "\",\"token\":\"" + otp + "\"}";
        HttpPost postRequest = this.getPostRequestObjectForMiniOrangeGateway(currentTimeInMili, jsonRequestString, validateUrl, customerKey, apiKey);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
        LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
        if (response.getEntity() != null) {
            LOGGER.debug("Response Entity found. Reading Response payload.");
            String status = IOUtils.toString(new InputStreamReader(response.getEntity().getContent()));
            LOGGER.debug("Response payload: " + status);
            JSONObject jsonResponseObject = new JSONObject(status);
            String responseStatus = jsonResponseObject.get("status").toString();
            if (StringUtils.isNotBlank((CharSequence)responseStatus) && StringUtils.equals((CharSequence)responseStatus, (CharSequence)"FAILED")) {
                LOGGER.error("OTP validation failed: " + jsonResponseObject.get("message").toString());
                httpClient.close();
                return false;
            }
        } else {
            LOGGER.error("Response Entity NOT found. Returning EMPTY string.");
        }
        httpClient.close();
        return response.getStatusLine().getStatusCode() == 200;
    }

    public String sendOtpOnEmail(HttpServletRequest request, UserProfile crowdUser) throws Exception {
        LOGGER.debug("Calling sendOtpOnEmail.");
        HttpSession session = request.getSession(true);
        long currentTimeInMili = System.currentTimeMillis();
        if (session.getAttribute("last_email_otp_sent_time") != null) {
            long lastEmailOtpSentTime = (Long)session.getAttribute("last_email_otp_sent_time");
            LOGGER.debug("currentTimeInMili: " + currentTimeInMili);
            LOGGER.debug("lastEmailOtpSentTime: " + lastEmailOtpSentTime);
            if (currentTimeInMili - lastEmailOtpSentTime < 15000L) {
                return "OTP mail not sent";
            }
        } else {
            LOGGER.debug("last_email_otp_sent_time not found in session");
        }
        String otp = this.randomNumericString(this.settings.getOtpLength());
        String subject = this.settings.getEmailSubject();
        String body = this.settings.getEmailTemplate();
        body = StringUtils.replaceIgnoreCase((String)body, (String)"$$username$$", (String)crowdUser.getUsername());
        body = StringUtils.replaceIgnoreCase((String)body, (String)"$$otp$$", (String)otp);
        InternetAddress address = new InternetAddress(crowdUser.getEmail());
        LOGGER.debug("Address :: " + address.getAddress());
        this.mailManager.sendHtmlEmail(address, subject, body, body);
        HttpSession httpSession = request.getSession(true);
        httpSession.setAttribute("otp_code", (Object)otp);
        long newTimeInMili = (long)(this.settings.getOtpValidityDuration() * 60000) + currentTimeInMili;
        httpSession.setAttribute("otp_expiry_time", (Object)newTimeInMili);
        session.setAttribute("last_email_otp_sent_time", (Object)currentTimeInMili);
        LOGGER.debug("Send email successfully");
        return "Success";
    }

    public void sendEmailBruteForce(HttpServletRequest request) throws Exception {
        if (this.isSmtpConfigured().booleanValue()) {
            String subject = "Your Crowd account is temporarily locked.";
            String body = this.settings.getEmailTemplateBruteForce();
            String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
            if (body.contains("$$ipaddress$$")) {
                body = body.replace("$$ipaddress$$", currentIpAddress);
            }
            InternetAddress address = new InternetAddress(this.pluginSettings.getCustomerEmail());
            LOGGER.debug("Address :: " + address.getAddress());
            this.mailManager.sendHtmlEmail(address, subject, body, body);
            LOGGER.debug("Successfully sent an email for locked account.");
        } else {
            LOGGER.debug("Crowd account is temporarily locked but no mail is sent as no mail server is configured.");
        }
    }

    public void sendAlertEmailToSoloAdmin(HttpServletRequest request, String username) throws Exception {
        if (this.isSmtpConfigured().booleanValue()) {
            String subject = "Your Crowd account may be hacked.";
            String body = this.settings.getEmailTemplateBruteForceForSoloAdmin();
            String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
            if (body.contains("$$ipaddress$$")) {
                body = body.replace("$$ipaddress$$", currentIpAddress);
            }
            if (body.contains("$$username$$")) {
                body = body.replace("$$username$$", username);
            }
            InternetAddress address = new InternetAddress(this.pluginSettings.getCustomerEmail());
            LOGGER.debug("Address :: " + address.getAddress());
            this.mailManager.sendHtmlEmail(address, subject, body, body);
            LOGGER.debug("Successfully sent an alert email to solo admin.");
        } else {
            LOGGER.debug("Unable to send an alert email to solo admin as no mail server is configured.");
        }
    }

    public String getInlineRegistrationBackupMethodUrl(HttpServletRequest request, List<String> configuredMethodsByUser) {
        String url = "";
        List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
        ArrayList<String> remainingMethods = new ArrayList<String>();
        for (String method : enabledBackupMethodList) {
            if (configuredMethodsByUser.contains(method)) continue;
            remainingMethods.add(method);
        }
        if (remainingMethods.size() == 0) {
            LOGGER.debug("No backup method Enabled or backup method is already configured.");
            return url;
        }
        if (remainingMethods.size() > 1) {
            LOGGER.debug("Redirecting to Backup Method List");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
        } else if (remainingMethods.contains("SecurityQuestion")) {
            LOGGER.debug("Redirecting to Security Question");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
        } else if (remainingMethods.contains("OtpOverEmail")) {
            LOGGER.debug("Redirecting to OTP Over Email");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
        } else if (remainingMethods.contains("OtpOverSms")) {
            LOGGER.debug("Redirecting to OTP Over SMS");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms");
        } else if (remainingMethods.contains("GoogleAuthenticator")) {
            LOGGER.debug("Redirecting to Mobile Authenticator");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
        } else if (remainingMethods.contains("YubikeyHardwareTokenAsU2F")) {
            LOGGER.debug("Redirecting to Yubikey Hardware");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
        } else if (remainingMethods.contains("WebAuthn")) {
            LOGGER.debug("Redirecting to Web Authn");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
        } else if (remainingMethods.contains("DuoPushNotification")) {
            LOGGER.debug("Redirecting to Duo Push Notification");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification");
        } else if (remainingMethods.contains("BackupCode")) {
            LOGGER.debug("Redirecting to Backup Code");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            HttpSession session = request.getSession();
            session.setAttribute("considering_backup_method", (Object)true);
        }
        return url;
    }

    public Boolean isSystemAdmin() {
        Boolean isAdmin = Boolean.FALSE;
        String CurrentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)CurrentLoggedInUser)) {
            UserProfile userProfile = this.userManager.getUserProfile(CurrentLoggedInUser);
            LOGGER.debug("Current Logged In User : " + CurrentLoggedInUser);
            if (this.userManager.isAdmin(userProfile.getUserKey())) {
                isAdmin = Boolean.TRUE;
                return isAdmin;
            }
        }
        return isAdmin;
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/rest/customer/key", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders("16555", "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    Long customerId = Long.valueOf(jsonObj.getString("id"));
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "Couldn't verify your accoumt. Please contact support at support-atlassian@miniorange.atlassian.net", null);
            }
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("An account verification error occurred ", e);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(String customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", customerId);
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public Boolean verifyLicense(MoTwoFactorCrowdPluginSettings pluginSettings, String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", pluginSettings.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", pluginSettings.getBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(pluginSettings.getCustomerID(), pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("Verify license response: " + response);
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                LOGGER.debug(" statusNode : " + statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    this.getLicencedUsers(pluginSettings);
                    pluginSettings.setCustomerLicenseKey(key);
                    pluginSettings.setLicenseVerified(Boolean.TRUE);
                    return true;
                }
                return false;
            }
            LOGGER.debug("Please contact support. Response String: " + response);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying license key", e);
            return false;
        }
    }

    public void getLicencedUsers(MoTwoFactorCrowdPluginSettings pluginSettings) {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", pluginSettings.getCustomerID());
            jsonObject.put("applicationName", "crowd_2FA_premium_plan");
            String json = jsonObject.toString();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(pluginSettings.getCustomerID(), pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("check customer license response: " + response);
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")).toString(), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    pluginSettings.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    pluginSettings.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    LOGGER.debug("No. of licensed users = " + licensedUsers);
                    if (licensedUsers > 0) {
                        pluginSettings.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            LOGGER.error("Please contact support. Response String: " + response);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("an error occurred while getting licensed users", e);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean checkLicenseCondition() {
        if (this.pluginSettings.isNoOfUserExceed().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue()) {
            if (this.pluginSettings.getMailSent().booleanValue()) {
                this.deactivateAndRemoveCustomerAccount();
                return false;
            }
            LOGGER.debug("Sending User limit exceeded email");
            this.sendEmail("You have exceeded license users count for miniOrange Crowd 2FA plugin. Please update you license otherwise plugin will stop working after 7 days from now", "Hello,<br><br>You have exceeded allowed users count (" + this.pluginSettings.getLicencedUsers() + " users) on your Crowd Server. <br>Your account will be deactivated after 7 days.Please upgrade your license.Contact us at support-atlassian@miniorange.atlassian.net to get more information and to upgrade your license.<br><br>Thanks,<br>miniOrange");
            this.pluginSettings.setMailSent(true);
        } else {
            this.pluginSettings.setMailSent(false);
        }
        return true;
    }

    public void sendEmail(String subject, String content) {
        try {
            LOGGER.debug("Sending email alert");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", this.pluginSettings.getCustomerID());
            jsonObject.put("sendEmail", true);
            JSONObject emailObject = new JSONObject();
            emailObject.put("customerKey", this.pluginSettings.getCustomerID());
            emailObject.put("fromEmail", "info@miniorange.com");
            emailObject.put("bccEmail", "info@miniorange.com");
            emailObject.put("fromName", "miniOrange");
            emailObject.put("toEmail", this.pluginSettings.getCustomerEmail());
            emailObject.put("toName", this.pluginSettings.getCustomerEmail());
            emailObject.put("subject", subject);
            emailObject.put("content", content);
            jsonObject.put("email", emailObject);
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/notify/send", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(this.pluginSettings.getCustomerID(), this.pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("Email alert response: " + response);
        }
        catch (Exception e) {
            LOGGER.error("Error ocurred while sending email " + e);
        }
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            if (this.pluginSettings.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", this.pluginSettings.getCustomerLicenseKey());
                jsonObject.put("customerKey", this.pluginSettings.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", this.pluginSettings.getBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(this.pluginSettings.getCustomerID(), this.pluginSettings.getCustomerAPIKey()));
                LOGGER.debug("Deactivate license response: " + response);
            }
            this.pluginSettings.removeCustomerAccount();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while deactivating the license.", e);
            this.pluginSettings.removeCustomerAccount();
        }
    }

    private static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public void storeAuditLogs(String username, String ip, String action, String loginMethod) {
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        Date newdate = new Date(timeMilliSecs);
        this.logEntityService.add(username, ip, newdate, action, loginMethod);
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public MailConfigurationService getMailConfigurationService() {
        return this.mailConfigurationService;
    }

    public void setMailConfigurationService(MailConfigurationService mailConfigurationService) {
        this.mailConfigurationService = mailConfigurationService;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public int checkNumberOfLoginAttemptsLeft(HttpServletRequest request, String username) {
        if (this.settings.getEnableBruteForceProtection().booleanValue()) {
            if (!this.isOnlyUnlockedAdminUser(username).booleanValue()) {
                HttpSession session = request.getSession();
                Integer loginAttemptsLeft = session.getAttribute("2fa_invalid_validation_attempt_count") != null ? Integer.valueOf(this.settings.getBruteForceNumberOfAttempts() - (Integer)session.getAttribute("2fa_invalid_validation_attempt_count")) : Integer.valueOf(this.settings.getBruteForceNumberOfAttempts() - 0);
                return loginAttemptsLeft;
            }
            LOGGER.debug("Unlimited login attempts available as user is a solo admin");
            return -1;
        }
        LOGGER.debug("Unlimited login attempts available as Brute Force Protection is not enabled");
        return -1;
    }

    public String getPageAccessForCurrentUser(String pageName) {
        if (this.isSystemAdmin().booleanValue()) {
            return "readwrite";
        }
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        String accessType = "none";
        Map<String, String> groupsWithAdminPagesAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        List<String> userGroups = this.pluginConfiguration.getAllGroupsOfUser(username);
        List<Object> pageAccessGroups_read = new ArrayList();
        if (groupsWithAdminPagesAccessMap.get(pageName + "_read") != null) {
            pageAccessGroups_read = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_read").split(","));
        }
        List<Object> pageAccessGroups_readwrite = new ArrayList();
        if (groupsWithAdminPagesAccessMap.get(pageName + "_readwrite") != null) {
            pageAccessGroups_readwrite = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_readwrite").split(","));
        }
        if (!(userGroups.isEmpty() || pageAccessGroups_read.isEmpty() && pageAccessGroups_readwrite.isEmpty())) {
            for (String group : userGroups) {
                if (!pageAccessGroups_read.isEmpty() && pageAccessGroups_read.contains(group)) {
                    accessType = "read";
                }
                if (pageAccessGroups_readwrite.isEmpty() || !pageAccessGroups_readwrite.contains(group)) continue;
                accessType = "readwrite";
                break;
            }
        }
        return accessType;
    }

    public List<String> getUserAccessiblePages() {
        ArrayList<String> pages = new ArrayList<String>();
        Boolean isSystemAdmin = this.isSystemAdmin();
        Map<String, String> groupsWithAdminPagesAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
        List<String> pageNames = this.getPluginPages();
        for (String pageName : pageNames) {
            if (isSystemAdmin.booleanValue()) {
                pages.add(pageName + "_readwrite");
                continue;
            }
            List<Object> pageAccessGroups_read = new ArrayList();
            if (groupsWithAdminPagesAccessMap.get(pageName + "_read") != null) {
                pageAccessGroups_read = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_read").split(","));
            }
            List<Object> pageAccessGroups_readwrite = new ArrayList();
            if (groupsWithAdminPagesAccessMap.get(pageName + "_readwrite") != null) {
                pageAccessGroups_readwrite = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_readwrite").split(","));
            }
            for (String string : pageAccessGroups_read) {
                if (!userGroups.contains(string)) continue;
                pages.add(pageName + "_read");
            }
            for (String string : pageAccessGroups_readwrite) {
                if (!userGroups.contains(string)) continue;
                pages.add(pageName + "_readwrite");
            }
        }
        return pages;
    }

    public List<String> getPluginPages() {
        ArrayList<String> pageNames = new ArrayList<String>();
        pageNames.add("Basic_Configuration");
        pageNames.add("User_Management");
        pageNames.add("IP_Restriction");
        pageNames.add("Advanced_Settings");
        pageNames.add("Audit_Logs");
        pageNames.add("LookAndFeel");
        pageNames.add("TroubleShooting");
        return pageNames;
    }

    public Boolean isTwoFactorVerifiedOrIsTwoFactorDisabled(HttpServletRequest request) {
        Boolean verifiedOrDisabled = Boolean.FALSE;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            List<String> enable2FAUserList = this.settings.getEnable2FAForUsersList();
            Boolean enabledForUser = enable2FAUserList.contains(username);
            Boolean verified = MoTwoFactorUtility.isTwoFactorVerified(request);
            Boolean enabledForCrowd = this.settings.getEnableTwoFactor();
            if (!enabledForCrowd.booleanValue() || !enabledForUser.booleanValue() || verified.booleanValue()) {
                verifiedOrDisabled = Boolean.TRUE;
            } else {
                List<String> excludeGroups = this.settings.getExclude2faForGroupList();
                if (excludeGroups.size() > 0) {
                    List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
                    for (String group : excludeGroups) {
                        if (!userGroups.contains(group)) continue;
                        verifiedOrDisabled = Boolean.TRUE;
                        break;
                    }
                }
            }
            LOGGER.debug("Two Factor Verified Or Two Factor Disabled :" + verifiedOrDisabled);
            return verifiedOrDisabled;
        }
        LOGGER.error("No Logged in user found");
        return false;
    }
}

