/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util.migration;

import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class TransferUtils {
    private static final Logger log = Logger.getLogger(TransferUtils.class);

    public static void copyUser(User fromUser, User toUser) {
        toUser.setEmail(fromUser.getEmail());
        toUser.setFullName(fromUser.getFullName());
    }

    public static void copyPropertySet(PropertySet fromPropertySet, PropertySet toPropertySet) {
        Collection fromKeys = fromPropertySet.getKeys();
        for (String key : fromKeys) {
            Object val2 = fromPropertySet.getAsActualType(key);
            try {
                if (!(val2 instanceof Timestamp) && val2 != null) {
                    log.info((Object)("copying key [" + key + "] with value [" + val2.toString() + "]"));
                    toPropertySet.setAsActualType(key, val2);
                    continue;
                }
                if (val2 == null) {
                    log.info((Object)("ignoring null data for key - " + key));
                    continue;
                }
                long milliseconds = 0L;
                Date date = null;
                if (val2 instanceof Timestamp) {
                    milliseconds = ((Timestamp)val2).getTime();
                    date = new Date(milliseconds);
                }
                if (date == null) continue;
                toPropertySet.setDate(key, date);
            }
            catch (PropertyException e) {
                System.out.println("It's borking on ... " + key);
                e.printStackTrace();
            }
        }
    }
}

