/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.repository;

import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.repository.Repository;
import java.util.HashMap;

public class DefaultRepository
implements Repository {
    protected String key;
    protected String name;
    protected String description;

    public DefaultRepository() {
    }

    public DefaultRepository(String key) {
        this.key = key;
    }

    public DefaultRepository(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public DefaultRepository(String key, String name, String description) {
        this.key = key;
        this.name = name;
        this.description = description;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.name = (String)args.get("name");
        this.description = (String)args.get("description");
        this.key = (String)args.get("key");
        InitializationCheck.validateArgs(args, new String[]{"key"}, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository repo = (Repository)o;
        if (this.description != null ? !this.description.equals(repo.getDescription()) : repo.getDescription() != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(repo.getKey()) : repo.getKey() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(repo.getName()) : repo.getName() != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return super.toString() + ": key = " + this.key + ", name = " + this.name + ", description = " + this.description;
    }
}

