/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPUser;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class DefaultLDAPUserFactory
implements LDAPUserFactory {
    protected LDAPRepository repository;

    public DefaultLDAPUserFactory() {
    }

    public DefaultLDAPUserFactory(LDAPRepository repository) {
        this.repository = repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository"}, this);
    }

    public User getUser(Attributes attrs, String distinguishedName) throws RepositoryException {
        DefaultLDAPUser user = null;
        if (distinguishedName.indexOf(this.repository.getBaseUserNamespace()) == -1) {
            distinguishedName = distinguishedName + "," + this.repository.getBaseUserNamespace();
        }
        try {
            Attribute emailAttr;
            Attribute uidAttr = attrs.get(this.repository.getUsernameAttribute());
            user = new DefaultLDAPUser((String)uidAttr.get(), distinguishedName);
            if (uidAttr == null) {
                return null;
            }
            if (UtilTimerStack.isActive()) {
                String stackKey = this.getClass().getName() + "_getUser(" + user.getName() + ")";
                UtilTimerStack.push((String)stackKey);
            }
            Attribute givenNameAttr = attrs.get(this.repository.getFirstnameAttribute());
            Attribute surNameAttr = attrs.get(this.repository.getSurnameAttribute());
            if (givenNameAttr != null) {
                String givenName = (String)givenNameAttr.get();
                String surName = "";
                if (surNameAttr != null) {
                    surName = (String)surNameAttr.get();
                }
                givenName = givenName.concat(" ");
                user.setFullName(givenName.concat(surName));
            }
            if ((emailAttr = attrs.get(this.repository.getEmailAttribute())) != null) {
                user.setEmail((String)emailAttr.get());
            }
        }
        catch (NamingException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            String stackKey = this.getClass().getName() + "_getUser(" + user.getName() + ")";
            UtilTimerStack.pop((String)stackKey);
        }
        return user;
    }

    public Collection getUsers(Enumeration userNamingEnumeration) throws RepositoryException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getUserCollection"));
        }
        ArrayList<User> users = new ArrayList<User>();
        while (userNamingEnumeration.hasMoreElements()) {
            SearchResult result = (SearchResult)userNamingEnumeration.nextElement();
            Attributes attrs = result.getAttributes();
            users.add(this.getUser(attrs, result.getName()));
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getUserCollection"));
        }
        return users;
    }

    public Entity getEntity(Attributes attrs, String distinguishedName) throws RepositoryException {
        if (distinguishedName.startsWith("\"") && distinguishedName.endsWith("\"")) {
            distinguishedName = distinguishedName.substring(1, distinguishedName.length() - 1);
        }
        return this.getUser(attrs, distinguishedName);
    }
}

