/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.delegation.DelegatingListGroupManager;
import com.atlassian.user.impl.delegation.DelegatingListUserManager;
import com.atlassian.user.impl.delegation.properties.DelegatingPropertySetFactory;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.impl.delegation.search.query.DelegatingEntityQueryParser;
import com.atlassian.user.impl.delegation.security.authentication.DelegatingAuthenticator;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultDelegationAccessor
implements DelegationAccessor {
    private static final Logger log = Logger.getLogger(DefaultDelegationAccessor.class);
    private HashMap repositoryAccessors = new HashMap();
    private List delegationOrder;
    private DelegatingAuthenticator delegatingAuthenticator;
    private DelegatingListGroupManager delegatingGroupManager;
    private DelegatingPropertySetFactory delegatingPropertySetFactory;
    private DelegatingRepository delegatingRepository;
    private DelegatingListUserManager delegatingUserManager;
    private DelegatingEntityQueryParser delegatingEntityQueryParser;
    private ArrayList authenticators = new ArrayList();
    private ArrayList userManagers = new ArrayList();
    private ArrayList groupManagers = new ArrayList();
    private ArrayList repositories = new ArrayList();
    private ArrayList propertySetFactories = new ArrayList();
    private ArrayList entityQueryParsers = new ArrayList();

    public DefaultDelegationAccessor() {
        this.delegationOrder = new ArrayList();
    }

    public Repository getRepository() {
        return this.delegatingRepository;
    }

    public UserManager getUserManager() {
        return this.delegatingUserManager;
    }

    public GroupManager getGroupManager() {
        return this.delegatingGroupManager;
    }

    public PropertySetFactory getPropertySetFactory() {
        return this.delegatingPropertySetFactory;
    }

    public Authenticator getAuthenticator() {
        return this.delegatingAuthenticator;
    }

    public EntityQueryParser getEntityQueryParser() {
        return this.delegatingEntityQueryParser;
    }

    public void orderDelegation(String[] keyOrder) {
        String key;
        int i;
        if (keyOrder == null || keyOrder.length == 0) {
            keyOrder = this.delegationOrder.toArray(new String[1]);
        }
        for (i = 0; i < keyOrder.length; ++i) {
            key = keyOrder[i];
            if (this.repositoryAccessors.containsKey(key)) continue;
            log.fatal((Object)("Missing key, cannot locate a repository with key [" + key + "] to delegate."));
        }
        for (i = 0; i < keyOrder.length; ++i) {
            key = keyOrder[i];
            RepositoryAccessor repoAccessor = this.getRepositoryAccessor(key);
            if (repoAccessor.getAuthenticator() != null) {
                this.authenticators.add(repoAccessor.getAuthenticator());
            }
            if (repoAccessor.getUserManager() != null) {
                this.userManagers.add(repoAccessor.getUserManager());
            }
            if (repoAccessor.getGroupManager() != null) {
                this.groupManagers.add(repoAccessor.getGroupManager());
            }
            if (repoAccessor.getPropertySetFactory() != null) {
                this.propertySetFactories.add(repoAccessor.getPropertySetFactory());
            }
            if (repoAccessor.getEntityQueryParser() != null) {
                this.entityQueryParsers.add(repoAccessor.getEntityQueryParser());
            }
            this.repositories.add(repoAccessor.getRepository());
        }
        this.createDelegation();
    }

    public String[] getDelegationOrder() {
        return this.delegationOrder.toArray(new String[1]);
    }

    private void createDelegation() {
        this.createDelegatingUserManager();
        this.createDelegatingAuthenticator();
        this.createDelegatingPropertySetFactory();
        this.createDelegatingGroupManager();
        this.createDelegatingEntityQueryParser();
    }

    private void createDelegatingEntityQueryParser() {
        this.delegatingEntityQueryParser = new DelegatingEntityQueryParser(this.entityQueryParsers);
    }

    private void createDelegatingGroupManager() {
        this.delegatingGroupManager = new DelegatingListGroupManager(this.groupManagers);
    }

    private void createDelegatingPropertySetFactory() {
        this.delegatingPropertySetFactory = new DelegatingPropertySetFactory(this.propertySetFactories);
    }

    private void createDelegatingUserManager() {
        this.delegatingUserManager = new DelegatingListUserManager(this.userManagers);
    }

    private void createDelegatingAuthenticator() {
        this.delegatingAuthenticator = new DelegatingAuthenticator(this.delegatingUserManager, this.authenticators);
    }

    public RepositoryAccessor getRepositoryAccessor(String key) {
        return (RepositoryAccessor)this.repositoryAccessors.get(key);
    }

    public List getRepositoryAccessors() {
        return new ArrayList(this.repositoryAccessors.values());
    }

    public void addRepositoryAccessor(String key, RepositoryAccessor accessor) {
        this.repositoryAccessors.put(key, accessor);
        this.delegationOrder.add(key);
    }
}

