/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.model.SimpleValueType;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.SpecialType;

public class SimpleValue
extends Special {
    private final SimpleValueType simpleValueType;
    public static final SimpleValue FALSE = new SimpleValue(SimpleValueType.FALSE);
    public static final SimpleValue TRUE = new SimpleValue(SimpleValueType.TRUE);
    public static final SimpleValue NULL = new SimpleValue(SimpleValueType.NULL);
    public static final SimpleValue UNDEFINED = new SimpleValue(SimpleValueType.UNDEFINED);
    private final int value;

    public SimpleValue(SimpleValueType simpleValueType) {
        super(SpecialType.SIMPLE_VALUE);
        this.value = simpleValueType.getValue();
        this.simpleValueType = simpleValueType;
    }

    public SimpleValue(int value) {
        super(value <= 23 ? SpecialType.SIMPLE_VALUE : SpecialType.SIMPLE_VALUE_NEXT_BYTE);
        this.value = value;
        this.simpleValueType = SimpleValueType.ofByte(value);
    }

    public SimpleValueType getSimpleValueType() {
        return this.simpleValueType;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleValue) {
            SimpleValue other = (SimpleValue)object;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }
}

