/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.AbstractEncoder;
import co.nstant.in.cbor.model.HalfPrecisionFloat;
import java.io.OutputStream;

public class HalfPrecisionFloatEncoder
extends AbstractEncoder<HalfPrecisionFloat> {
    public HalfPrecisionFloatEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    @Override
    public void encode(HalfPrecisionFloat dataItem) throws CborException {
        this.write(249);
        int bits = HalfPrecisionFloatEncoder.fromFloat(dataItem.getValue());
        this.write(bits >> 8 & 0xFF);
        this.write(bits >> 0 & 0xFF);
    }

    public static int fromFloat(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val2 = 4096 + fbits & Integer.MAX_VALUE;
        if (val2 >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val2 < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val2 >= 0x38800000) {
            return sign | val2 - 0x38000000 >>> 13;
        }
        if (val2 < 0x33000000) {
            return sign;
        }
        val2 = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val2 - 102) >>> 126 - val2;
    }
}

