/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Special;
import java.io.InputStream;

public class MapDecoder
extends AbstractDecoder<Map> {
    public MapDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
    }

    @Override
    public Map decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            return this.decodeInfinitiveLength();
        }
        return this.decodeFixedLength(length);
    }

    private Map decodeInfinitiveLength() throws CborException {
        Map map = new Map();
        map.setChunked(true);
        if (this.decoder.isAutoDecodeInfinitiveMaps()) {
            DataItem key;
            while (!Special.BREAK.equals(key = this.decoder.decodeNext())) {
                map.put(key, this.decoder.decodeNext());
            }
        }
        return map;
    }

    private Map decodeFixedLength(long length) throws CborException {
        Map map = new Map((int)length);
        for (long i = 0L; i < length; ++i) {
            map.put(this.decoder.decodeNext(), this.decoder.decodeNext());
        }
        return map;
    }
}

