/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.DataItemListener;
import co.nstant.in.cbor.decoder.ArrayDecoder;
import co.nstant.in.cbor.decoder.ByteStringDecoder;
import co.nstant.in.cbor.decoder.MapDecoder;
import co.nstant.in.cbor.decoder.NegativeIntegerDecoder;
import co.nstant.in.cbor.decoder.SpecialDecoder;
import co.nstant.in.cbor.decoder.TagDecoder;
import co.nstant.in.cbor.decoder.UnicodeStringDecoder;
import co.nstant.in.cbor.decoder.UnsignedIntegerDecoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class CborDecoder {
    private final InputStream inputStream;
    private final UnsignedIntegerDecoder unsignedIntegerDecoder;
    private final NegativeIntegerDecoder negativeIntegerDecoder;
    private final ByteStringDecoder byteStringDecoder;
    private final UnicodeStringDecoder unicodeStringDecoder;
    private final ArrayDecoder arrayDecoder;
    private final MapDecoder mapDecoder;
    private final TagDecoder tagDecoder;
    private final SpecialDecoder specialDecoder;
    private boolean autoDecodeInfinitiveArrays = true;
    private boolean autoDecodeInfinitiveMaps = true;
    private boolean autoDecodeInfinitiveByteStrings = true;
    private boolean autoDecodeInfinitiveUnicodeStrings = true;

    public CborDecoder(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        this.inputStream = inputStream;
        this.unsignedIntegerDecoder = new UnsignedIntegerDecoder(this, inputStream);
        this.negativeIntegerDecoder = new NegativeIntegerDecoder(this, inputStream);
        this.byteStringDecoder = new ByteStringDecoder(this, inputStream);
        this.unicodeStringDecoder = new UnicodeStringDecoder(this, inputStream);
        this.arrayDecoder = new ArrayDecoder(this, inputStream);
        this.mapDecoder = new MapDecoder(this, inputStream);
        this.tagDecoder = new TagDecoder(this, inputStream);
        this.specialDecoder = new SpecialDecoder(this, inputStream);
    }

    public static List<DataItem> decode(byte[] bytes) throws CborException {
        return new CborDecoder(new ByteArrayInputStream(bytes)).decode();
    }

    public List<DataItem> decode() throws CborException {
        DataItem dataItem;
        LinkedList<DataItem> dataItems = new LinkedList<DataItem>();
        while ((dataItem = this.decodeNext()) != null) {
            dataItems.add(dataItem);
        }
        return dataItems;
    }

    public void decode(DataItemListener dataItemListener) throws CborException {
        Objects.requireNonNull(dataItemListener);
        DataItem dataItem = this.decodeNext();
        while (dataItem != null) {
            dataItemListener.onDataItem(dataItem);
            dataItem = this.decodeNext();
        }
    }

    public DataItem decodeNext() throws CborException {
        int symbol;
        try {
            symbol = this.inputStream.read();
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
        if (symbol == -1) {
            return null;
        }
        switch (MajorType.ofByte(symbol)) {
            case ARRAY: {
                return this.arrayDecoder.decode(symbol);
            }
            case BYTE_STRING: {
                return this.byteStringDecoder.decode(symbol);
            }
            case MAP: {
                return this.mapDecoder.decode(symbol);
            }
            case NEGATIVE_INTEGER: {
                return this.negativeIntegerDecoder.decode(symbol);
            }
            case UNICODE_STRING: {
                return this.unicodeStringDecoder.decode(symbol);
            }
            case UNSIGNED_INTEGER: {
                return this.unsignedIntegerDecoder.decode(symbol);
            }
            case SPECIAL: {
                return this.specialDecoder.decode(symbol);
            }
            case TAG: {
                return this.tagDecoder.decode(symbol);
            }
        }
        throw new CborException("Not implemented major type " + symbol);
    }

    public boolean isAutoDecodeInfinitiveArrays() {
        return this.autoDecodeInfinitiveArrays;
    }

    public void setAutoDecodeInfinitiveArrays(boolean autoDecodeInfinitiveArrays) {
        this.autoDecodeInfinitiveArrays = autoDecodeInfinitiveArrays;
    }

    public boolean isAutoDecodeInfinitiveMaps() {
        return this.autoDecodeInfinitiveMaps;
    }

    public void setAutoDecodeInfinitiveMaps(boolean autoDecodeInfinitiveMaps) {
        this.autoDecodeInfinitiveMaps = autoDecodeInfinitiveMaps;
    }

    public boolean isAutoDecodeInfinitiveByteStrings() {
        return this.autoDecodeInfinitiveByteStrings;
    }

    public void setAutoDecodeInfinitiveByteStrings(boolean autoDecodeInfinitiveByteStrings) {
        this.autoDecodeInfinitiveByteStrings = autoDecodeInfinitiveByteStrings;
    }

    public boolean isAutoDecodeInfinitiveUnicodeStrings() {
        return this.autoDecodeInfinitiveUnicodeStrings;
    }

    public void setAutoDecodeInfinitiveUnicodeStrings(boolean autoDecodeInfinitiveUnicodeStrings) {
        this.autoDecodeInfinitiveUnicodeStrings = autoDecodeInfinitiveUnicodeStrings;
    }
}

