<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/userdetails.js">;
            AJS.$(document).ready(function() {
                AJS.$(".aui-nav li").removeClass("aui-nav-selected");
                AJS.$("#USERDETAILS").addClass("aui-nav-selected");
                if (AJS.$("#excludeUsersFromGroup").length > 0 ) {
                    AJS.$("#excludeUsersFromGroup").auiSelect2({
                        placeholder: 'Select the Crowd Groups',
                        ajax: {
                            url: AJS.contextPath() + '/plugins/servlet/twofactor/moapi',
                            data: function (params) {
                                var query = {
                                    search: params,
                                    action: 'fetchGroups'
                                }
                                return query;
                            },
                            results: function (data, page) {
                                return {
                                    results: data.results
                                };
                            },
                        },
                        multiple: true
                    });
                    var excludeGroups = [];
                    <#foreach group in excludeGroupsList>
                    var groupName = '${group}';
                    excludeGroups.push({
                        "id": groupName,
                        "text": groupName
                    });
                    </#foreach>
                    AJS.$("#excludeUsersFromGroup").auiSelect2('data', excludeGroups);
                }
            });
        </script>

        <style>
            <#include "*/css/userdetails.css">;
        </style>
	</head>

	<body>
    <#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane mo-aui-page-panel-content" id="settings"  role="tabpanel" >
        <#if pageAccessType.equals("read")>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2>User Management</h2>
        <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
            <div class="aui-navgroup-inner">
                <div id="navbar" class="aui-navgroup-primary">
                    <div class="tab tab-config">
                        <ul class="aui-nav">
                            <li>
                                <#if (userManagementSelectedAction == "UserAction")>
                                    <a class="tablinks active" onclick="performActionChange('UserAction')">2FA for Users</a>
                                <#else>
                                    <a class="tablinks" onclick="performActionChange('UserAction')">2FA for Users</a>
                                </#if>
                            </li>
                            <li>
                                <#if (userManagementSelectedAction == "GroupAction")>
                                <a class="tablinks active" onclick="performActionChange('GroupAction')">2FA for Groups</a>
                                <#else>
                                    <a class="tablinks" onclick="performActionChange('GroupAction')">2FA for Groups</a>
                                </#if>
                            </li>
                            <li>
                                <#if (userManagementSelectedAction == "LockedUserAction")>
                                    <a class="tablinks active" onclick="performActionChange('LockedUserAction')">Locked Users Accounts</a>
                                <#else>
                                    <a class="tablinks" onclick="performActionChange('LockedUserAction')">Locked Users Accounts</a>
                                </#if>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
        <br>

        <#if (userManagementSelectedAction == "UserAction")>
            <div id="userDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst" >
                        You can perform 2FA action like Enabling/Disabling/Resetting 2FA for particular users using the 2FA For User action.</br>
                        You can follow the below steps for applying the 2FA actions for any Users.
                    </p>

                    <ol>
                        <li>Search user by name for which you want to perform <b>Enable/Disable/Reset 2FA</b>.</li>
                        <li>Click on <b>Enable 2FA/Disable 2FA/Reset 2FA</b> link of the respective user.</li>
                    </ol>
                </div>

                <form id="userdetails-user-form" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="userDetailsSubmitted" value="true"/>
                    <input type="hidden" name="exportUsersUrl" id="exportUsersUrlId" value="${exportUsersUrl}"/>

                    <div class ="field-group">
                        <table style="width:100%; margin-left:-230px;" name="2faUserDetails" id="2faUserDetails" >
                            <tbody>
                            <tr>
                                <td width="41%">
                                    <label for="totalLicensedUsers"> Total Users : </label>
                                    <span style="margin-top: 5px;"> ${totalUsersInCrowd}</span>
                                </td>
                                <td width="35%">
                                    <label for="total2faEnabledUsers"> 2FA Enabled Users : </label>
                                    <span style="margin-top: 5px;">${total2faEnabledUsers}</span>
                                </td>
                                <td>
                                    <label for="total2faConfiguredUsers">2FA Configured Users : </label>
                                    <span style="margin-top: 5px;">${total2faConfiguredUsers}</span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <br>

                    </br>
                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                                <#if (pageAccessType.equals("readwrite"))>
                                    Bulk 2FA Action :&nbsp;
                                    <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected Users">
                                            <option value="Enable 2FA For Selected Users">Enable 2FA</option>
                                            <option value="Disable 2FA For Selected Users">Disable 2FA</option>
                                            <option value="Reset 2FA For Selected Users">Reset 2FA</option>
                                        </optgroup>
                                        <optgroup label="All Users">
                                            <option value="Enable 2FA For All Users">Enable 2FA</option>
                                            <option value="Disable 2FA For All Users">Disable 2FA</option>
                                            <option value="Reset 2FA For All Users">Reset 2FA</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>&nbsp;
                                </#if>
                                <label for="userSearchFilter" <#if (pageAccessType != "" && pageAccessType == "readwrite")> style="margin-left:75px;" </#if> >Apply search on :</label>
                                <select class="select" name="userSearchFilter" id="userSearchFilter" class="userSearchFilter" style="width: 200px;">

                                    <option id="userSearchFilterAllUsers" value="AllUsers" ${(userSearchFilter == "AllUsers")?then('selected', '')}>All Users</option>

                                    <option id="userSearchFilterEnabledUsers" value="EnabledUsers" ${(userSearchFilter == "EnabledUsers")?then('selected', '')}>2FA Enabled Users</option>

                                    <option id="userSearchFilterDisabledUsers" value="DisabledUsers" ${(userSearchFilter == "DisabledUsers")?then('selected', '')}>2FA Disabled Users</option>

                                    <option id="userSearchFilterConfiguredUsers" value="ConfiguredUsers" ${(userSearchFilter == "ConfiguredUsers")?then('selected', '')}>2FA Configured Users</option>

                                </select>&nbsp;
                                <input type="text"  id="usernameSearchKeyword" name="usernameSearchKeyword" value="${usernameSearchKeyword}" placeholder="Enter username/email" class="text long-field" style="width: 200px"/>
                                <input type='submit' value='Search' id='search-username-button' style="margin-left:2px;" class="aui-button aui-button-primary"/>&nbsp;
                                <a class="aui-button" onclick="exportUsers()" resolved="" style="float: right;">
                                    <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                                </a>


                            </p>
                    <#if (currentPageUsersList.size() > 0)>
                            <hr class="header"/>
                            <table class="aui"  style="table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th id="number" style="width:8%;">
                                            <input type="checkbox" value="true" name="selectAllUsers" id="selectAllUsers" onclick="return toggleAllUsers()"/> &nbsp;
                                            #
                                        </th>
                                        <th id="username">Username</th>
                                        <th id="email">Email</th>
                                        <th id="fullName">Full Name</th>
                                        <#if (pageAccessType.equals("readwrite"))>
                                            <th id="action">Action</th>
                                        </#if>
                                    </tr>
                                </thead>
                                <tbody>
                                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                                    <#assign loopCount = startIndex>
                                    <#foreach username in currentPageUsersList>
                                        <#assign trId = "tr"+username>
                                        <tr id="${trId}"
                                            <#if (enable2FAForUserList.contains(username) != true)>
                                                style="background-color: #f5f5f5;"
                                            </#if>
                                        >
                                            <td headers="number">
                                                <#assign selectedUserId = "selectedUser"+loopCount>
                                                <input type="checkbox" value="${username}" name="selectedUser" id="${selectedUserId}"/> &nbsp;
                                                ${loopCount}
                                            </td>


                                            <#assign tdId = "td_username_"+loopCount >
                                            <td headers="username" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${username}</td>
                                            
                                            <#assign tdEmailId = "td_email_"+loopCount >
                                            <td headers="username" id="${tdEmailId}" class="hideElement" onclick="openCloseElemenet('${tdEmailId}')">${userManager.getUserProfile(username).getEmail()}</td>

                                            <#assign tdFullNameId = "td_Fullname_"+loopCount >
                                            <td headers="fullName" id="${tdFullNameId}" class="hideElement" onclick="openCloseElemenet('${tdFullNameId}')">${userManager.getUserProfile(username).getFullName()!"-"}</td>
<#--                                            <#if (pageAccessType.equals("readwrite"))>-->
                                                <td headers="action">
                                                    <p>
                                                        <#if (enable2FAForUserList.contains(username))>
                                                            <#assign spanId = "span"+username>
                                                            <span id="${spanId}">
                                                                <a onclick="return disable2FAForUser('${username}')">Disable 2FA</a>
                                                            </span>
                                                        <#else>
                                                            <#assign spanId = "span"+username>
                                                            <span id="${spanId}">
                                                                <a onclick="return enable2FAForUser('${username}')">Enable 2FA</a>
                                                            </span>
                                                        </#if>
                                                        <#if (configured2FAUserList.contains(username))>
                                                            <#assign resetSpanId = "resetspan"+username>
                                                            <span id="${resetSpanId}">
                                                            &nbsp;|&nbsp;
                                                            <a onclick="return reset2FAForUser('${username}')">Reset 2FA</a>
                                                            </span>
                                                        </#if>
                                                    </p>
                                                </td>
<#--                                           </#if>-->
                                        </tr>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                                </tbody>
                            </table>
                            </br>
                            <table style="width:100%">
                                <tr>
                                    <td>
                                        <p>Displaying users <strong>${startIndex}</strong> to
                                        <#if (totalUsers < endIndex)>
                                            <strong>${totalUsers}</strong>
                                        <#else>
                                            <strong>${endIndex}</strong>
                                        </#if>
                                        of <strong>${totalUsers}</strong>.</p>
                                    </td>
                                    <td>
                                        <#if (totalUsers > numberOfRecordsPerPage)>
                                            <ol class="aui-nav aui-nav-pagination" style="float: right;">
                                                <#if (selectedPage != 1)>
                                                    <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                    <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}"> First</a></li>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}">&lt;&lt; Prev</a></li>
                                                </#if>

                                                <#assign loopCount = 1>
                                                <#assign Startloopdisplay = selectedPage + 3>
                                                <#assign Endloopdisplay = selectedPage - 3>


                                                <#foreach currentPage in numberOfPagesList>
                                                    <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                    <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                    <#if (selectedPage == loopCount)>
                                                        <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                    <#else>
                                                        <#if ( loopCount >= Endloopdisplay  && selectedPage >= loopCount )>
                                                            <li>
                                                            <li>
                                                                <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}">${loopCount}</a>
                                                            </li>
                                                            </li>
                                                        <#elseif (loopCount <= Startloopdisplay  && selectedPage <= loopCount )>
                                                            <li>
                                                            <li>
                                                                <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}">${loopCount}</a>
                                                            </li>
                                                            </li>
                                                        </#if>
                                                    </#if>
                                                    <#assign loopCount = loopCount + 1>
                                                </#foreach>

                                                <#if (selectedPage != numberOfPagesList.size())>
                                                    <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                    <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}">Next &gt;&gt;</a></li>
                                                    <#if (totalUsers % 20==0)>
                                                        <#assign lastIndexStart = totalUsers - 20>
                                                    <#else>
                                                        <#assign lastIndexStart = totalUsers - totalUsers%20>
                                                    </#if>
                                                    <#assign lastIndexEnd = lastIndexStart + 20>
                                                    <#assign lastIndexStart = lastIndexStart + 1>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${lastIndexStart}&endIndex=${lastIndexEnd}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}">Last </a></li>
                                                </#if>
                                            </ol>
                                        </#if>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    <#else>
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">#</th>
                                        <th id="username">Username</th>
                                        <th id="email">Email</th>
                                        <th id="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="4">
                                            <p style="width:100%" align="center">
                                                No user record found.
                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                    </#if>
                </form>
            </div> <!--End of USER Details Div -->
        <#elseif (userManagementSelectedAction == "GroupAction")>
        <div id="groupDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst">
                        You can perform 2FA action like Enabling/Disabling 2FA for particular Groups using the 2FA for Group action.</br>
                        You can follow the below steps for applying the 2FA actions for any Groups.
                    </p>

                    <ol>
                        <li>Search Group by name for which you want to perform <b>Enable/Disable 2FA</b>.</li>
                        <li>Click on <b>Enable 2FA/Disable 2FA</b> link of the respective group for Enabling/Disabling the 2FA for all the users from the Group.</li>
                    </ol>
                </div>

                <br>
                <hr class="header" />
                <form id="details-group-form-1" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="groupDetailsSubmitted" value="true"/>
                    <input type="hidden" name="currentForm" value="Form1"/>
                    <input type="hidden" name="exportGroupsUrl" id="exportGroupsUrlId" value="${exportGroupsUrl}"/>
                    <div id="excludeGroups">
                        <h3 class="subsection_title">Skip 2FA for Groups</h3>
                        <div class ="field-group">
                            <label for="excludeGroups">Skip 2FA for Groups :</label>
                            <input class="select long-field" name="excludeGroups" id="excludeUsersFromGroup" style="width: 250px">
                            <#if (pageAccessType.equals("readwrite"))>
                                <div style="margin-top: -33px;margin-left: 270px;">
                                    <input type="submit" value="Apply" id="search-group-button" class="aui-button aui-button-primary" resolved="">
                                </div>
                            </#if>
                            <div class="description">It will never ask for the 2FA from the users of the selected Group(s).<br>
                            </div>
                        </div>

                        <br>
                    </div>
                </form>
            <div id="enableDisbale2fa">
                <h3 class="subsection_title">Enable/Disable 2FA for Groups</h3>
                <form id="details-group-form" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="groupDetailsSubmitted" value="true"/>
                    <input type="hidden" name="currentForm" value="Form2"/>
                    <input type="hidden" name="exportGroupsUrl" id="exportGroupsUrlId" value="${exportGroupsUrl}"/>
                    <div class ="field-group" style="margin-top:10px;">
                        <label for="total2faEnabledGroups">Total 2FA Enabled Groups : </label>
                        <p style="margin-top: 5px;">${total2faEnabledGroups}</p>
                    </div>
                    <br>
                    <div class ="field-group" style="padding-left: 20px;">
                            <p>
                                <#if (pageAccessType.equals("readwrite"))>
                                    Bulk 2FA Action :&nbsp;
                                    <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected Groups">
                                            <option value="Enable 2FA For Selected Groups">Enable 2FA</option>
                                            <option value="Disable 2FA For Selected Groups">Disable 2FA</option>
                                        </optgroup>
                                        <optgroup label="All Groups">
                                            <option value="Enable 2FA For All Groups">Enable 2FA</option>
                                            <option value="Disable 2FA For All Groups">Disable 2FA</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>&nbsp;
                                </#if>
                                <label for="groupSearchFilter" <#if (pageAccessType != "" && pageAccessType == "readwrite")> style="margin-left:75px;" </#if>>Apply search on :</label>
                                <select class="select" name="groupSearchFilter" id="groupSearchFilter" class="groupSearchFilter" style="width: 200px;">
                                        <option id="groupSearchFilterAllGroups" value="AllGroups"
                                                ${(groupSearchFilter == "AllGroups")?then('selected', '')}>All Groups</option>
                                        <option id="groupSearchFilterEnabledGroups" value="EnabledGroups"
                                                ${(groupSearchFilter == "EnabledGroups")?then('selected', '')}>2FA Enabled Groups</option>
                                </select>&nbsp;
                                <input type="text"  id="groupSearchKeyword" name="groupSearchKeyword" value="${groupSearchKeyword}" placeholder="Enter Group name" class="text long-field" style="width: 200px"/>
                                <input type='submit' value='Search' id='search-group-button' style="margin-left:2px;" class="aui-button aui-button-primary"/>
                                <a class="aui-button" onclick="exportGroups()" resolved="" style="float: right;">
                                    <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                                </a>
                            </p>
                    <#if (currentPageGroupsList.size() > 0)>
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">
                                            <input type="checkbox" value="true" name="selectAllGroups" id="selectAllGroups" onclick="return toggleAllGroups()"/> &nbsp;
                                            #
                                        </th>
                                        <th id="groupname">Group Name</th>
                                        <#if (pageAccessType.equals("readwrite"))>
                                            <th id="action">Action</th>
                                        </#if>
                                    </tr>
                                </thead>
                                <tbody>
                                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                                    <#assign loopCount = startIndex>
                                    <#foreach groupname in currentPageGroupsList>
                                        <#assign trId = "tr"+groupname>
                                        <tr id="${trId}"
                                            <#if (!enable2FAForGroupList.contains(groupname))>
                                                style="background-color: #f5f5f5;"
                                            </#if>
                                        >
                                            <td headers="number">
                                                <#assign selectedGroupId = "selectedGroup"+loopCount>
                                                <input type="checkbox" value="${groupname}" name="selectedGroup" id="${selectedGroupId}"/> &nbsp;
                                                ${loopCount}
                                            </td>
                                            <td headers="groupname">${groupname}</td>
<#--                                            <#if (pageAccessType.equals("readwrite"))>-->
                                                <td headers="action">
                                                    <p>
                                                        <#if (enable2FAForGroupList.contains(groupname))>
                                                            <#assign spanId = "span"+groupname>
                                                            <span id="${spanId}">
                                                                <a onclick="return disable2FAForGroup('${groupname}')">Disable 2FA</a>
                                                            </span>
                                                        <#else>
                                                            <#assign spanId = "span"+groupname>
                                                            <span id="${spanId}">
                                                                <a onclick="return enable2FAForGroup('${groupname}')">Enable 2FA</a>
                                                            </span>
                                                        </#if>
                                                    </p>
                                                </td>
<#--                                            </#if>-->
                                        </tr>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                                </tbody>
                            </table>
                            </br>
                            <table style="width:100%">
                                <tr>
                                    <td>
                                        <p>Displaying groups <strong>${startIndex}</strong> to
                                            <#if (totalGroups < endIndex)>
                                                <strong>${totalGroups}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${totalGroups}</strong>.</p>
                                    </td>
                                    <td>
                                        <#if (totalGroups > numberOfRecordsPerPage)>
                                            <ol class="aui-nav aui-nav-pagination" style="float: right;">
                                                <#if (selectedPage != 1)>
                                                    <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                    <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}"> First</a></li>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">&lt;&lt; Prev</a></li>
                                                </#if>

                                                <#assign loopCount = 1>
                                                <#assign Startloopdisplay = selectedPage + 3>
                                                <#assign Endloopdisplay = selectedPage - 3>

                                                <#foreach currentPage in numberOfPagesList>
                                                    <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                    <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                    <#if (selectedPage == loopCount)>
                                                        <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                    <#else>
                                                        <#if (loopCount >= Endloopdisplay  && selectedPage >= loopCount )>
                                                            <li>
                                                            <li>
                                                                <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">${loopCount}</a>
                                                            </li>
                                                            </li>
                                                        <#elseif (loopCount <= Startloopdisplay  && selectedPage <= loopCount )>
                                                            <li>
                                                            <li>
                                                                <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">${loopCount}</a>
                                                            </li>
                                                            </li>
                                                        </#if>
                                                    </#if>
                                                    <#assign loopCount = loopCount + 1>
                                                </#foreach>

                                                <#if (selectedPage != numberOfPagesList.size())>
                                                    <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                    <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">Next &gt;&gt;</a></li>
                                                    <#if (totalGroups % 20==0)>
                                                        <#assign lastIndexStart = totalGroups - 20>
                                                    <#else>
                                                        <#assign lastIndexStart = totalGroups - totalGroups%20>
                                                    </#if>
                                                    <#assign lastIndexEnd = lastIndexStart +20>
                                                    <#assign lastIndexStart = lastIndexStart + 1>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${lastIndexStart}&endIndex=${lastIndexEnd}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">Last </a></li>
                                                </#if>
                                            </ol>
                                        </#if>
                                    </td>
                                </tr>
                            </table>
                    <#else>
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">#</th>
                                        <th id="groupname">Group Name</th>
                                        <th id="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="4">
                                            <p style="width:100%" align="center">
                                                No group record found.
                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                    </#if>
                    </div>
                </form>
            </div>
        </div> <!--End of GROUP Details Div -->
        <#else>
            <div id="lockedUserDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst">
                        This section allows you to manage locked users.</br>
                        You can follow the below steps for unlocking the user.
                    </p>

                    <ol>
                        <li>Search User by username for which you want to Unlock.</li>
                        <li>Click on <b>Unlock</b> action against the respective User to Unlock the user.</li>
                    </ol>
                </div>

                <form id="locked-userdetails-form" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="lockedUserDetailsSubmitted" value="true"/>

                    <div class ="field-group" style="padding-left: 172px;">
                        <label for="userSearch">Search for Username :</label>
                        <input type="text"  id="usernameSearchKeyword" name="usernameSearchKeyword" value="${usernameSearchKeyword}"
                               placeholder="Enter Username" class="text long-field" style="width: 200px;  "/>&nbsp;&nbsp;
                        <input type='submit' value='Search' id='search-user-button' class="aui-button aui-button-primary"/>
                    </div>
                    </br>

                    <#if (currentPageLockedUserDetails.size() > 0)>
                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                                <#if (pageAccessType.equals("readwrite"))>
                                    Bulk 2FA Action :&nbsp;
                                    <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected Users">
                                            <option value="Remove Selected Locked Users">Remove</option>
                                        </optgroup>
                                        <optgroup label="All Users">
                                            <option value="Remove All Locked Users">Remove</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>&nbsp;
                                </#if>
                            </p>
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">
                                            <input type="checkbox" value="true" name="selectAllLockedUsers" id="selectAllLockedUsers" onclick="return toggleAllLockedUsers()"/> &nbsp;
                                            #
                                        </th>
                                        <th id="username" style="width:45%">Username</th>
                                        <th id="expiryDate">Locking Expiry Date</th>
                                        <th id="ipAddress">IP Address</th>
                                        <#if (pageAccessType.equals("readwrite"))>
                                            <th id="action">Action</th>
                                        </#if>
                                    </tr>
                                </thead>
                                <tbody>
                                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                                    <#assign loopCount = startIndex>
                                    <#foreach username in currentPageLockedUserDetails.keySet()>
                                        <#assign trId = "tr"+username>
                                        <tr id="${trId}">
                                            <td headers="number">
                                                <#assign selectedLockedUserId = "selectedLockedUser"+loopCount>
                                                <input type="checkbox" value="${username}" name="selectedLockedUser" id="${selectedLockedUserId}"/> &nbsp;
                                                ${loopCount}
                                            </td>
                                            <#if (username.length() >= 40)>
                                                <#assign tdId = "td_username_"+ loopCount>
                                                <td headers="username" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${username}</td>
                                            <#else>
                                                <td headers="username">${username}</td>
                                            </#if>
                                            <#assign rowValue = currentPageLockedUserDetails.get(username)>
                                            <#assign count = 0>
                                            <#list rowValue?split("=====") as fieldValue>
                                                <#if fieldValue != "">
                                                    <#if count == 0>
                                                        <td headers="expiryDate">${fieldValue}</td>
                                                    <#else>
                                                        <td headers="ipAddress">${fieldValue}</td>
                                                    </#if>
                                                    <#assign count = count + 1>
                                                </#if>
                                            </#list>
                                            <#if (pageAccessType.equals("readwrite"))>
                                                <td headers="action">
                                                    <p>
                                                        <span>
                                                            <a onclick="return removeLockedUser('${username}')">Remove</a>
                                                        </span>
                                                    </p>
                                                </td>
                                            </#if>
                                        </tr>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                                </tbody>
                            </table>
                            </br>
                            <table style="width:100%">
                                <tr>
                                    <td>
                                        <p>Displaying Users <strong>${startIndex}</strong> to
                                        <#if (lockedUserDetails.size() < endIndex)>
                                            <strong>${lockedUserDetails.size()}</strong>
                                        <#else>
                                            <strong>${endIndex}</strong>
                                        </#if>
                                        of <strong>${lockedUserDetails.size()}</strong>.</p>
                                    </td>
                                    <td>
                                        <#if (lockedUserDetails.size() > numberOfRecordsPerPage)>
                                            <ol class="aui-nav aui-nav-pagination content-navigation">
                                                <#if (selectedPage != 1)>
                                                    <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                    <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}-">&lt;&lt; Prev</a></li>
                                                </#if>

                                                <#assign loopCount = 1>

                                                <#foreach currentPage in numberOfPagesList>
                                                    <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                    <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                    <#if (selectedPage == loopCount)>
                                                        <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                    <#else>
                                                        <li><a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}">${loopCount}</a></li>
                                                    </#if>
                                                    <#assign loopCount = loopCount + 1>
                                                </#foreach>

                                                <#if (selectedPage != numberOfPagesList.size())>
                                                    <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                    <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}">Next &gt;&gt;</a></li>
                                                </#if>
                                            </ol>
                                        </#if>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    <#else>
                        <div class ="field-group" style="padding-left: 20px;">
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">#</th>
                                        <th id="username">Username</th>
                                        <th id="expiryDate">Locking Expiry Date</th>
                                        <th id="ipAddress">IP Address</th>
                                        <th id="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="5">
                                            <p style="width:100%" align="center">
                                                No user record found.
                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </#if>
                </form>
            </div> <!--End of LOCKED Details Div -->
        </#if>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>