<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">
        <script>
            <#include "*/js/advancesettings.js">;
        </script>
        <style>
            <#include "*/css/advancedsettings.css">;
        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane mo-aui-page-panel-content" id="settings"  role="tabpanel" >
        <#if showWarningMssg == true>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>Some of the configurations from <b>Access to Plugin Pages</b> are not saved!</p>
            </div>
        </#if>
        <#if pageAccessType.equals("read")>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2 style="margin:0px;">Advanced Options</h2>
        <hr class="header"/>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>

            <div id="authenticationSpecificMethod">
                <h3 class="subsection_title"> User Flow Configurations </h3>
                <div class="field-group" style="padding-left: 250px;">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="allowToReconfigureMethod" value="true" label="Allow to reconfigure" name="allowToReconfigureMethod"
                                ${(allowToReconfigureMethod == true)?then('checked="true"', '')}>
                        <label for="allowToReconfigureMethod" class="toggle">
                        <div class="checkmark"></div>
                        <div class="cross-div">
                            <div class="cross cross-left"></div>
                            <div class="cross cross-right"></div>
                        </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;Allow to reconfigure/reset 2FA method</span>
                    <div class="description">
                        If this option is enabled, user will be able to reconfigure the configured 2FA method.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <div class="main-toggle-div">
                        <input class= "input-checkbox" type="checkbox" id="enableEnforceCurrentMethod" value="true" onclick="validateEnforcePrimaryMethod()"
                                    label="Enforce primary method" name="enableEnforceCurrentMethod"
                                ${(enableEnforceCurrentMethod == true)?then('checked="true"', '')}>
                        <label for="enableEnforceCurrentMethod" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div">
                                <div class="cross cross-left"></div>
                                <div class="cross cross-right"></div>
                            </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;Enforce Current/Primary Method for User</span>
                    <div class="description">
                        With this option, admin can forcefully set the primary method for user. So the users are always redirected to the selected 2fa method for validation.
                    </div>
                </div>

                <div id="primaryMethodForUserDiv" ${(enableEnforceCurrentMethod != true)?then('style="display:none"', '')}>
                    <div class="field-group" style="padding-left: 250px;">
                        <label>Primary method for user : </label>
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 20%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator"
                                           value="GoogleAuthenticator" ${(primaryMethodForUser == "GoogleAuthenticator")?then('checked="true"', '')} />
                                    <label for="primaryMethodGoogleAuthenticator">Mobile Authenticator</label>
                                </td>

                                <td style="width: 25%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodHardwareToken"
                                           value="YubikeyHardwareTokenAsU2F" ${(primaryMethodForUser == "YubikeyHardwareTokenAsU2F")?then('checked="true"', '')} />
                                    <label for="primaryMethodHardwareToken">Yubikey Hardware Token</label>
                                </td>

                                <td style="width: 25%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryDuoPushNotification"
                                           value="DuoPushNotification" ${(primaryMethodForUser == "DuoPushNotification")?then('checked="true"', '')} />
                                    <label for="primaryDuoPushNotification">Duo Push Notification</label>
                                </td>


                            </tr>
                            <tr>
                                <td>
                                    <br>
                                </td>
                            </tr>
                            <tr>

                                <td style="width: 20%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodWebAuthn" value="WebAuthn"
                                            ${(primaryMethodForUser == "WebAuthn")?then('checked="true"', '')} />
                                    <label for="primaryMethodWebAuthn">Web Authentication</label>
                                </td>

                                <td style="width: 15%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail"
                                            ${(primaryMethodForUser == "OtpOverEmail")?then('checked="true"', '')} />
                                    <label for="primaryMethodOtpOverEmail">OTP Over Email</label>
                                </td>

                                <td style="width: 15%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverSms" value="OtpOverSms"
                                            ${(primaryMethodForUser == "OtpOverSms")?then('checked="true"', '')} />
                                    <label for="primaryMethodOtpOverSms">OTP Over SMS</label>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <br>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 20%;">
                                    <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion"
                                            ${(primaryMethodForUser == "SecurityQuestion")?then('checked="true"', '')} />
                                    <label for="primaryMethodSecurityQuestion">Security Question</label>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="showRemaining2FAMethodsAfterConfiguration" value="true" label="show remaining methods" name="showRemaining2FAMethodsAfterConfiguration"
                                ${(showRemaining2FAMethodsAfterConfiguration == true)?then('checked="true"', '')}>
                        <label for="showRemaining2FAMethodsAfterConfiguration" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div">
                                <div class="cross cross-left"></div>
                                <div class="cross cross-right"></div>
                            </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;&nbsp;Show Remaining 2FA Method After Configuration/Inline Registration</span>
                    <div class="description">
                        If this is enabled then after successfully configuring one primary and backup method, the end users will see all the remaining 2FA methods(enabled by admin)
                        and they can configure multiple methods.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="showAllConfiguredMethodsDirectly" value="true" onclick="validateShowAllConfigureMethod()" label="show all configured methods" name="showAllConfiguredMethodsDirectly"
                                ${(showAllConfiguredMethodsDirectly == true)?then('checked="true"', '')}>
                        <label for="showAllConfiguredMethodsDirectly" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div">
                                <div class="cross cross-left"></div>
                                <div class="cross cross-right"></div>
                            </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;Show All Configured Methods to User for 2FA Validation</span>
                    <div class="description">
                        If user has configured multiple 2FA methods then, with this option, user will see the list of all configured 2FA methods which are enabled by admin while logging in and user can choose
                        any 2FA method for validation. If this option is disabled then user will be redirected to user's primary 2FA method for validation.
                    </div>
                </div>
            </div>
            <br><br>

            <div id="bruteForceSettingsDiv">
                <h3 class="subsection_title">Brute Force Protection</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"
                        <#if enableBruteForceProtection == true> checked="true"</#if> />
                        <label for="enableBruteForceProtection" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                 </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Brute Force Protection for Crowd
                    </span>
                    <div class="description" style="margin-top: 10px;">The Enable Brute force checkbox allows you to add restrict Crowd access based on the number of Login Attempts.
                    <br>
                    NOTE: The addon's Brute Force Protection won't be effective when Yubikey Hardware Token/Web Authentication is used as a Primary 2FA method.
                    </div>
                </div>

                <div class="field-group">
                    <label for="bruteForceNumberOfAttempts">Number of Attempts : </label>
                    <#if enableBruteForceProtection == true>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" />
                    <#else>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Select the number of invalid login attempts to lock the user account.</div>
                </div>

                <div class="field-group">
                    <label>User Locked out Period : </label>
                    <table>
                    <tr>
                    <td>
                    <#if enableBruteForceProtection == true>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" style="width: 110px;">
                    <#else>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" disabled style="width: 110px;">
                    </#if>
                        <option value="15 minutes" <#if bruteForceTimeInterval.equals("15 minutes")>selected </#if>>15 Minutes</option>
                        <option value="30 minutes" <#if bruteForceTimeInterval.equals("30 minutes")>selected </#if>>30 Minutes</option>
                        <option value="1 hour" <#if bruteForceTimeInterval.equals("1 hour")>selected </#if>>1 Hour</option>
                        <option value="5 hours" <#if bruteForceTimeInterval.equals("5 hours")>selected </#if>>5 Hours</option>
                        <option value="1 day" <#if bruteForceTimeInterval.equals("1 day")>selected </#if>>1 Day</option>
                        <option value="7 days" <#if bruteForceTimeInterval.equals("7 days")>selected </#if>>7 Days</option>
                        <option value="custom" <#if bruteForceTimeInterval.equals("custom")>selected </#if>>Custom</option>
                    </select>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:block" <#if enableBruteForceProtection != true> disabled </#if> />
                    <#else>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:none" <#if enableBruteForceProtection != true> disabled </#if> />
                    </#if>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:block" <#if enableBruteForceProtection != true> disabled </#if>>
                    <#else>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:none" <#if enableBruteForceProtection != true> disabled </#if> >
                    </#if>
                        <option value="minutes" <#if bruteForceCustomTimeInterval.equals("minutes")>selected </#if>>Minutes</option>
                        <option value="hours" <#if bruteForceCustomTimeInterval.equals("hours")>selected </#if>>Hours</option>
                        <option value="days" <#if bruteForceCustomTimeInterval.equals("days")>selected </#if>>Days</option>
                        </select>
                    </td>
                    </tr>
                    </table>
                    <div class="description">Once this time is expired, the user will be able to login to Crowd again.</div>
                </div>
                <div class="field-group">
                    <label for="emailTemplateBruteForce">Blocked Email Template : </label>
                    <textarea id="emailTemplateBruteForce" name="emailTemplateBruteForce" class="textarea long-field"
                        style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false" <#if (enableBruteForceProtection != true)> disabled </#if>>${emailTemplateBruteForce}</textarea>
                    <div class="description">You can customize email template sent to user. Use variable $$ipaddress$$ to add ipaddress in template</div>
                </div>
            </div>

            <br><br>
            <div id="multiLingualSupportDiv">
                <h3 class="subsection_title">Multilingual Support</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                         <input class="input-checkbox" type="checkbox" id="multiLingualSupportToggleId" value="true" name="multiLingualSupportToggle"
                                               <#if multiLingualSupportToggle == true> checked="true" </#if> />
                        <label for="multiLingualSupportToggleId" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Multilingual Support for Users
                    </span>
                    <div class="description" style="margin-top:8px;">
                    By enabling this feature,  users will be able to select their preferred language on all 2FA plugin pages.
                    <br><b>NOTE</b>: If your end-user base primarily uses only one specific language, you can customize templates
                    from the <a href="${request.contextPath}/console/secure/plugins/twofactor-lookandfeeltemplates/lookandfeeltemplates.action" target="_blank">Look & Feel Templates</a> tab. However, if your end users
                    belongs from different regions and speak different languages then use this feature.
                    </div>
                </div>
            </div>
            <br><br>
            <div id="rememberMeDeviceSettingsDiv">
                <h3 class="subsection_title">Remember My Device</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                         <input class="input-checkbox" type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"
                                               <#if enableRememberMeDevice == true> checked="true" </#if> />
                        <label for="enableRememberMeDevice" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Remember My Device for Users
                    </span>
                    <div class="description">The Remember My Device checkbox allows you to ignore 2FA check if the user is trying to log in from the same device.</div>
                </div>

                <div class="field-group">
                    <label for="rememberMeDeviceDuration">Expiry Time (in Days) : </label>
                    <#if (enableRememberMeDevice == true)>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" />
                    <#else>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Once the time has expired, the device information for that user will be clear.</div>
                </div>
            </div>
            <br><br>
                <div id="urlFilterSettingsDiv">
                    <h3 class="subsection_title">Skip 2FA for APIs running in backend</h3>

                    <div class="field-group">
                        <label for="skip2faUrls"> URLs for the backend APIs: </label>
                        <input type="text" id="skip2faUrls" name="skip2faUrls" placeholder="users/viewmyprofile.action" value="${skip2faUrls}" class="text long-field" />
                        <div class="description">Enter the semicolon separated relative URLs(or part of the URLs) for the APIs which will run in the backend
                            for which you want to skip the 2FA verification</div>
                    </div>
                </div>

            <br><br>
            <div id="oneTime2FAInCrowdAuthenticationSetup">
                <h3 class="subsection_title">One-time 2FA validation in Crowd authentication setups </h3>
                <div class="field-group">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="bypass2faAfterCrowdSso" value="true" name="bypass2faAfterCrowdSso"
                               onclick="enableSaveButton()"   <#if bypass2faAfterCrowdSso == true> checked="true" </#if> />
                        <label for="bypass2faAfterCrowdSso" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div">
                                <div class="cross cross-left"></div>
                                <div class="cross cross-right"></div>
                            </div>
                        </label>
                    </div>
                    Enable this to allow one time 2FA when users login to multiple applications via Crowd Authentication.
                    <br>
                    <div class="description" style="margin-top: 10px;">2FA will be verified in first application and it will be skipped in all other apps.
                        <br>
                        Note: For this feature to work, this option must be enabled in 2FA app on all Crowd connected applications.
                    </div>
                    <br>
                    <label for="keyProvidedByCrowdSso">Parent Domain : </label>
                    <div>
                       <input type="text" id="byPassCookieDomain" name="byPassCookieDomain" value="${byPassCookieDomain}" class="text long-field"
                              oninput="validateDomain(this.value)" placeholder="Enter the parent Domain" <#if (bypass2faAfterCrowdSso != true)> disabled </#if>>
                        <p id="domainResult"></p>
                       <div class="description">Enter the parent domain for your Crowd deployment. Example: If your crowd domain is mycrowd.mycorp.com, </br>
                       then enter mycorp.com here. Leave this field empty if you want cookies to be set to the domain that requests are made to.</div>
                    </div>
                </div>
            </div>
            <br><br>
            <div id="disable2faForSsoUsers">
                <h3 class="subsection_title">Skip 2FA on SSO</h3>
                <div class="field-group">
                    <label for="ignore2FAAfterSso">Skip 2FA for Crowd SSO Users :</label>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="ignore2FAAfterSso" value="true" name="ignore2FAAfterSso"
                                <#if ignore2FAAfterSso == true> checked="true" </#if> />
                        <label for="ignore2FAAfterSso" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div">
                                <div class="cross cross-left"></div>
                                <div class="cross cross-right"></div>
                            </div>
                        </label>
                    </div>
                    Enable this to skip the 2FA if users login via SSO.
                </div>
                <div class="field-group">
                    <label for="ssoLoginUrl">SSO Login URL : </label>
                    <input type="text" id="ssoLoginUrl" name="ssoLoginUrl" value="${ssoLoginUrl}" class="text long-field" style="margin-top: 10px;"
                           placeholder="Comma Separated SSO Login Or Callback URL" <#if (ignore2FAAfterSso != true)> disabled </#if>>
                    <div class="description">Add comma separated Single Sign on URL (SAML) or Callback URL(OAuth/OpenID) from your SSO provider.</div>
                </div>
            </div>
            <br><br>
            <div id="PluginPagesAccessManager">
                <h3 class="subsection_title">Access to Plugin Pages</h3>
                <input type="hidden" name="totalGroupsWithAdminPagesAccessConfigs" id="totalGroupsWithAdminPagesAccessConfigs" value="${totalGroupsWithAdminPagesAccessConfigs}"/>
                <div class="field-group">
                    <div style="margin-top:1%">
                        Grant non-admin users access to plugin configuration pages.
                    </div>
                    <br>
                    <input type="button" class="aui-button aui-button-primary" id="" name="" onclick="addAccessManagerField()" value="Add New Access" style="margin-bottom: 2%;"/>

                    <div id="AccessManagerContainer">
                        <#if (!groupsWithAdminPagesAccess.isEmpty())>
                            <#assign cnt = 0>
                            <#foreach page in groupsWithAdminPagesAccess.keySet()>
                                <div>
                                    <select class="select" name="PageName_${cnt}" id="PageName_${cnt}" style="vertical-align: bottom; width: 150px;">
                                        <option value="" disabled selected>Select Page</option>
                                        <option value="Basic_Configuration" <#if (page.contains("Basic_Configuration"))> selected </#if>>Basic Configuration</option>
                                        <option value="Advanced_Settings" <#if (page.contains("Advanced_Settings"))> selected </#if>>Advanced Options</option>
                                        <option value="User_Management" <#if (page.contains("User_Management"))> selected </#if>>User Management</option>
                                        <option value="Audit_Logs" <#if (page.contains("Audit_Logs"))> selected </#if>>Audit Logs</option>
                                        <option value="IP_Restriction" <#if (page.contains("IP_Restriction"))> selected </#if>>IP Restriction</option>
                                        <option value="LookAndFeel" <#if (page.contains("LookAndFeel"))> selected </#if>>Look and Feel</option>
                                        <option value="TroubleShooting" <#if (page.contains("TroubleShooting"))> selected </#if>>Troubleshooting</option>
                                    </select> &nbsp;&nbsp;
                                    <input class="select long-field" name="includeGroups_${cnt}" id="includeGroups_${cnt}" style="width: 200px; vertical-align: bottom;" placeholder="Enter Group name" value="${groupsWithAdminPagesAccess.get(page)}"></input> &nbsp;&nbsp;
                                    <select class="select" name="AccessType_${cnt}" id="AccessType_${cnt}" style="vertical-align: bottom; width: 150px;">
                                        <option value="" disabled selected>Select Access type</option>
                                        <option value="read" <#if (page.contains("read"))> selected </#if>> VIEW</option>
                                        <option value="readwrite" <#if (page.contains("readwrite"))> selected </#if>>EDIT</option>
                                    </select> &nbsp;&nbsp;
                                    <input type="button" class="aui-button aui-button-primary" id="removePageAccessManagerField" name="removePageAccessManagerField" style="vertical-align: bottom;" onclick="removeAccessManagerField(this,${cnt})" value="Remove"/>
                                </div>
                                <br>
                                <#assign cnt = cnt+1>
                            </#foreach>
                        </#if>
                    </div>
            </div>
            <br>
            <#if (pageAccessType.equals("readwrite"))>
                <div class="field-group">
                    </br>
                    <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
                </div>
            </#if>
            </div>
            </div>
        </form>
    </div>
    </div>
    </section>
</body>
</html>