AJS.$(document).ready(function() {
    if (getQueryParameterByName("reset") != "") {
        if (getQueryParameterByName("reset") == "success") {
            if (getQueryParameterByName("method") == "GoogleAuthenticator") {
                require('aui/flag')({
                    title: 'Two Factor Configuration',
                    type: 'info',
                    close: 'auto',
                    body: '<p>Mobile Authenticator is removed. Now you can reconfigure it again.</p>'
                });
            }

            if (getQueryParameterByName("method") == "OtpOverEmail") {
                require('aui/flag')({
                    title: 'Two Factor Configuration',
                    type: 'info',
                    close: 'auto',
                    body: '<p>OTP Over Email is removed. Now you can reconfigure it again.</p>'
                });
            }

            if (getQueryParameterByName("method") == "OtpOverSMS") {
                require('aui/flag')({
                    title: 'Two Factor Configuration',
                    type: 'info',
                    close: 'auto',
                    body: '<p>OTP Over SMS is removed. Now you can reconfigure it again.</p>'
                });
            }

            if (getQueryParameterByName("method") == "SecurityQuestion") {
                require('aui/flag')({
                    title: 'Two Factor Configuration',
                    type: 'info',
                    close: 'auto',
                    body: '<p>Security Question is removed. Now you can reconfigure it again.</p>'
                });
            }
        }
    }

    var enableTwoFactor = '$enableTwoFactor';
    var configuredMethods = '$totalMethodsConfiguredByUser';
    if(enableTwoFactor == 'true' && configuredMethods <= 0) {
        require('aui/flag')({
            title: 'Two Factor Authentication',
            type: 'info',
            close: 'auto',
            body: '<p>2FA is enabled but no method is configured. If you do not configure it, you will be prompted to configure it during login.</p>'
        });
    }

    var allowToReconfigureMethod = '$allowToReconfigureMethod';
    if(enableTwoFactor == 'true' && allowToReconfigureMethod != 'true') {
        require('aui/flag')({
            title: 'Two Factor Authentication',
            type: 'info',
            close: 'auto',
            body: '<p>You do not have a access to reconfigure/reset the 2FA methods. Contact to administrator if you want to reconfiguring it.</p>'
        });
    }
    setMethodIcons();
});

function setMethodIcons() {
    var googleAuthenticatorIcon = document.getElementById("googleAuthenticatorIconId").value;
    if (document.getElementById("imgGoogleAuthenticator") != null) {
        document.getElementById("imgGoogleAuthenticator").src = googleAuthenticatorIcon;
    }
    var duoPushNotificationIcon = document.getElementById("duoPushNotificationIconId").value;
    if (document.getElementById("imgPushNotification") != null) {
        document.getElementById("imgPushNotification").src = duoPushNotificationIcon;
    }

    var hardwareTokenIcon = document.getElementById("hardwareTokenIconId").value;
    if (document.getElementById("imgHardwareToken") != null) {
        document.getElementById("imgHardwareToken").src = hardwareTokenIcon;
    }

    var yubikeyTokenTouchIcon = document.getElementById("yubikeyTokenTouchIconId").value;
    if (document.getElementById("imgYubikeyTokenTouch") != null) {
        document.getElementById("imgYubikeyTokenTouch").src = yubikeyTokenTouchIcon;
    }

    var webAuthnIcon = document.getElementById("webAuthnIconId").value;
    if (document.getElementById("imgWebAuthn") != null) {
        document.getElementById("imgWebAuthn").src = webAuthnIcon;
    }

    var otpOverEmailIconIcon = document.getElementById("otpOverEmailIconId").value;
    if (document.getElementById("imgOtpOverEmail") != null) {
        document.getElementById("imgOtpOverEmail").src = otpOverEmailIconIcon;
    }

    var otpOverSmsIcon = document.getElementById("otpOverSmsIconId").value;
    if (document.getElementById("imgOtpOverSms") != null) {
        document.getElementById("imgOtpOverSms").src = otpOverSmsIcon;
    }

    var securityQuestionIcon = document.getElementById("securityQuestionIconId").value;
    if (document.getElementById("imgSecurityQuestion") != null) {
        document.getElementById("imgSecurityQuestion").src = securityQuestionIcon;
    }

    var backupCodeIcon = document.getElementById("backupCodeIconId").value;
    if (document.getElementById("imgBackupCode") != null) {
        document.getElementById("imgBackupCode").src = backupCodeIcon;
    }
}

function getQueryParameterByName(name) {
    var url = window.location.href;
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);

    if (!results) return null;

    if (!results[2]) return '';

    return decodeURIComponent(results[2].replace(/\+/g, " "));
}

function removeDeviceDetails(username, deviceDetails, trId) {
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        data: {
            "action": "RemoveDeviceDetails",
            "username": username,
            "deviceDetails": deviceDetails
        },
        type: "GET",
        success: function (response) {
            performRemoveDeviceDetails(response, trId);
        },
        error: function (response) {
            performRemoveDeviceDetails(response, trId);
        },
        async: false
    });
}

function performRemoveDeviceDetails(response, trId) {
    if (response.status == 200) {
        var element = document.getElementById(trId);
        element.parentNode.removeChild(element);
    }
}

function showIPAddress() {
    require('aui/flag')({
        title: 'Two Factor Authentication',
        type: 'info',
        body: '<p>Your Current IP Address is <strong>${currentIPAddress}</strong></p>'
    });
}
function enableRegistrationUsingQrCode() {
    AJS.$("#ownSecretKey").val("");
    AJS.$("#otpUsingOwnSecretKey").val("");
    AJS.$("#google-authenticator-own-secret-key-secondary-div").hide();
    AJS.$("#google-authenticator-secondary-div").show();
}
function enableRegistrationUsingOwnSecretKey() {
    AJS.$("#qrCodeOtp").val("");
    AJS.$("#google-authenticator-secondary-div").hide();
    AJS.$("#google-authenticator-own-secret-key-secondary-div").show();
}
function RedirectToBasicConfigurationPage(){
    window.open(AJS.contextPath() + "/console/secure/plugins/twofactor-configure/configure.action");
}

function RedirectToMailServer(){
    window.open(AJS.contextPath()+"/console/secure/admin/mailserver.action");
}