/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.opensaml.xml.security.credential.AbstractCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazySet;

public class BasicCredential
extends AbstractCredential {
    public BasicCredential() {
        this.keyNames = new LazySet();
        this.usageType = UsageType.UNSPECIFIED;
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return Credential.class;
    }

    public void setEntityId(String id) {
        this.entityID = DatatypeHelper.safeTrimOrNullString(id);
    }

    public void setUsageType(UsageType usage) {
        this.usageType = usage != null ? usage : UsageType.UNSPECIFIED;
    }

    public void setPublicKey(PublicKey key) {
        this.publicKey = key;
        if (key != null) {
            this.setSecretKey(null);
        }
    }

    public void setSecretKey(SecretKey key) {
        this.secretKey = key;
        if (key != null) {
            this.setPublicKey(null);
            this.setPrivateKey(null);
        }
    }

    public void setPrivateKey(PrivateKey key) {
        this.privateKey = key;
        if (key != null) {
            this.setSecretKey(null);
        }
    }
}

