/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.miniorange.twofactor.webauthn.utils.AuthenticatorData;
import com.miniorange.twofactor.webauthn.utils.AuthenticatorResponse;
import com.miniorange.twofactor.webauthn.utils.CollectedClientData;
import java.nio.charset.StandardCharsets;

public class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    byte[] authDataBytes;
    AuthenticatorData authData;
    byte[] signature;
    byte[] userHandle;

    public AuthenticatorAssertionResponse() {
    }

    public AuthenticatorAssertionResponse(String clientDataJSON, String authenticatorData, String signatureString) throws Exception {
        this.clientData = CollectedClientData.decode(clientDataJSON);
        this.clientDataBytes = clientDataJSON.getBytes(StandardCharsets.UTF_8);
        this.authData = AuthenticatorData.decode(BaseEncoding.base64().decode((CharSequence)authenticatorData));
        this.signature = BaseEncoding.base64().decode((CharSequence)signatureString);
    }

    public AuthenticatorAssertionResponse(JsonElement data) throws Exception {
        Gson gson = new Gson();
        try {
            AssertionResponseJson parsedObject = gson.fromJson(data, AssertionResponseJson.class);
            this.clientDataBytes = BaseEncoding.base64().decode((CharSequence)parsedObject.clientDataJSON);
            this.clientData = gson.fromJson(new String(this.clientDataBytes, StandardCharsets.UTF_8), CollectedClientData.class);
            this.authDataBytes = BaseEncoding.base64().decode((CharSequence)parsedObject.authenticatorData);
            this.authData = AuthenticatorData.decode(this.authDataBytes);
            this.signature = BaseEncoding.base64().decode((CharSequence)parsedObject.signature);
            this.userHandle = BaseEncoding.base64().decode((CharSequence)parsedObject.userHandle);
        }
        catch (JsonSyntaxException e) {
            throw new Exception("Response format incorrect");
        }
    }

    public byte[] getAuthDataBytes() {
        return this.authDataBytes;
    }

    public AuthenticatorData getAuthenticatorData() {
        return this.authData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getUserHandle() {
        return this.userHandle;
    }

    private static class AssertionResponseJson {
        String clientDataJSON;
        String authenticatorData;
        String signature;
        String userHandle;

        private AssertionResponseJson() {
        }
    }
}

