/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidateSecurityQuestion
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidateSecurityQuestion.class);
    private static final String VALIDATE_SECURITYQUESTION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_securityquestion.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorValidateSecurityQuestion(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateSecurityQuestion doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_SecurityQuestion").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            ArrayList errorMessage = new ArrayList();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("questionsListForUser", this.getSecurityQuestionForUsers(username, twoFactorUserClass));
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("enableRememberMeDevice", this.settings.getEnableRememberMeDevice());
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("SecurityQuestion"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateSecurityQuestionTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATE_SECURITYQUESTION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateSecurityQuestion doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            ArrayList<String> errorMessage = new ArrayList<String>();
            int securityQuestionCountToBeAsk = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT / 2 + 1;
            Map<String, String> securityQuestionAnswer = twoFactorUserClass.getSecurityQuestionAnswer();
            for (int i = 0; i < securityQuestionCountToBeAsk; ++i) {
                String key = request.getParameter("question_" + i).trim();
                String value = request.getParameter("answer_" + i).trim();
                String valueAsItIs = request.getParameter("answer_" + i).trim();
                if (StringUtils.isBlank((CharSequence)value)) {
                    errorMessage.add("The answers provided are incorrect.");
                    break;
                }
                try {
                    value = MoTwoFactorUtility.hashString(value.toLowerCase());
                    valueAsItIs = MoTwoFactorUtility.hashString(value);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.error("Error " + e);
                }
                LOGGER.debug("hash Custom Question Value " + value);
                if (securityQuestionAnswer.containsKey(key)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)securityQuestionAnswer.get(key)) || StringUtils.equalsIgnoreCase((CharSequence)valueAsItIs, (CharSequence)securityQuestionAnswer.get(key))) continue;
                    errorMessage.add("The answers provided are incorrect.");
                    break;
                }
                errorMessage.add("The answers provided are incorrect.");
                break;
            }
            if (errorMessage.size() == 0) {
                errorMessage.add("Valid Mapping Found");
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Successful", "Security Question");
                HttpSession session = request.getSession();
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                twoFactorUserClass = this.rememberThisDevice(request, twoFactorUserClass);
                this.settings.addTo2FAConfiguredUsersList(username);
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "Security Question");
            if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                LOGGER.debug("User has exceeded number of invalid attempts");
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "Security Question");
                this.pluginHandler.performBruteForceUserLockAction(username, request);
                this.pluginHandler.performUserLogout(request, response, username);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                return;
            }
            Integer loginAttemptsLeft = this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username);
            if (loginAttemptsLeft == 2) {
                LOGGER.debug("Only a last 2 login attempts left");
                errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
            } else if (loginAttemptsLeft == 1) {
                LOGGER.debug("Last login attempt");
                errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("questionsListForUser", this.getSecurityQuestionForUsers(username, twoFactorUserClass));
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("enableRememberMeDevice", this.settings.getEnableRememberMeDevice());
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("SecurityQuestion"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateSecurityQuestionTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATE_SECURITYQUESTION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public MoTwoFactorCommonUserSettings rememberThisDevice(HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserClass) {
        Boolean rememberMeOnThisDevice = Boolean.parseBoolean(request.getParameter("rememberMeOnThisDevice"));
        if (BooleanUtils.toBoolean((Boolean)rememberMeOnThisDevice)) {
            String deviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
            LOGGER.debug("Current Device Details : " + deviceDetails);
            List<String> rememberMeDeviceDetails = twoFactorUserClass.getRememberMeDeviceDetails();
            if (StringUtils.isNotBlank((CharSequence)deviceDetails)) {
                LOGGER.debug("Device details is not a blank");
                LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
                int rememberDeviceDuration = this.settings.getRememberMeDeviceDuration();
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, rememberDeviceDuration);
                Date date = calendar.getTime();
                long newTimeInMili = date.getTime();
                Boolean containsDeviceInList = Boolean.FALSE;
                for (int i = 0; i < rememberMeDeviceDetails.size(); ++i) {
                    String device = rememberMeDeviceDetails.get(i);
                    if (!StringUtils.containsIgnoreCase((CharSequence)device, (CharSequence)deviceDetails)) continue;
                    LOGGER.debug("Changing device details time : " + newTimeInMili);
                    containsDeviceInList = Boolean.TRUE;
                    rememberMeDeviceDetails.add(i, deviceDetails.concat("=====" + newTimeInMili));
                    break;
                }
                if (!BooleanUtils.toBoolean((Boolean)containsDeviceInList)) {
                    if (deviceDetails.split("\\|\\|").length > 2) {
                        LOGGER.debug("Adding device details with time : " + newTimeInMili);
                        rememberMeDeviceDetails.add(deviceDetails.concat("=====" + newTimeInMili));
                    } else {
                        LOGGER.debug("Invalid Device Details : " + deviceDetails);
                    }
                }
                twoFactorUserClass.setRememberMeDeviceDetails(rememberMeDeviceDetails);
                LOGGER.debug("Remember Me Device Details size:" + twoFactorUserClass.getRememberMeDeviceDetails().size());
                LOGGER.debug("After change Device Details : " + rememberMeDeviceDetails);
            }
        }
        return twoFactorUserClass;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    private List<String> getSecurityQuestionForUsers(String username, MoTwoFactorCommonUserSettings twoFactorUserClass) {
        Map<String, String> securityQuestionAnswer = twoFactorUserClass.getSecurityQuestionAnswer();
        LOGGER.debug("Security Question answers for user " + username + " : " + securityQuestionAnswer);
        ArrayList<String> questionsListForUser = new ArrayList<String>();
        for (String question : securityQuestionAnswer.keySet()) {
            questionsListForUser.add(question);
        }
        LOGGER.debug("Security Question configured by user : " + questionsListForUser);
        ArrayList<String> securityQuestionToAsk = new ArrayList<String>();
        if (questionsListForUser.size() > 0) {
            Integer numberOfQuestionToAsk = questionsListForUser.size() / 2 + 1;
            do {
                String question = this.getRandomList(questionsListForUser);
                LOGGER.debug("Security Question : " + question);
                if (securityQuestionToAsk.contains(question)) continue;
                securityQuestionToAsk.add(question);
            } while (securityQuestionToAsk.size() != numberOfQuestionToAsk.intValue());
        }
        LOGGER.debug("questionsListForUser : " + securityQuestionToAsk);
        return securityQuestionToAsk;
    }

    public String getRandomList(List<String> list) {
        int index = (int)(Math.random() * (double)list.size());
        return list.get(index);
    }
}

