/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import net.sf.ldaptemplate.support.filter.AndFilter;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class DefaultLDAPAuthenticator
implements Authenticator {
    public static final SearchControls DEFAULT_SEARCH_CONTROLS = new SearchControls();
    private static final Logger log = Logger.getLogger(DefaultLDAPAuthenticator.class);
    private LDAPRepository repository;
    private LDAPUserAdaptor userAdaptor;

    public DefaultLDAPAuthenticator() {
    }

    public DefaultLDAPAuthenticator(LDAPRepository repository) {
        this.repository = repository;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        DEFAULT_SEARCH_CONTROLS.setReturningAttributes(new String[0]);
        DEFAULT_SEARCH_CONTROLS.setSearchScope(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_authenticate__" + username));
        }
        if (!TextUtils.stringSet(password)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot perform authentication on empty passwords.");
            }
            return false;
        }
        Context authCtx = null;
        Hashtable env = null;
        try {
            String userDN = this.userAdaptor.getUserDN(username);
            env = this.repository.getJNDIEnv();
            env.put("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.security.authentication", "simple");
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            authCtx = new InitialDirContext(env);
            String[] attrIDs = new String[]{this.repository.getUsernameAttribute()};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            AndFilter filter = new AndFilter();
            filter.and(this.repository.getUserSearchFilter());
            filter.and((Filter)new EqualsFilter(this.repository.getUsernameAttribute(), username));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Doing initial search to complete authentication: username='" + username + "', base='" + this.repository.getBaseUserNamespace() + "' filter='" + filter.encode() + "'"));
            }
            authCtx.search(this.repository.getBaseUserNamespace(), filter.encode(), ctls);
        }
        catch (NamingException e) {
            log.error((Object)("Could not authenticate with LDAP. Please check your host ('" + env.get("java.naming.provider.url") + "'), " + "bind DN ('" + env.get("java.naming.security.principal") + "') or bind password are correct."));
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            log.error((Object)("Error occurred in LDAP authentication for username: " + username), t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_authenticate__" + username));
        }
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository);
        DEFAULT_SEARCH_CONTROLS.setReturningAttributes(new String[0]);
        DEFAULT_SEARCH_CONTROLS.setSearchScope(0);
        InitializationCheck.validateArgs(args, new String[]{"repository"}, this);
    }
}

