/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.adaptor.AbstractLDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPListOfGroupsPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class LDAPDynamicGroupAdaptor
extends AbstractLDAPGroupAdaptor {
    private static final Logger log = Logger.getLogger(LDAPDynamicGroupAdaptor.class);
    protected LDAPUserAdaptor userAdaptor;
    private LDAPUserFactory userFactory;

    public LDAPDynamicGroupAdaptor(LDAPRepository repository, LDAPGroupFactory groupFactory, LDAPUserFactory userFactory) {
        super(repository, groupFactory);
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        this.userFactory = userFactory;
    }

    public LDAPDynamicGroupAdaptor() {
    }

    public void init(HashMap args) {
        this.repository = (LDAPRepository)args.get("repository");
        this.groupFactory = (LDAPGroupFactory)args.get("groupFactory");
        this.userAdaptor = (LDAPUserAdaptor)args.get("userAdaptor");
        this.userFactory = (LDAPUserFactory)args.get("userFactory");
    }

    public Pager getGroups(User user) throws EntityException {
        LDAPPagerInfo answer = this.getGroupEntriesViaMembership(user.getName(), new String[]{this.repository.getMembershipAttribute()});
        LDAPListOfGroupsPager pager = new LDAPListOfGroupsPager(this.repository, this.groupFactory, answer);
        return pager;
    }

    private String getGroupsForUserSearchString(NamingEnumeration enume) throws RepositoryException {
        String query = null;
        while (enume.hasMoreElements()) {
            SearchResult result = (SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute membershipAttribute = attrs.get(this.repository.getMembershipAttribute());
            if (membershipAttribute == null) continue;
            try {
                NamingEnumeration<?> groupList = membershipAttribute.getAll();
                while (groupList.hasMoreElements()) {
                    String groupDN = (String)groupList.nextElement();
                    if (query == null) {
                        query = "(" + groupDN.split(",")[0] + ")";
                        continue;
                    }
                    query = "(|" + query + "(" + groupDN.split(",")[0] + "))";
                }
            }
            catch (NamingException e) {
                throw new RepositoryException(e);
            }
        }
        return query;
    }

    public Pager findMembers(Group group) throws EntityException {
        LDAPPagerInfo ldapPagerInfo = this.findMembershipEntries(group, null);
        return new LDAPEntityPager(this.repository, this.userFactory, ldapPagerInfo);
    }

    private LDAPPagerInfo findMembershipEntries(Group group, String[] attributesToReturn) throws EntityException {
        EqualsFilter searchFilter = new EqualsFilter(this.repository.getMembershipAttribute(), this.getGroupDN(group));
        LDAPPagerInfo ldapPagerInfo = null;
        try {
            ldapPagerInfo = attributesToReturn == null ? this.userAdaptor.search((Filter)searchFilter) : this.userAdaptor.search((Filter)searchFilter, attributesToReturn);
        }
        catch (EntityException e) {
            log.fatal((Object)("Could not find users in group [" + group.getName() + "] "), (Throwable)e);
        }
        return ldapPagerInfo;
    }

    public Pager findMemberNames(Group group) throws EntityException {
        LDAPPagerInfo ldapPagerInfo = this.findMembershipEntries(group, new String[]{this.repository.getUsernameAttribute()});
        return new LDAPSingleStringPager(this.repository, ldapPagerInfo);
    }

    public boolean hasStaticGroups() {
        return false;
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        LDAPPagerInfo wrapper = this.userAdaptor.getUserAttributes(user.getName(), new String[]{this.repository.getMembershipAttribute()});
        NamingEnumeration enume = wrapper.getNamingEnumeration();
        return this.getGroupsForUserSearchString(enume).indexOf(group.getName()) != -1;
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(User user) throws EntityException {
        return this.getGroupEntriesViaMembership(user.getName());
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String username) throws EntityException {
        return this.getGroupEntriesViaMembership(username, null);
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String username, String[] attributesToReturn) throws EntityException {
        if (attributesToReturn == null) {
            attributesToReturn = new String[]{this.repository.getGroupnameAttribute(), this.repository.getMembershipAttribute()};
        }
        return this.userAdaptor.getUserAttributes(username, attributesToReturn);
    }
}

