/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidate2FAMethodList
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidate2FAMethodList.class);
    private static final String METHODLIST_VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_2famethodlist.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorValidate2FAMethodList(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidate2FAMethodList doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Map<String, Object> context = this.initializeContext(username, request);
            String template = this.settings.getValidate_2faMethodListTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidate2FAMethodList doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String configureTwoFactor = request.getParameter("configureTwoFactor");
            if (StringUtils.isNotBlank((CharSequence)"configureTwoFactor")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"GoogleAuthenticator")) {
                    LOGGER.debug("Redirecting to Google Authentication");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otp"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"OtpOverEmail")) {
                    LOGGER.debug("Redirecting to OTP Over EMail");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoveremail"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"OtpOverSms")) {
                    LOGGER.debug("Redirecting to OTP Over SMS");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoversms"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"SecurityQuestion")) {
                    LOGGER.debug("Redirecting to Security Question");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                    LOGGER.debug("Redirecting to U2F Hardware Token");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_u2fhardwaretoken"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"WebAuthn")) {
                    LOGGER.debug("Redirecting to WebAuthentication as 2FA method");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_webauthnas2famethod"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"BackupCode")) {
                    LOGGER.debug("Redirecting to Backup Code");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_backupcode"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"DuoPushNotification")) {
                    LOGGER.debug("Redirecting to Duo push Notification");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_duopushnotification"));
                }
            }
            String errorMessage = "Please select valid method.";
            Map<String, Object> context = this.initializeContext(username, request);
            context.put("errorMessage", errorMessage);
            String template = this.settings.getValidate_2faMethodListTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    private Map<String, Object> initializeContext(String username, HttpServletRequest request) {
        UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
        String displayName = userProfile.getFullName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = username;
        }
        MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
        List<String> configuredMethodList = twoFactorCommonUserSettings.getConfigured2FAMethodsByUser();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("username", displayName);
        context.put("errorMessage", "");
        if (configuredMethodList.contains("GoogleAuthenticator")) {
            context.put("googleAuthenticatorConfigured", Boolean.TRUE);
        } else {
            context.put("googleAuthenticatorConfigured", Boolean.FALSE);
        }
        if (configuredMethodList.contains("OtpOverEmail")) {
            context.put("otpOverEmailConfigured", Boolean.TRUE);
        } else {
            context.put("otpOverEmailConfigured", Boolean.FALSE);
        }
        if (configuredMethodList.contains("OtpOverSms")) {
            context.put("otpOverSmsConfigured", Boolean.TRUE);
        } else {
            context.put("otpOverSmsConfigured", Boolean.FALSE);
        }
        if (configuredMethodList.contains("YubikeyHardwareTokenAsU2F")) {
            context.put("u2fHardwareTokenEnabled", Boolean.TRUE);
        } else {
            context.put("u2fHardwareTokenEnabled", Boolean.FALSE);
        }
        if (configuredMethodList.contains("WebAuthn")) {
            context.put("webAuthnAs2faEnabled", Boolean.TRUE);
        } else {
            context.put("webAuthnAs2faEnabled", Boolean.FALSE);
        }
        if (configuredMethodList.contains("SecurityQuestion")) {
            context.put("securityQuestionConfigured", Boolean.TRUE);
        } else {
            context.put("securityQuestionConfigured", Boolean.FALSE);
        }
        if (configuredMethodList.contains("BackupCode")) {
            context.put("backupCodeConfigured", Boolean.TRUE);
        } else {
            context.put("backupCodeConfigured", Boolean.FALSE);
        }
        if (configuredMethodList.contains("DuoPushNotification")) {
            context.put("duoPushNotificationConfigured", Boolean.TRUE);
        } else {
            context.put("duoPushNotificationConfigured", Boolean.FALSE);
        }
        context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
        return context;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

