/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.Repository;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;

public class MemoryPropertySetFactory
implements PropertySetFactory {
    public static final String MEMORY_PROPERTY_SET = "memory";
    private HashMap propertySets;

    public MemoryPropertySetFactory() {
    }

    public MemoryPropertySetFactory(Repository repo) {
        this.init(null);
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException {
        if (entity == null) {
            throw new IllegalArgumentException("Cannot generate a propertyset for a null entity");
        }
        PropertySet propertySet = (PropertySet)this.propertySets.get(entity.getName());
        if (propertySet != null) {
            return propertySet;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("entityName", "_" + entity.getName());
        propertySet = PropertySetManager.getInstance((String)MEMORY_PROPERTY_SET, args);
        this.propertySets.put(entity.getName(), propertySet);
        return propertySet;
    }

    public void init(HashMap args) {
        this.propertySets = new HashMap();
    }
}

