<!-- Troubleshooting tab of the plugin, lets you send a support query from the plugin -->

<html>

<head>
    <title>Two Factor Configuration</title>
    <meta name="decorator" content="atl.general">

    <script>
        AJS.$(document).ready(function() {
             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
             AJS.$("#TROUBLESHOOTING").addClass("aui-nav-selected");
             AJS.$('input').css("box-shadow","none");
             AJS.$("#enableDebugLogs").change(function()
             {   console.log("Debug logs are activated!!!")
                 var enableDebugLogs = document.getElementById("enableDebugLogs").checked;
                     var message;
                     if(enableDebugLogs)
                     {
                         message = "Debug Logs enabled successfully"
                     }else
                     {
                         message = "Debug Logs disabled successfully"
                     }
                 AJS.$.ajax({
                     url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                     data: {
                         "action" : "enableDebugLogs",
                         "enableDebugLogs" : enableDebugLogs,
                     },
                     error: function (response) {
                         if(response.status == 200){
                               require('aui/flag')({
                               title: 'Success',
                               type: 'success',
                               close: 'auto',
                               body: message
                                             });
                         }else {
                             require('aui/flag')({
                                   title: 'Error',
                                   type: 'error',
                                   close: 'auto',
                                   body: '<p>Issue with enabling DEBUG Logs. </p>'
                             });
                        }
                     },
                     success: function(response)
                     {
                         AJS.flag({
                             title: 'Success',
                             type: 'success',
                             close: 'auto',
                             body: message,
                         })
                         require('aui/flag')({
                             title: 'Success',
                             type: 'success',
                             close: 'auto',
                             body: message
                         });
                     },

                 });
                 showLogsDownload();
             });
             showLogsDownload();
        });
    function showLogsDownload(){
      if(document.getElementById("enableDebugLogs").checked){
        AJS.$("#logsDownloadDiv").slideDown();
      }
      else {
        AJS.$("#logsDownloadDiv").slideUp();
        document.getElementById("logsDownloadDiv").style.display = "none";
      }
    }

    function downloadButtonCalled() {
      document.location.href = AJS.contextPath() + "/plugins/servlet/twofactor/moapi?action=downloadDebugLogs";
    }
    </script>

    <style>
        h4 {
            display: block;
            margin: 30px 65px 0px;
            font-weight: bold;
        }

        .aui-page-panel-content{
            padding: 0px !important;
        }

        .aui-page-panel{
            margin: 0px !important;
        }

        .labelClass {
            width: 150px !important;
            margin-left: -160px !important;
        }

        .card{
            border: 2px;
            border-style: solid;
            box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
            transition: 0.3s;
        }

        /* On mouse-over, add a deeper shadow */
        .card:hover {
            box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
        }

        /* Add some padding inside the card container */
        .container {
            padding: 2px 16px;
        }
        .card-body{
            margin: 15px;
        }

        .aui-dialog2-header-main {
            max-width : 100%;
        }

        .aui-message:first-child {
            margin-right: 0px;
        }

    </style>
</head>

<body>
    <#include "*/header.ftl" parse=true>
    <!--<div class="tabs-pane active-pane" id="troubleshooting" role="tabpanel">
    	<div>
	        <ul>
	            <li><b>Log File</b> : You can follow these steps to download logs,
                    </br>
                    <ul>
                        <li>Enable the logger for 2FA
                            <ol>
                                <ol>
                                    <li>Go to <b>Administrative Cog Wheel -> Logging and Profiling</b>.
                                    <li>Enter <i>com.miniorange.twofactor</i> in class path field and select Debug in type. Click on add.</li>
                                </ol>
                            </ol>
                        </li>
                        <br>

                        <li>Login to Crowd using 2FA
                            <ol>
                                <li>Login to Crowd with the respective user or perform the action after which you are facing an issue. So that it will record the plugins logs in a file.</li>
                            </ol>
                        </li>
                        <br>

                        <li>Download the logs
                            <ol>
                                <li>Go to <b>Administrative Cog Wheel -> Troubleshooting and support tools</b>.
                                <li>navigate to the create support zip tab.</li>
                                <li>Keep only <b>Logs files</b> option selected.</li>
                                <li>Click on <b>Create zip</b> and then <b>Download zip</b>.</li>
                            </ol>
                        </li>
                    </ul>
                </li>
	       </ul>
	   </div>
       </br></br>
       
       <p>Send us a message, query or feedback attaching above log file using the Support widget (requires Internet) and we will get back to you. Have a lot to say? You can also reach us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>
        
    </div>
    </div>
    </section>
    </div>
    </div>-->
    <div class="tabs-pane active-pane mo-aui-page-panel-content" id="contact-us"  role="tabpanel" >
                	<p style="font-size:13pt;">Troubleshooting</p>
                    <hr class="header"/>
                	<ul>
                	<li><b>Log File</b> : Any errors or issues  related to the plugin's functionality can be tracked using debug logs. To record debug logs enable the below option,
                        <br>
                        <form id="troubleshoot-form" class="aui" action="" method="POST">
                            <div class="field-group">
                                <label for="enableDebugLogs" class="labelClass"><strong>Enable Debug Logs: </strong> </label>
                                <span style="vertical-align:middle;">
                                <label class="switch" style="vertical-align:middle;">
                                    <#if enableDebugLogs == true>
                                        <input type="checkbox" id="enableDebugLogs" value="true" name="enableDebugLogs"
                                                checked="true">
                                        <span class="slider round"></span> <#else>
                                                <input type="checkbox" id="enableDebugLogs" value="true" name="enableDebugLogs">
                                        <span class="slider round"></span></#if>
                                </label>

                            </div>
                            <br>
                                <div id= "logsDownloadDiv" class="field-group">
                                    <div id= "logsMessageDiv" class="aui-message aui-message-info" style="width:70%;">
                                        <span>
                                            Debug Logs are now enabled , please reproduce the issue in incognito and then click on Download button.
                                        </span>
                                    </div>
                                    <br>
                                    <label for="serverLogs" class="labelClass"><strong>Server Logs: </strong> </label>
                                                                <span style="vertical-align:middle;">
                                    <input type="button" value="Download" id="downloadButton" class="aui-button aui-button-primary" style="width:100px;" onclick="return downloadButtonCalled()"/>
                                    &nbsp;&nbsp;&nbsp;
                                    <div class="description" id= "debugLogInfoTag" style= "margin-top:10px ; width:50%">
                                        <span>Clicking on download will download a copy of the Crowd Server logs file.</span>
                                    </div>
                                </div>
                        </form>
                        <br>
                    </li>

                    <p>Send us a message, query or feedback using the Support widget (requires Internet) and we will get back to you. Have a lot to say? You can also reach us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>
                </div>
    		</div>
            </section>
            </div>
            </div>
</body>

</html>