/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidateBackupCode
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidateBackupCode.class);
    private static final String VALIDATE_VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_backupcode.vm";
    private final TemplateRenderer renderer;
    private String otpToken;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorValidateBackupCode(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateBackupCode doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_BackupCode").booleanValue()) {
            LOGGER.debug("Valid User");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", new ArrayList());
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("BackupCode"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateBackupCodeTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATE_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateBackupCode doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Integer loginAttemptsLeft;
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            ArrayList<String> errorMessage = new ArrayList<String>();
            List<String> backupCodes = twoFactorUserClass.getBackupCodes();
            String backupCodeOtp = StringUtils.trimToEmpty((String)request.getParameter("backupCodeOtp"));
            LOGGER.debug("Backup Code : " + backupCodeOtp);
            if (StringUtils.isBlank((CharSequence)backupCodeOtp)) {
                errorMessage.add("Empty Backup code entered. Please enter the valid one");
            } else if (!backupCodes.contains(MoTwoFactorUtility.encryptString(backupCodeOtp = backupCodeOtp.trim(), this.pluginConfiguration.SECRETE_KEY))) {
                errorMessage.add("Invalid Backup code entered. Please enter the valid one");
            }
            if (errorMessage.size() == 0) {
                errorMessage.add("Valid Backup Code Found");
                backupCodes.removeAll(Collections.singleton(MoTwoFactorUtility.encryptString(backupCodeOtp, this.pluginConfiguration.SECRETE_KEY)));
                twoFactorUserClass.setBackupCodes(backupCodes);
                HttpSession session = request.getSession();
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                this.settings.addTo2FAConfiguredUsersList(username);
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request))) {
                LOGGER.debug("User has exceeded number of invalid attempts");
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                    this.pluginHandler.performBruteForceUserLockAction(username, request);
                    this.pluginHandler.performUserLogout(request, response, username);
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                    return;
                }
            }
            if ((loginAttemptsLeft = Integer.valueOf(this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username))) == 2) {
                LOGGER.debug("Only a last 2 login attempts left");
                errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
            } else if (loginAttemptsLeft == 1) {
                LOGGER.debug("Last login attempt");
                errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("BackupCode"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateBackupCodeTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATE_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public String getOtpToken() {
        return this.otpToken;
    }

    public void setOtpToken(String otpToken) {
        this.otpToken = otpToken;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

