/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationGoogleAuthenticatorAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationGoogleAuthenticatorAction.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_googleauthenticator.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationGoogleAuthenticatorAction(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationGoogleAuthenticatorAction doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_GoogleAuthenticator").booleanValue()) {
            String qrcode;
            String new_secret;
            HttpSession session = request.getSession();
            if (session.getAttribute("2fa_secret") == null) {
                new_secret = MoTwoFactorUtility.generateKey();
                qrcode = MoTwoFactorUtility.generateQrCode(new_secret, username, this.settings.getAppLabel("Crowd"));
                session.setAttribute("2fa_qrcode", (Object)qrcode);
                session.setAttribute("2fa_secret", (Object)new_secret);
            } else {
                new_secret = (String)session.getAttribute("2fa_secret");
                qrcode = (String)session.getAttribute("2fa_qrcode");
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("shouldShowSupportedApps", this.settings.getShowSupportedAppPopup());
            context.put("errorMessage", new ArrayList());
            context.put("qrcode", qrcode);
            context.put("secretKey", new_secret);
            context.put("shareSecretKey", this.settings.getEnableShareSecretKey());
            context.put("flagToDifferentiateMethodOfRegistration", "registrationUsingQrCode");
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("req", request);
            String template = this.pluginSettings.getConfigureGoogleAuthenticatorTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationGoogleAuthenticatorAction doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        HttpSession session = request.getSession(true);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String qrcode;
            String secret;
            ArrayList<String> errorMessage = new ArrayList<String>();
            String qrcodeUsingOwnSecretKey = "";
            Boolean statusOfSecretKey = true;
            String otp = StringUtils.trimToEmpty((String)request.getParameter("qrCodeOtp"));
            String ownSecretKey = StringUtils.trimToEmpty((String)request.getParameter("ownSecretKey"));
            String flagToDifferentiateMethodOfRegistration = "registrationUsingQrCode";
            if (ownSecretKey != null && ownSecretKey != "" && ownSecretKey.length() == 16) {
                otp = StringUtils.trimToEmpty((String)request.getParameter("otpUsingOwnSecretKey"));
                qrcodeUsingOwnSecretKey = MoTwoFactorUtility.generateQrCode(ownSecretKey, username, this.settings.getAppLabel("Crowd"));
                flagToDifferentiateMethodOfRegistration = "registrationUsingOwnSecretKey";
            } else if (StringUtils.isNotBlank((CharSequence)StringUtils.trimToEmpty((String)request.getParameter("otpUsingOwnSecretKey")))) {
                otp = "";
                statusOfSecretKey = false;
                LOGGER.debug("Clearing otp as no valid secret key found.");
                flagToDifferentiateMethodOfRegistration = "registrationUsingOwnSecretKey";
            }
            if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                LOGGER.debug("OTP is Valid = " + otp);
                Long otp_cast = Long.parseLong(otp);
                if (flagToDifferentiateMethodOfRegistration == "registrationUsingOwnSecretKey") {
                    secret = ownSecretKey;
                    qrcode = qrcodeUsingOwnSecretKey;
                } else {
                    qrcode = (String)session.getAttribute("2fa_qrcode");
                    secret = (String)session.getAttribute("2fa_secret");
                }
                MoTwoFactorUtility moTwoFactorUtility = new MoTwoFactorUtility();
                Long time = moTwoFactorUtility.get_interval_time();
                Boolean is_otp_valid = false;
                try {
                    is_otp_valid = moTwoFactorUtility.code_verification(secret, otp_cast, time);
                    LOGGER.debug("IS OTP VALID After 2fa : " + is_otp_valid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (is_otp_valid.booleanValue()) {
                    this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Mobile Authenticator");
                    LOGGER.debug("OTP validated Successfully...");
                    if (flagToDifferentiateMethodOfRegistration == "registrationUsingOwnSecretKey") {
                        session.setAttribute("2fa_secret", (Object)secret);
                        session.setAttribute("2fa_qrcode", (Object)qrcode);
                    }
                    MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                    twoFactorUserClass.setConfigured2FAMethodsByUser("GoogleAuthenticator");
                    twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                    String secretWithSalt = "";
                    if (StringUtils.isNotBlank((CharSequence)userSalt)) {
                        secretWithSalt = secret + userSalt;
                        String encryptedString = MoTwoFactorUtility.encryptString(secretWithSalt, this.settings.getEncryptionKey());
                        LOGGER.debug("Encrypted String " + encryptedString);
                        secret = encryptedString;
                    }
                    twoFactorUserClass.setTotpSecret(secret);
                    twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableBackupMethod())) {
                        LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                        this.settings.setUserSettings(username, twoFactorUserClass);
                        String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser());
                        if (StringUtils.isNotBlank((CharSequence)url)) {
                            response.sendRedirect(url);
                            return;
                        }
                    }
                    LOGGER.debug("2FA is Configured successfully");
                    session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    session.removeAttribute("executing_2fa_flow");
                    if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                        session.setAttribute("2fa_show_remaining_methods", (Object)true);
                    }
                    this.settings.addTo2FAConfiguredUsersList(username);
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    this.pluginHandler.redirectToValidUrl(request, response);
                    return;
                }
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Mobile Authenticator");
                errorMessage.add("Passcode is not valid");
            } else {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Mobile Authenticator");
                LOGGER.debug("OTP is Not valid");
                if (!statusOfSecretKey.booleanValue()) {
                    errorMessage.add("Please enter a valid Secret Key");
                    LOGGER.debug("No valid secret key entered.");
                } else {
                    errorMessage.add("Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)");
                    LOGGER.debug("OTP is Not valid");
                }
                secret = (String)session.getAttribute("2fa_secret");
                qrcode = (String)session.getAttribute("2fa_qrcode");
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("shouldShowSupportedApps", Boolean.FALSE);
            context.put("errorMessage", errorMessage);
            context.put("qrcode", qrcode);
            context.put("secretKey", secret);
            context.put("shareSecretKey", this.settings.getEnableShareSecretKey());
            context.put("flagToDifferentiateMethodOfRegistration", flagToDifferentiateMethodOfRegistration);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("req", request);
            String template = this.pluginSettings.getConfigureGoogleAuthenticatorTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

