/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.SignRequestData;
import com.yubico.u2f.data.messages.SignResponse;
import com.yubico.u2f.exceptions.NoEligibleDevicesException;
import com.yubico.u2f.exceptions.U2fBadConfigurationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Scanned
@Path(value="/mou2fresource")
public class MoTwoFactorHardwareTokenAjaxServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorHardwareTokenAjaxServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private RegisterRequestData registerRequestData;
    private Map<String, SignRequestData> signRequestDataMap = new HashMap<String, SignRequestData>();

    public MoTwoFactorHardwareTokenAjaxServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
    }

    @POST
    @Produces
    @Path(value="/init_register")
    public final Response initU2fDeviceRegister(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling initU2fDeviceRegister");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                this.registerRequestData = this.getRegisterRequestData(request, username);
                LOGGER.debug("registerRequestData : " + this.registerRequestData);
                return Response.ok((Object)new Gson().toJson(this.registerRequestData)).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Produces
    @Path(value="/resetU2F")
    public final Response resetU2F(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        LOGGER.debug("Calling resetU2F for " + username);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                String status;
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (configuredUser.contains(username)) {
                    configuredUser.removeAll(Collections.singleton(username));
                    status = "SUCCESS";
                } else {
                    status = "ERROR";
                }
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
                if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
                    MoTwoFactorCommonUserSettings twoFactorUserSettings = this.settings.getUserSettings(username);
                    twoFactorUserSettings = new MoTwoFactorCommonUserSettings();
                    this.settings.setUserSettings(username, twoFactorUserSettings);
                }
                return Response.ok().build();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Resetting Hardware Token : " + e);
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private RegisterRequestData getRegisterRequestData(HttpServletRequest request, String username) throws U2fBadInputException, U2fBadConfigurationException {
        LOGGER.debug("Calling getRegisterRequestData");
        Iterable<DeviceRegistration> registrations = this.getRegistrations(username);
        LOGGER.debug("Base URL : " + request.getHeader("origin"));
        return U2F.withoutAppIdValidation().startRegistration(request.getHeader("origin"), registrations);
    }

    @POST
    @Produces
    @Path(value="/register_device")
    public final Response registerU2FDevice(@Context HttpServletRequest request, @Context HttpServletResponse response, String tokenResponse) throws IOException {
        LOGGER.debug("Calling registerU2FDevice");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                JsonParser parser = new JsonParser();
                JsonObject jsonObject = parser.parse(tokenResponse).getAsJsonObject();
                tokenResponse = jsonObject.get("tokenResponse").getAsString();
                RegisterResponse registerResponse = RegisterResponse.fromJson(tokenResponse);
                DeviceRegistration registration = U2F.withoutAppIdValidation().finishRegistration(this.registerRequestData, registerResponse);
                MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
                Map<String, String> hardwareTokenU2FDeviceDetails = twoFactorCommonUserSettings.getHardwareTokenU2FDeviceDetails();
                hardwareTokenU2FDeviceDetails.put("Yubikey", registration.toJson());
                twoFactorCommonUserSettings.setHardwareTokenU2FDeviceDetails(hardwareTokenU2FDeviceDetails);
                twoFactorCommonUserSettings.setConfigured2FAMethodsByUser("YubikeyHardwareTokenAsU2F");
                this.settings.setUserSettings(username, twoFactorCommonUserSettings);
                return Response.ok().build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Produces
    @Path(value="/init_login")
    public final Response initU2FDeviceLogin(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling initU2FDeviceLogin");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                SignRequestData signRequestData = this.getSignRequestData(request, username);
                return Response.ok((Object)new Gson().toJson(signRequestData)).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private SignRequestData getSignRequestData(HttpServletRequest request, String username) throws U2fBadInputException, NoEligibleDevicesException, U2fBadConfigurationException {
        LOGGER.debug("Calling getSignRequestData");
        Iterable<DeviceRegistration> registrations = this.getRegistrations(username);
        SignRequestData u2fRequest = U2F.withoutAppIdValidation().startSignature(request.getHeader("origin"), registrations);
        String loginRequestId = u2fRequest.getRequestId();
        this.signRequestDataMap.put(loginRequestId, u2fRequest);
        return u2fRequest;
    }

    @POST
    @Produces
    @Path(value="/perform_login")
    public final Response performU2FLogin(@Context HttpServletRequest request, @Context HttpServletResponse response, String tokenResponse) throws IOException {
        LOGGER.debug("inside performU2FLogin");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                JsonParser parser = new JsonParser();
                JsonObject jsonObject = parser.parse(tokenResponse).getAsJsonObject();
                tokenResponse = jsonObject.get("tokenResponse").getAsString();
                SignResponse signResponse = SignResponse.fromJson(tokenResponse);
                U2F.withoutAppIdValidation().finishSignature(this.signRequestDataMap.get(signResponse.getRequestId()), signResponse, this.getRegistrations(username));
                this.signRequestDataMap.remove(signResponse.getRequestId());
                HttpSession session = request.getSession();
                session.setAttribute("validate_U2F_successfully", (Object)Boolean.TRUE);
                return Response.ok().build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private Iterable<DeviceRegistration> getRegistrations(String username) throws U2fBadInputException {
        LinkedList<DeviceRegistration> registrations = new LinkedList<DeviceRegistration>();
        MoTwoFactorCommonUserSettings twoFactorUserResetSettings = this.settings.getUserSettings(username);
        String deviceDetails = "";
        Map<String, String> hardwareTokenU2FDeviceDetails = twoFactorUserResetSettings.getHardwareTokenU2FDeviceDetails();
        for (String deviceName : hardwareTokenU2FDeviceDetails.keySet()) {
            deviceDetails = hardwareTokenU2FDeviceDetails.get(deviceName);
            if (!StringUtils.isNotBlank((CharSequence)deviceDetails)) continue;
            registrations.add(DeviceRegistration.fromJson(deviceDetails));
        }
        LOGGER.debug("Stored Device Registration Count : " + registrations.size());
        return registrations;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

