/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ehcache.util;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ehcache.util.CacheManager;
import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Category;

public class DefaultCacheManager
implements CacheManager {
    private static final Category log = Category.getInstance(DefaultCacheManager.class);
    net.sf.ehcache.CacheManager ehcacheManager;

    public DefaultCacheManager() {
        try {
            this.ehcacheManager = net.sf.ehcache.CacheManager.create();
        }
        catch (CacheException e) {
            log.error((Object)("Could not instantiate cacheManager: " + e.getMessage()));
        }
    }

    public Cache getCache(String name) throws EntityException {
        if (!this.ehcacheManager.cacheExists(name)) {
            try {
                log.warn((Object)("Cache named " + name + " was not in ehcache.xml. Using default settings."));
                this.ehcacheManager.addCache(name);
            }
            catch (CacheException e) {
                throw new EntityException(e);
            }
        }
        return this.ehcacheManager.getCache(name);
    }

    public void flushCaches() {
        for (int i = 0; i < this.ehcacheManager.getCacheNames().length; ++i) {
            String cacheName = this.ehcacheManager.getCacheNames()[i];
            try {
                this.ehcacheManager.getCache(cacheName).removeAll();
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Could not remove cache contents: " + e), (Throwable)e);
            }
        }
    }
}

