/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSignatureTrustEngine<TrustBasisType>
implements SignatureTrustEngine {
    private final Logger log = LoggerFactory.getLogger(BaseSignatureTrustEngine.class);
    private KeyInfoCredentialResolver keyInfoCredentialResolver;

    public BaseSignatureTrustEngine(KeyInfoCredentialResolver keyInfoResolver) {
        if (keyInfoResolver == null) {
            throw new IllegalArgumentException("KeyInfo credential resolver may not be null");
        }
        this.keyInfoCredentialResolver = keyInfoResolver;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return this.keyInfoCredentialResolver;
    }

    protected boolean validate(Signature signature, TrustBasisType trustBasis) throws SecurityException {
        this.log.debug("Attempting to verify signature and establish trust using KeyInfo-derived credentials");
        if (signature.getKeyInfo() != null) {
            KeyInfoCriteria keyInfoCriteria = new KeyInfoCriteria(signature.getKeyInfo());
            CriteriaSet keyInfoCriteriaSet = new CriteriaSet(keyInfoCriteria);
            for (Credential kiCred : this.getKeyInfoResolver().resolve(keyInfoCriteriaSet)) {
                if (!this.verifySignature(signature, kiCred)) continue;
                this.log.debug("Successfully verified signature using KeyInfo-derived credential");
                this.log.debug("Attempting to establish trust of KeyInfo-derived credential");
                if (this.evaluateTrust(kiCred, trustBasis)) {
                    this.log.debug("Successfully established trust of KeyInfo-derived credential");
                    return true;
                }
                this.log.debug("Failed to establish trust of KeyInfo-derived credential");
            }
        } else {
            this.log.debug("Signature contained no KeyInfo element, could not resolve verification credentials");
        }
        this.log.debug("Failed to verify signature and/or establish trust using any KeyInfo-derived credentials");
        return false;
    }

    protected abstract boolean evaluateTrust(Credential var1, TrustBasisType var2) throws SecurityException;

    protected boolean verifySignature(Signature signature, Credential credential) {
        SignatureValidator validator = new SignatureValidator(credential);
        try {
            validator.validate(signature);
        }
        catch (ValidationException e) {
            this.log.debug("Signature validation using candidate validation credential failed", e);
            return false;
        }
        this.log.debug("Signature validation using candidate credential was successful");
        return true;
    }

    protected void checkParams(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signature == null) {
            throw new SecurityException("Signature was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }

    protected void checkParamsRaw(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signature == null || signature.length == 0) {
            throw new SecurityException("Signature byte array was null or empty");
        }
        if (content == null || content.length == 0) {
            throw new SecurityException("Content byte array was null or empty");
        }
        if (DatatypeHelper.isEmpty(algorithmURI)) {
            throw new SecurityException("Signature algorithm was null or empty");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

