/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(KeyStoreCredentialResolver.class);
    private KeyStore keyStore;
    private Map<String, String> keyPasswords;
    private UsageType keystoreUsage;

    public KeyStoreCredentialResolver(KeyStore store, Map<String, String> passwords) throws IllegalArgumentException {
        this(store, passwords, null);
    }

    public KeyStoreCredentialResolver(KeyStore store, Map<String, String> passwords, UsageType usage) throws IllegalArgumentException {
        if (store == null) {
            throw new IllegalArgumentException("Provided key store may not be null.");
        }
        try {
            store.size();
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Keystore has not been initialized.");
        }
        this.keyStore = store;
        this.keystoreUsage = usage != null ? usage : UsageType.UNSPECIFIED;
        this.keyPasswords = passwords;
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = criteriaSet.get(EntityIDCriteria.class).getEntityID();
        UsageCriteria usageCriteria = criteriaSet.get(UsageCriteria.class);
        UsageType usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        if (!this.matchUsage(this.keystoreUsage, usage)) {
            this.log.debug("Specified usage criteria {} does not match keystore usage {}", (Object)usage, (Object)this.keystoreUsage);
            this.log.debug("Can not resolve credentials from this keystore");
            return Collections.emptySet();
        }
        KeyStore.PasswordProtection keyPassword = null;
        if (this.keyPasswords.containsKey(entityID)) {
            keyPassword = new KeyStore.PasswordProtection(this.keyPasswords.get(entityID).toCharArray());
        }
        KeyStore.Entry keyStoreEntry = null;
        try {
            keyStoreEntry = this.keyStore.getEntry(entityID, keyPassword);
        }
        catch (UnrecoverableEntryException e) {
            this.log.error("Unable to retrieve keystore entry for entityID (keystore alias): " + entityID);
            this.log.error("Check for invalid keystore entityID/alias entry password");
            throw new SecurityException("Could not retrieve entry from keystore", e);
        }
        catch (GeneralSecurityException e) {
            this.log.error("Unable to retrieve keystore entry for entityID (keystore alias): " + entityID, e);
            throw new SecurityException("Could not retrieve entry from keystore", e);
        }
        if (keyStoreEntry == null) {
            this.log.debug("Keystore entry for entity ID (keystore alias) {} does not exist", (Object)entityID);
            return Collections.emptySet();
        }
        Credential credential = this.buildCredential(keyStoreEntry, entityID, this.keystoreUsage);
        return Collections.singleton(credential);
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = criteriaSet.get(EntityIDCriteria.class);
        if (entityCriteria == null) {
            this.log.error("EntityIDCriteria was not specified in the criteria set, resolution can not be attempted");
            throw new IllegalArgumentException("No EntityIDCriteria was available in criteria set");
        }
    }

    protected boolean matchUsage(UsageType keyStoreUsage, UsageType criteriaUsage) {
        if (keyStoreUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return keyStoreUsage == criteriaUsage;
    }

    protected Credential buildCredential(KeyStore.Entry keyStoreEntry, String entityID, UsageType usage) throws SecurityException {
        this.log.debug("Building credential from keystore entry for entityID {}, usage type {}", (Object)entityID, (Object)usage);
        Credential credential = null;
        if (keyStoreEntry instanceof KeyStore.PrivateKeyEntry) {
            credential = this.processPrivateKeyEntry((KeyStore.PrivateKeyEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else if (keyStoreEntry instanceof KeyStore.TrustedCertificateEntry) {
            credential = this.processTrustedCertificateEntry((KeyStore.TrustedCertificateEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else if (keyStoreEntry instanceof KeyStore.SecretKeyEntry) {
            credential = this.processSecretKeyEntry((KeyStore.SecretKeyEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else {
            throw new SecurityException("KeyStore entry was of an unsupported type: " + keyStoreEntry.getClass().getName());
        }
        return credential;
    }

    protected X509Credential processTrustedCertificateEntry(KeyStore.TrustedCertificateEntry trustedCertEntry, String entityID, UsageType usage) {
        this.log.debug("Processing TrustedCertificateEntry from keystore");
        BasicX509Credential credential = new BasicX509Credential();
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        X509Certificate cert = (X509Certificate)trustedCertEntry.getTrustedCertificate();
        credential.setEntityCertificate(cert);
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        certChain.add(cert);
        credential.setEntityCertificateChain(certChain);
        return credential;
    }

    protected X509Credential processPrivateKeyEntry(KeyStore.PrivateKeyEntry privateKeyEntry, String entityID, UsageType usage) {
        this.log.debug("Processing PrivateKeyEntry from keystore");
        BasicX509Credential credential = new BasicX509Credential();
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        credential.setPrivateKey(privateKeyEntry.getPrivateKey());
        credential.setEntityCertificate((X509Certificate)privateKeyEntry.getCertificate());
        credential.setEntityCertificateChain(Arrays.asList((X509Certificate[])privateKeyEntry.getCertificateChain()));
        return credential;
    }

    protected Credential processSecretKeyEntry(KeyStore.SecretKeyEntry secretKeyEntry, String entityID, UsageType usage) {
        this.log.debug("Processing SecretKeyEntry from keystore");
        BasicCredential credential = new BasicCredential();
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        credential.setSecretKey(secretKeyEntry.getSecretKey());
        return credential;
    }
}

