/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorLoginFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLoginFilter.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorLoginFilter(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.pluginSettings.getLicenseVerified().booleanValue() && !this.pluginSettings.isLicenseExpired().booleanValue()) {
            if (this.pluginSettings.isNoOfUserExceed().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue()) {
                LOGGER.debug("License Error: User count exceeded ");
                chain.doFilter(request, response);
                return;
            }
        } else {
            LOGGER.debug("License Error: Expired");
            chain.doFilter(request, response);
            return;
        }
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor())) {
            HttpSession session;
            Boolean isLoadingServed;
            Map<String, String> blacklistIpAddresses;
            String decreaptedIsBypassCookie;
            Cookie isBypassCookiePresent;
            LOGGER.debug("MoTwoFactorLoginFilter doFilter called..................");
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String next = req.getParameter("next");
            if (StringUtils.isNotBlank((CharSequence)next)) {
                LOGGER.debug("next : " + next);
                String return_to = next.contains(this.pluginConfiguration.getBaseUrl()) ? next : this.pluginConfiguration.getBaseUrl().concat(next);
                LOGGER.debug("return_to : " + return_to);
                Cookie cookie = MoTwoFactorUtility.createCookie(req.getRequestURL().toString(), "CROWD_RETURNTOCOOKIE", return_to, false);
                res.addCookie(cookie);
            }
            if (BooleanUtils.toBoolean((Boolean)this.shouldIgnoreUrl(req))) {
                LOGGER.debug("Executing the default flow");
                chain.doFilter(request, response);
                return;
            }
            String username = this.pluginConfiguration.getCurrentLoggedInUser();
            if (StringUtils.isBlank((CharSequence)username)) {
                MoTwoFactorUtility.clearCookie(req, res, "MO2FA_byPass2FA");
            }
            if (StringUtils.isBlank((CharSequence)username)) {
                Boolean isSsoUrl = Boolean.FALSE;
                if (BooleanUtils.toBoolean((Boolean)this.settings.getIgnore2FAAfterSso())) {
                    String currentUrl = req.getRequestURI();
                    LOGGER.debug("Current URL : " + currentUrl);
                    String ssoLoginUrl = this.settings.getSsoLoginUrl();
                    for (String url : ssoLoginUrl.split(",")) {
                        LOGGER.debug("SSO URL : " + url);
                        if (!StringUtils.containsIgnoreCase((CharSequence)url, (CharSequence)currentUrl)) continue;
                        Cookie loginWithSsoCookie = MoTwoFactorUtility.createCookie(req.getRequestURL().toString(), "CROWD_LOGINWITHSSO", MoTwoFactorUtility.encryptString(req.getHeader("User-Agent"), "CROWD2FASSOSUCCESS"), false);
                        res.addCookie(loginWithSsoCookie);
                        isSsoUrl = Boolean.TRUE;
                        LOGGER.debug("Is SSO URL");
                        break;
                    }
                }
                if (!isSsoUrl.booleanValue()) {
                    MoTwoFactorUtility.clearCookie(req, res, "CROWD_LOGINWITHSSO");
                }
            }
            if (this.settings.getBypass2faAfterCrowdSso().booleanValue() && (isBypassCookiePresent = MoTwoFactorUtility.getCookie("MO2FA_byPass2FA", req)) != null && StringUtils.isNotBlank((CharSequence)(decreaptedIsBypassCookie = MoTwoFactorUtility.decryptString(isBypassCookiePresent.getValue(), "MO2FA_BYPASS_2FA"))) && decreaptedIsBypassCookie.contains(username)) {
                LOGGER.debug("Executing the default flow as bypassing 2fa after crowd sso");
                chain.doFilter(request, response);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)username)) {
                LOGGER.debug("User is Logged in : " + username);
                HttpSession session2 = req.getSession(true);
                if (!req.getRequestURI().contains("downloadbackupcode") && session2.getAttribute("2fa_show_remaining_methods") != null) {
                    LOGGER.debug("Redirecting user to Show Remaining methods page");
                    session2.removeAttribute("2fa_show_remaining_methods");
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_remaining2famethods"));
                    return;
                }
                Boolean twoFactorVerified = (Boolean)session2.getAttribute("2fa_verification");
                LOGGER.debug("Is Session for Verified " + twoFactorVerified);
                if (BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
                    if (this.settings.getBypass2faAfterCrowdSso().booleanValue()) {
                        Cookie bypassCookie = StringUtils.isBlank((CharSequence)this.settings.getBypass2FACookieDomain()) ? MoTwoFactorUtility.createCookie(req.getRequestURL().toString(), "MO2FA_byPass2FA", MoTwoFactorUtility.encryptString(username, "MO2FA_BYPASS_2FA"), false) : MoTwoFactorUtility.createCookieWithDomain(this.settings.getBypass2FACookieDomain(), req.getRequestURL().toString(), "MO2FA_byPass2FA", MoTwoFactorUtility.encryptString(username, "MO2FA_BYPASS_2FA"), false);
                        res.addCookie(bypassCookie);
                        LOGGER.debug("created MO2FA_byPass2FA cookie");
                    }
                    chain.doFilter(request, response);
                    return;
                }
                Cookie loginWithSsoCookie = MoTwoFactorUtility.getCookie("CROWD_LOGINWITHSSO", req);
                if (BooleanUtils.toBoolean((Boolean)this.settings.getIgnore2FAAfterSso()) && loginWithSsoCookie != null) {
                    Boolean executing2FA;
                    LOGGER.debug("loginWithSsoCookie not null");
                    MoTwoFactorUtility.clearCookie(req, res, "CROWD_LOGINWITHSSO");
                    Boolean bl = executing2FA = session2.getAttribute("executing_2fa_flow") != null ? Boolean.TRUE : Boolean.FALSE;
                    if (StringUtils.equalsIgnoreCase((CharSequence)loginWithSsoCookie.getValue(), (CharSequence)MoTwoFactorUtility.encryptString(req.getHeader("User-Agent"), "CROWD2FASSOSUCCESS")) && BooleanUtils.isFalse((Boolean)executing2FA)) {
                        LOGGER.info("User Is Logged in from SSO and user has configured 2FA. So skipping 2FA.");
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "Skipped 2FA (on SSO)", "-");
                        session2.setAttribute("2fa_verification", (Object)true);
                        this.pluginHandler.redirectToValidUrl(req, res);
                        return;
                    }
                    MoTwoFactorUtility.clearCookie(req, res, "CROWD_LOGINWITHSSO");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)username) && BooleanUtils.toBoolean((Boolean)this.settings.getEnableBruteForceProtection())) {
                LOGGER.debug("Checking for Locking of user");
                String path = req.getRequestURI();
                LOGGER.debug("path : " + path);
                if (path.contains("/twofactor/user_locked")) {
                    LOGGER.debug("Is User Locked Template URL called");
                    chain.doFilter(request, response);
                    return;
                }
                Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
                if (lockedUserDetails.size() > 0 && lockedUserDetails.containsKey(username) && this.pluginHandler.isUserLocked(username).booleanValue()) {
                    LOGGER.debug("Redirecting user to Temporary Locked URL");
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                    return;
                }
            }
            if ((blacklistIpAddresses = this.settings.getBlacklistIpAddressWithMessages()).size() > 0) {
                LOGGER.debug("Considering Blacklist IP check");
                String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(req, this.settings);
                Boolean isBlacklistIp = this.pluginHandler.isInStoredIpAddress(currentIpAddress, blacklistIpAddresses);
                if (BooleanUtils.toBoolean((Boolean)isBlacklistIp)) {
                    LOGGER.debug("IP is in Blacklist IP");
                    String path = req.getRequestURI();
                    LOGGER.debug("Path : " + path);
                    if (path.contains("/twofactor/access_denied")) {
                        LOGGER.debug("Is Access Denied Template URL called");
                        chain.doFilter(request, response);
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)username)) {
                        this.pluginHandler.performUserLogout(req, res, username);
                    }
                    LOGGER.debug("Redirecting user to Access Denied URL");
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/access_denied"));
                    return;
                }
            }
            if ((StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)username)) && BooleanUtils.toBoolean((Boolean)this.settings.getUserSettings(username).getEnable2FaForUser()) && BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !(isLoadingServed = Boolean.valueOf((session = req.getSession(true)).getAttribute("isLoadingServed") != null)).booleanValue() && MoTwoFactorUtility.getCookie("DEVICEDETAILS", req) == null) {
                Cookie returnToCookie = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", req);
                session.setAttribute("isLoadingServed", (Object)true);
                if (returnToCookie != null && !returnToCookie.getValue().isEmpty()) {
                    String return_to = returnToCookie.getValue();
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/loadingPage" + "?next=" + return_to);
                } else {
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/loadingPage");
                }
                return;
            }
            if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldConsiderMo2FA(username, req, res))) {
                LOGGER.debug("Considering 2FA for user : " + username);
                session = req.getSession(true);
                Cookie returnToCookie = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", req);
                if (returnToCookie != null && StringUtils.isNotBlank((CharSequence)returnToCookie.getValue())) {
                    LOGGER.debug("Return To : " + returnToCookie.getValue());
                    session.setAttribute("Referer", (Object)returnToCookie.getValue());
                } else {
                    String referer = req.getHeader("referer");
                    LOGGER.debug("Referer : " + referer);
                    if (referer != null && !referer.contains("userlogin") && referer.contains(this.pluginConfiguration.getBaseUrl())) {
                        session.setAttribute("Referer", (Object)referer);
                    }
                }
                String url = this.pluginHandler.findValidUrlToRedirect(username, req);
                session.setAttribute("executing_2fa_flow", (Object)Boolean.TRUE);
                res.sendRedirect(url);
                return;
            }
        }
        LOGGER.debug("Executing the default flow");
        chain.doFilter(request, response);
    }

    private Boolean isValidUrlReferer(String referer) {
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.isBlank((CharSequence)referer)) {
            return Boolean.TRUE;
        }
        String ssoLoginUrl = this.settings.getSsoLoginUrl();
        for (String url : ssoLoginUrl.split(",")) {
            url = url.trim();
            LOGGER.debug("url: " + url);
            if (!StringUtils.equalsIgnoreCase((CharSequence)url, (CharSequence)referer)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void destroy() {
    }

    private boolean shouldIgnoreUrl(HttpServletRequest req) {
        String path = req.getRequestURI();
        LOGGER.debug("Current URL : " + path);
        if (StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/download/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/images/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/favicon.ico") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/rest/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/unlockuser") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/moapi") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/console/logoff.action") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/userlogout") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/loadingPage")) {
            return true;
        }
        String skip2faUrls = this.settings.getSkip2faUrls();
        if (StringUtils.isNotBlank((CharSequence)skip2faUrls)) {
            String[] urls;
            for (String url : urls = skip2faUrls.split(";")) {
                LOGGER.debug("url to ignore 2FA: " + url);
                if (!StringUtils.isNotBlank((CharSequence)url) || !StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)url)) continue;
                return true;
            }
        }
        return false;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

