/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorConfigure2FA
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorConfigure2FA.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorConfigure2FA(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method;
        switch (method = req.getParameter("method")) {
            case "GoogleAuthenticator": {
                this.configureGoogleAuthenticator(req, resp);
                break;
            }
            case "SecurityQuestion": {
                this.configureSecurityQuestion(req, resp);
                break;
            }
            case "OtpOverEmail": {
                this.configureOtpOverEmail(req, resp);
                break;
            }
            case "OtpOverSms": {
                this.configureOtpOverSMS(req, resp);
                break;
            }
            case "DuoPushNotification": {
                this.configureDuoPushNotification(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested method is not allowed. Choose valid Method");
                return;
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String method;
        LOGGER.debug("Calling doPost Configure2FA");
        switch (method = req.getParameter("method")) {
            case "YubikeyHardwareTokenAsU2F": {
                this.configureU2FHardwareToken(req, resp);
                break;
            }
            case "WebAuthn": {
                this.configureWebAuthn(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested method is not allowed. Choose valid Method");
                return;
            }
        }
    }

    private void configureOtpOverSMS(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureOtpOverSms");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        String countryCode = StringUtils.trimToEmpty((String)req.getParameter("countryCode"));
        String mobileNumber = StringUtils.trimToEmpty((String)req.getParameter("mobileNumber"));
        LOGGER.debug("countryCode: " + countryCode);
        LOGGER.debug("mobileNumber: " + mobileNumber);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Boolean isValid = Boolean.FALSE;
            String errorMessage = "";
            String otp = StringUtils.trimToEmpty((String)req.getParameter("otp"));
            HttpSession session = req.getSession(true);
            if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
                String txId = (String)session.getAttribute("txId");
                LOGGER.debug("txId: " + txId);
                try {
                    isValid = this.pluginHandler.validateOtpUsingMiniOrangeGateway(System.currentTimeMillis(), otp, txId);
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while validating OTP via miniOrange Gateway");
                    e.printStackTrace();
                }
                if (!isValid.booleanValue()) {
                    errorMessage = "Invalid OTP Entered.";
                }
            } else {
                String storedOtpCode = (String)session.getAttribute("sms_otp_code");
                LOGGER.debug("storedOtpCode: " + storedOtpCode);
                LOGGER.debug("otp: " + otp);
                if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)storedOtpCode)) {
                    long storedOtpExpiryTime;
                    long currentTimeInMili = System.currentTimeMillis();
                    if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                        isValid = Boolean.TRUE;
                    } else {
                        isValid = Boolean.FALSE;
                        errorMessage = "Time Expires.";
                    }
                } else {
                    isValid = Boolean.FALSE;
                    errorMessage = "Invalid OTP Entered";
                }
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                LOGGER.debug("OTP validated Successfully...");
                session.removeAttribute("sms_otp_code");
                session.removeAttribute("txId");
                session.removeAttribute("otp_expiry_time");
                session.removeAttribute("last_otp_sent_time");
                session.removeAttribute("countryCode");
                session.removeAttribute("mobileNumber");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Saving 2FA details for username : " + username);
                LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
                twoFactorUserClass.setConfigured2FAMethodsByUser("OtpOverSms");
                twoFactorUserClass.setMobileNumber(mobileNumber);
                twoFactorUserClass.setCountryCode(countryCode);
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"OtpOverSms")) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverSms");
                } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverSms");
                }
                twoFactorUserClass.setCountryCode(countryCode);
                twoFactorUserClass.setMobileNumber(mobileNumber);
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
                this.sendSuccessFullResponse("OTP Over SMS Added", resp);
            } else {
                LOGGER.debug("Error : " + errorMessage);
                this.sendErrorResponse(errorMessage, resp);
            }
        } else {
            this.sendErrorResponse("User is not logged in", resp);
        }
    }

    private void configureOtpOverEmail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            HttpSession session;
            String storedOtpCode;
            Boolean isValid = Boolean.FALSE;
            String errorMessage = "";
            String otp = StringUtils.trimToEmpty((String)req.getParameter("otp"));
            if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)(storedOtpCode = (String)(session = req.getSession(true)).getAttribute("otp_code")))) {
                long storedOtpExpiryTime;
                long currentTimeInMili = System.currentTimeMillis();
                if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                    isValid = Boolean.TRUE;
                } else {
                    isValid = Boolean.FALSE;
                    errorMessage = "Time Expires.";
                }
            } else {
                isValid = Boolean.FALSE;
                errorMessage = "Invalid OTP Entered";
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                session.removeAttribute("otp_code");
                session.removeAttribute("otp_expiry_time");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
                twoFactorUserClass.setConfigured2FAMethodsByUser("OtpOverEmail");
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"OtpOverEmail")) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Successful", "OTP Over Email");
                LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
                this.sendSuccessFullResponse("OTP Over Email Added", resp);
            } else {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Failed", "OTP Over Email");
                LOGGER.debug("Error : " + errorMessage);
                this.sendErrorResponse(errorMessage, resp);
            }
        } else {
            this.sendErrorResponse("User is not logged in", resp);
            return;
        }
    }

    private void configureSecurityQuestion(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
            TreeMap<String, String> securityQuestionAnswer = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Boolean isValid = Boolean.TRUE;
            String errorMessage = "";
            for (int i = 0; i < securityQuestionCount; ++i) {
                if (req.getParameter("question_" + i) == null || req.getParameter("answer_" + i) == null) {
                    errorMessage = "EMPTY";
                    isValid = Boolean.FALSE;
                    break;
                }
                String key = req.getParameter("question_" + i).trim();
                String value = req.getParameter("answer_" + i).trim();
                if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value) && !StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Select Security Question")) {
                    if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                        errorMessage = "DUPLICATE";
                        isValid = Boolean.FALSE;
                        continue;
                    }
                    try {
                        value = MoTwoFactorUtility.hashString(value.toLowerCase());
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                        isValid = Boolean.FALSE;
                        break;
                    }
                    securityQuestionAnswer.put(key, value);
                    continue;
                }
                errorMessage = "EMPTY";
                isValid = Boolean.FALSE;
                break;
            }
            if (req.getParameter("custom_question") == null || req.getParameter("custom_answer") == null) {
                errorMessage = "EMPTY";
                isValid = Boolean.FALSE;
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                String key = req.getParameter("custom_question").trim();
                String value = req.getParameter("custom_answer").trim();
                LOGGER.debug("hash Custom Question Value " + value);
                if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value)) {
                    if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                        errorMessage = "DUPLICATE";
                        isValid = Boolean.FALSE;
                    } else {
                        try {
                            value = MoTwoFactorUtility.hashString(value.toLowerCase());
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        securityQuestionAnswer.put(key, value);
                    }
                } else {
                    errorMessage = "EMPTY";
                    isValid = Boolean.FALSE;
                }
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
                twoFactorUserClass.setSecurityQuestionAnswer(securityQuestionAnswer);
                twoFactorUserClass.setConfigured2FAMethodsByUser("SecurityQuestion");
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"SecurityQuestion")) {
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Successful", "Security Question");
                LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
                this.sendSuccessFullResponse("Security Question Added", resp);
            } else {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Failed", "Security Question");
                this.sendErrorResponse(errorMessage, resp);
            }
        } else {
            this.sendErrorResponse("User is not logged in", resp);
            return;
        }
    }

    private void configureGoogleAuthenticator(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureGoogleAuthenticator");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String otp;
            String otpForQrCode = StringUtils.trimToEmpty((String)req.getParameter("otp"));
            String ownSecretKey = StringUtils.trimToEmpty((String)req.getParameter("ownSecretKey"));
            String otpForOwnSecretKey = StringUtils.trimToEmpty((String)req.getParameter("otpForOwnSecretKey"));
            if (StringUtils.isNotBlank((CharSequence)ownSecretKey) && StringUtils.isNotBlank((CharSequence)otpForOwnSecretKey)) {
                LOGGER.debug("Registration using Own Secret Key");
                otp = otpForOwnSecretKey;
            } else {
                LOGGER.debug("Registration by scanning a QR code");
                otp = otpForQrCode;
            }
            if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                String secret;
                LOGGER.debug("OTP is Valid = " + otp);
                Long otp_cast = Long.parseLong(otp);
                if (StringUtils.isNotBlank((CharSequence)ownSecretKey) && StringUtils.isNotBlank((CharSequence)otpForOwnSecretKey)) {
                    secret = ownSecretKey;
                } else {
                    HttpSession session = req.getSession(true);
                    secret = (String)session.getAttribute("2fa_secret");
                }
                MoTwoFactorUtility moTwoFactorUtility = new MoTwoFactorUtility();
                Long time = moTwoFactorUtility.get_interval_time();
                Boolean is_otp_valid = false;
                try {
                    LOGGER.debug("OTP cast : " + otp_cast);
                    is_otp_valid = moTwoFactorUtility.code_verification(secret, otp_cast, time);
                    LOGGER.debug("IS OTP VALID After 2fa : " + is_otp_valid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    is_otp_valid = false;
                }
                if (BooleanUtils.toBoolean((Boolean)is_otp_valid)) {
                    MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                    List<String> configured2FAMethodsByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
                    configured2FAMethodsByUser.add("GoogleAuthenticator");
                    twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAMethodsByUser);
                    if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"GoogleAuthenticator")) {
                        twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                        twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    }
                    LOGGER.debug("OTP validated Successfully...");
                    String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                    String secretWithSalt = "";
                    if (StringUtils.isNotBlank((CharSequence)userSalt)) {
                        secretWithSalt = secret + userSalt;
                        String encryptedString = MoTwoFactorUtility.encryptString(secretWithSalt, this.settings.getEncryptionKey());
                        LOGGER.debug("Encrypted String " + encryptedString);
                        secret = encryptedString;
                    }
                    twoFactorUserClass.setTotpSecret(secret);
                    this.settings.addTo2FAConfiguredUsersList(username);
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    if (!configuredUser.contains(username)) {
                        configuredUser.add(username);
                        this.settings.setListOf2FAConfiguredUsers(configuredUser);
                    }
                    this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Successful", "Mobile Authenticator");
                    this.sendSuccessFullResponse("Configured Mobile Authenticator", resp);
                    return;
                }
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Failed", "Mobile Authenticator");
            this.sendErrorResponse("Issue with Configuring Mobile Authenticator", resp);
            return;
        }
        this.sendErrorResponse("User is not logged in", resp);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureDuoPushNotification(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureDuoPushNotification");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (!StringUtils.isNotBlank((CharSequence)username)) {
            this.sendErrorResponse("User is not logged in", resp);
            return;
        }
        HttpSession session = req.getSession();
        session.setAttribute("SendingDuoPushNotificationRequest", (Object)Boolean.TRUE);
        Boolean isValid = this.pluginHandler.sendDuoPushNotificationAuth(username, req) != false || this.pluginHandler.sendDuoPhoneCallAuth(username, req) != false;
        LOGGER.debug("isValid::" + isValid);
        LOGGER.debug("Duo push session Attribute: " + session.getAttribute("SendingDuoPushNotificationRequest"));
        if (isValid.booleanValue() && session.getAttribute("SendingDuoPushNotificationRequest") != null) {
            LOGGER.debug("Duo Push Notification Validates Successfully");
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Successful", "DUO Push Notification");
            session.removeAttribute("SendingDuoPushNotificationRequest");
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
            twoFactorUserClass.setConfigured2FAMethodsByUser("DuoPushNotification");
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"DuoPushNotification")) {
                twoFactorUserClass.setCurrent2FAMethod("DuoPushNotification");
            } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                twoFactorUserClass.setCurrent2FAMethod("DuoPushNotification");
            }
            this.settings.setUserSettings(username, twoFactorUserClass);
            List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
            if (!configuredUser.contains(username)) {
                configuredUser.add(username);
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
            }
            LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
            this.sendSuccessFullResponse("OTP Over Email Added", resp);
            return;
        }
        LOGGER.debug("Invalid response from Duo Push Notification. Either timeout or user is performing other action.");
        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Failed", "DUO Push Notification");
        session.removeAttribute("SendingDuoPushNotificationRequest");
        this.sendErrorResponse("Not Allowed", resp);
    }

    private void configureU2FHardwareToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MoTwoFactorCommonUserSettings twoFactorUserClass;
        LOGGER.debug("Calling configureU2FHardwareToken");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            twoFactorUserClass = this.settings.getUserSettings(username);
            LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
            if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("isWebAuthn"), (CharSequence)"true")) {
                twoFactorUserClass.setConfigured2FAMethodsByUser("YubikeyHardwareTokenAsU2F");
                this.settings.setUserSettings(username, twoFactorUserClass);
            }
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                twoFactorUserClass.setCurrent2FAMethod("YubikeyHardwareTokenAsU2F");
                twoFactorUserClass.setConfigured2FAMethodsByUser("YubikeyHardwareTokenAsU2F");
            } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                twoFactorUserClass.setCurrent2FAMethod("YubikeyHardwareTokenAsU2F");
                twoFactorUserClass.setConfigured2FAMethodsByUser("YubikeyHardwareTokenAsU2F");
            }
            this.settings.setIsWebAuthnConfigured(username, true);
            this.settings.setUserSettings(username, twoFactorUserClass);
            List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
            if (!configuredUser.contains(username)) {
                configuredUser.add(username);
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
            }
        } else {
            this.sendErrorResponse("User is not logged in", response);
            return;
        }
        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Yubikey Hardware Token");
        LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
        this.sendSuccessFullResponse("U2F Hardware Token Added", response);
    }

    private void configureWebAuthn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MoTwoFactorCommonUserSettings twoFactorUserClass;
        LOGGER.debug("Calling configureWebAuthn");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            twoFactorUserClass = this.settings.getUserSettings(username);
            LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
            twoFactorUserClass.setConfigured2FAMethodsByUser("WebAuthn");
            this.settings.setUserSettings(username, twoFactorUserClass);
            twoFactorUserClass = this.settings.getUserSettings(username);
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"WebAuthn")) {
                twoFactorUserClass.setCurrent2FAMethod("WebAuthn");
                twoFactorUserClass.setConfigured2FAMethodsByUser("WebAuthn");
            } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                twoFactorUserClass.setCurrent2FAMethod("WebAuthn");
                twoFactorUserClass.setConfigured2FAMethodsByUser("WebAuthn");
            }
            this.settings.setUserSettings(username, twoFactorUserClass);
            List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
            if (!configuredUser.contains(username)) {
                configuredUser.add(username);
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
            }
        } else {
            this.sendErrorResponse("User is not logged in", response);
            return;
        }
        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Web Authentication");
        LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
        this.sendSuccessFullResponse("Successfully configured web authn as a 2FA method", response);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

