/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import com.miniorange.twofactor.webauthn.MoSettings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorSettingsAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private Boolean enableTwoFactor;
    private String enableTwoFactorString;
    private Boolean enableBackupMethod;
    private String setQR;
    private String[] backupMethodForUser;
    private List<String> backupMethodForUserList;
    private Boolean displayEndUserReconfigurationPage;
    private String[] twoFactorMethodForUser;
    private List<String> twoFactorMethodForUserList;
    private String qrcode;
    private String secretKey;
    private Boolean googleAuthenticatorConfigured;
    private Boolean securityQuestionConfigured;
    private List<String> questionList;
    private Integer total2faEnabledUsers;
    private Boolean backupCodeConfigured;
    private Boolean shouldShowBackupCodeWarning;
    private Boolean webAuthnConfigured;
    private String currentLoggedInUser;
    private Boolean smtpConfigured;
    private Boolean otpOverEmailConfigured;
    private String otpOverEmailConfiguredString;
    private Boolean u2fHardwareTokenConfigured;
    private Boolean isSslSetup;
    private Boolean smsGatewayConfigured;
    private Boolean otpOverSmsConfigured;
    private int totalConfiguredMethods = 8;
    private Integer totalMethodsConfiguredByUser;
    private String currentDefault2faMethod;
    private Boolean allowToReconfigureMethod;
    private Boolean showRemaining2FAMethodsAfterConfiguration;
    private Boolean enableEnforceCurrentMethod;
    private Boolean showAllConfiguredMethodsDirectly;
    private String primaryMethodForUser;
    private String downloadBackupCodeUrl;
    private String attestationType;
    private String authenticatorType;
    private String userVerification;
    private String residentKey;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean shareSecretKey;
    private Boolean showWelcomePrompt;
    private String showWelcomePromptString;
    private Boolean duoPushNotificationConfigured;
    private Boolean duoPushNotificationSettingsConfigured;
    private String duoPushNotificationEnrollPortalUrl;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private MoSettings webAuthnSettings;
    private Map<String, String> webAuthnCreds;
    private String webAuthnCredsString;
    private Map<String, String> hardwareCreds;
    private String hardwareCredsString;
    private Boolean multiLingualSupportToggle;

    public MoTwoFactorSettingsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, UserManager userManager, LoginUriProvider loginUriProvider, MoSettings webAuthnSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webAuthnSettings = webAuthnSettings;
    }

    public Boolean doValidate() {
        LOGGER.debug("Configure Action doValidate");
        Boolean hasError = Boolean.FALSE;
        ArrayList<String> twoFactorMethodForUserList = new ArrayList<String>();
        if (this.twoFactorMethodForUser == null || this.twoFactorMethodForUser.length == 0) {
            this.addActionError("Please select at least 1 2FA method for User");
            hasError = Boolean.TRUE;
        } else {
            for (String method : this.twoFactorMethodForUser) {
                twoFactorMethodForUserList.add(method);
            }
            if (twoFactorMethodForUserList.contains("OtpOverEmail") && !this.pluginHandler.isSmtpConfigured().booleanValue()) {
                this.addActionError("As SMTP is not configured, won't be able to enable OTP Over Email.");
                hasError = Boolean.TRUE;
            }
            if (twoFactorMethodForUserList.contains("OtpOverSms") && !this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
                this.addActionError("As SMS Gateway is not configured, won't be able to enable OTP Over SMS.");
                hasError = Boolean.TRUE;
            }
            if (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F") && !StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                this.addActionError("HTTPS URL required to enable Yubikey Hardware Token. Make sure your Server Base URL contain HTTPS in it.");
                hasError = Boolean.TRUE;
            }
            if (twoFactorMethodForUserList.contains("WebAuthn") && twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F")) {
                this.addActionError("Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.");
                hasError = Boolean.TRUE;
            }
            if (twoFactorMethodForUserList.contains("WebAuthn") && !StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                this.addActionError("HTTPS URL required to enable Web Authentication. Make sure your Server Base URL contain HTTPS in it.");
                hasError = Boolean.TRUE;
            }
            if (twoFactorMethodForUserList.contains("DuoPushNotification") && !this.pluginHandler.isDuoPushNotificationSettingsConfigured().booleanValue()) {
                this.addActionError("Push Notification settings are not configured yet, won't be able to enable Push Notification.");
                hasError = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableEnforceCurrentMethod) && twoFactorMethodForUserList.size() != 0 && !twoFactorMethodForUserList.contains(this.primaryMethodForUser)) {
            this.addActionError("Please select the valid Primary method. It should be from 2FA methods For User method.");
            hasError = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableBackupMethod)) {
            if (this.backupMethodForUser == null) {
                this.addActionError("Please select valid Backup method for user");
                hasError = Boolean.TRUE;
            } else if (this.backupMethodForUser.length == 0) {
                this.addActionError("Please select valid Backup method for user");
                hasError = Boolean.TRUE;
            } else {
                LinkedList<String> backupMethodList = new LinkedList<String>();
                String[] stringArray = this.backupMethodForUser;
                int n = stringArray.length;
                for (int method = 0; method < n; ++method) {
                    String method2 = stringArray[method];
                    backupMethodList.add(method2);
                }
                if (backupMethodList.contains("OtpOverEmail") && !this.pluginHandler.isSmtpConfigured().booleanValue()) {
                    this.addActionError("As SMTP is not configured, won't be able to enable OTP Over Email.");
                    hasError = Boolean.TRUE;
                }
                if (backupMethodList.contains("OtpOverSms") && !this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
                    this.addActionError("As SMS Gateway is not configured, won't be able to enable OTP Over SMS.");
                    hasError = Boolean.TRUE;
                }
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableBackupMethod) && twoFactorMethodForUserList.size() > 0 && this.backupMethodForUser != null) {
            for (String method : this.backupMethodForUser) {
                if (!twoFactorMethodForUserList.contains(method)) continue;
                this.addActionError("Same method is selected for 2FA methods For User & Backup Method for user. It should not contains same method.");
                hasError = Boolean.TRUE;
                break;
            }
        }
        return hasError;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorSettingsAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("Basic_Configuration_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("Basic_Configuration_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            try {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "verify";
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("reset"), (CharSequence)"success")) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"GoogleAuthenticator")) {
                        this.addActionMessage("Mobile Authenticator is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"OtpOverEmail")) {
                        this.addActionMessage("OTP Over Email is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"OtpOverSms")) {
                        this.addActionMessage("OTP Over SMS is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"SecurityQuestion")) {
                        this.addActionMessage("Security Question is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                        this.addActionMessage("Yubikey Hardware Token(U2F) is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"DuoPushNotification")) {
                        this.addActionMessage("Duo Push Notification is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"WebAuthn")) {
                        this.addActionMessage("Web Authentication is removed. Now you can reconfigure it again.");
                    }
                }
                if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.settingsSubmitted) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    this.twoFactorMethodForUserList = new ArrayList<String>();
                    if (this.twoFactorMethodForUser != null) {
                        for (String method : this.twoFactorMethodForUser) {
                            this.twoFactorMethodForUserList.add(method);
                        }
                    }
                    LOGGER.debug("twoFactorMethodForUserList : " + this.twoFactorMethodForUserList);
                    this.backupMethodForUserList = new ArrayList<String>();
                    if (this.backupMethodForUser != null) {
                        for (String backupMethod : this.backupMethodForUser) {
                            this.backupMethodForUserList.add(backupMethod);
                        }
                    }
                    LOGGER.debug("Backup Method : " + this.backupMethodForUserList);
                    if (!BooleanUtils.toBoolean((Boolean)this.enableBackupMethod)) {
                        for (String method : this.twoFactorMethodForUserList) {
                            this.backupMethodForUserList.removeAll(Collections.singleton(method));
                        }
                        LOGGER.debug("backup Method After remove : " + this.backupMethodForUserList);
                    }
                    this.pluginHandler.save2FASettings(this.enableTwoFactor, this.enableBackupMethod, this.backupMethodForUserList, this.twoFactorMethodForUserList, this.allowToReconfigureMethod, this.enableEnforceCurrentMethod, this.primaryMethodForUser, this.showAllConfiguredMethodsDirectly, this.showRemaining2FAMethodsAfterConfiguration);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
                this.initializeConfig();
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "upm";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        LOGGER.debug("inside initializeConfig...");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        this.initializeQrCode(twoFactorUserClass);
        this.enableTwoFactor = this.settings.getEnableTwoFactor();
        this.enableBackupMethod = this.settings.getEnableBackupMethod();
        this.backupMethodForUserList = this.settings.getBackupMethodForUserList();
        this.twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        this.googleAuthenticatorConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator");
        this.duoPushNotificationConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("DuoPushNotification");
        this.duoPushNotificationSettingsConfigured = this.pluginHandler.isDuoPushNotificationSettingsConfigured();
        this.otpOverEmailConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverEmail");
        this.smtpConfigured = this.pluginHandler.isSmtpConfigured();
        this.otpOverSmsConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverSms");
        this.smsGatewayConfigured = this.pluginHandler.isSmsGatewayConfigured();
        this.securityQuestionConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion");
        this.backupCodeConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode");
        this.u2fHardwareTokenConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("YubikeyHardwareTokenAsU2F");
        this.isSslSetup = StringUtils.contains((CharSequence)this.pluginConfiguration.getBaseUrl(), (CharSequence)"https");
        this.webAuthnConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("WebAuthn");
        this.currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        this.displayEndUserReconfigurationPage = Boolean.FALSE;
        this.shouldShowBackupCodeWarning = this.backupCodeConfigured != false && twoFactorUserClass.getBackupCodes().size() == 0;
        this.questionList = this.getQuestionList();
        this.total2faEnabledUsers = this.settings.getEnable2FAForUsersList().size();
        this.totalMethodsConfiguredByUser = twoFactorUserClass.getConfigured2FAMethodsByUser().size();
        this.allowToReconfigureMethod = this.settings.getAllowToReconfigureConfigured2faMethod();
        this.showRemaining2FAMethodsAfterConfiguration = this.settings.getShowRemaining2FAMethodsAfterInlineRegistration();
        this.enableEnforceCurrentMethod = this.settings.getEnableEnforce2faMethodForUser();
        this.primaryMethodForUser = this.settings.getPrimary2faMethodForUser();
        this.showAllConfiguredMethodsDirectly = this.settings.getShowAllConfiguredMethodToUser();
        this.enableTwoFactorString = this.convertBooleanToString(this.enableTwoFactor);
        this.downloadBackupCodeUrl = this.pluginConfiguration.getDownloadBackupCodeUrl();
        this.currentDefault2faMethod = twoFactorUserClass.getCurrent2FAMethod();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.attestationType = this.settings.getAttestationType();
        this.authenticatorType = this.settings.getAuthenticatorType();
        this.userVerification = this.settings.getUserVerification();
        this.residentKey = this.settings.getResidentKey();
        this.shareSecretKey = this.settings.getEnableShareSecretKey();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.showWelcomePrompt = this.settings.getShowWelcomePrompt();
        this.showWelcomePromptString = this.convertBooleanToString(this.showWelcomePrompt);
        if (this.showWelcomePrompt.booleanValue()) {
            this.settings.setShowWelcomePrompt(Boolean.FALSE);
        }
        if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
            String encryptedSecret = twoFactorUserClass.getTotpSecret();
            String userSalt = twoFactorUserClass.getUserSalt();
            String decryptedString = MoTwoFactorUtility.decryptString(encryptedSecret, this.settings.getEncryptionKey());
            this.secretKey = decryptedString.replaceAll(userSalt, "");
            LOGGER.debug("Displayed secret key " + this.secretKey);
        }
        this.duoPushNotificationEnrollPortalUrl = "";
        HttpServletRequest request = ServletActionContext.getRequest();
        LOGGER.debug("duoPushNotificationEnrollPortalUrl::" + this.duoPushNotificationEnrollPortalUrl);
        if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
            JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, request);
            this.duoPushNotificationEnrollPortalUrl = StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString()) ? jsonObject.get("enroll_portal_url").getAsString() : "ENROLLED";
        }
        if (this.enableEnforceCurrentMethod.booleanValue() && twoFactorUserClass.getConfigured2FAMethodsByUser().contains(this.primaryMethodForUser) && !StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)this.primaryMethodForUser)) {
            twoFactorUserClass.setCurrent2FAMethod(this.primaryMethodForUser);
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        HashMap<String, String> hardwareCreds = this.webAuthnSettings.getUserRawId();
        String hardwareCredString = hardwareCreds.get(username);
        if (StringUtils.isEmpty((CharSequence)hardwareCredString)) {
            hardwareCredString = "{}";
        }
        if (!this.isValidJson(hardwareCredString)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Previous Credential", hardwareCredString);
            this.hardwareCreds = this.generateWebAuthCredMap(jsonObject);
            this.hardwareCredsString = jsonObject.toString();
        } else {
            JSONObject hardwareCredsObj = new JSONObject(hardwareCredString);
            this.hardwareCreds = this.generateWebAuthCredMap(hardwareCredsObj);
            this.hardwareCredsString = hardwareCredsObj.toString();
        }
        HashMap<String, String> webAuthnCreds = this.webAuthnSettings.getUserRawIdForWebAuthn();
        String webAuthnCredString = webAuthnCreds.get(username);
        if (StringUtils.isEmpty((CharSequence)webAuthnCredString)) {
            webAuthnCredString = "{}";
        }
        if (!this.isValidJson(webAuthnCredString)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Previous Credential", webAuthnCredString);
            this.webAuthnCreds = this.generateWebAuthCredMap(jsonObject);
            this.webAuthnCredsString = jsonObject.toString();
        } else {
            JSONObject webAuthnCredObj = new JSONObject(webAuthnCredString);
            this.webAuthnCreds = this.generateWebAuthCredMap(webAuthnCredObj);
            this.webAuthnCredsString = webAuthnCredObj.toString();
        }
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
    }

    private boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Map<String, String> generateWebAuthCredMap(JSONObject credObject) {
        HashMap<String, String> credMap = new HashMap<String, String>();
        Iterator<String> keys = credObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!(credObject.get(key) instanceof String)) continue;
            String rId = credObject.getString(key);
            credMap.put(key, rId);
        }
        return credMap;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public Boolean getEnableTwoFactor() {
        return this.enableTwoFactor;
    }

    public void setEnableTwoFactor(Boolean enableTwoFactor) {
        this.enableTwoFactor = enableTwoFactor;
    }

    public Boolean getEnableBackupMethod() {
        return this.enableBackupMethod;
    }

    public void setEnableBackupMethod(Boolean enableBackupMethod) {
        this.enableBackupMethod = enableBackupMethod;
    }

    public String getSetQR() {
        return this.setQR;
    }

    public void setSetQR(String setQR) {
        this.setQR = setQR;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String[] getBackupMethodForUser() {
        return this.backupMethodForUser;
    }

    public void setBackupMethodForUser(String[] backupMethodForUser) {
        this.backupMethodForUser = backupMethodForUser;
    }

    public List<String> getBackupMethodForUserList() {
        return this.backupMethodForUserList;
    }

    public void setBackupMethodForUserList(List<String> backupMethodForUserList) {
        this.backupMethodForUserList = backupMethodForUserList;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public Boolean getGoogleAuthenticatorConfigured() {
        return this.googleAuthenticatorConfigured;
    }

    public void setGoogleAuthenticatorConfigured(Boolean googleAuthenticatorConfigured) {
        this.googleAuthenticatorConfigured = googleAuthenticatorConfigured;
    }

    public Boolean getSecurityQuestionConfigured() {
        return this.securityQuestionConfigured;
    }

    public void setSecurityQuestionConfigured(Boolean securityQuestionConfigured) {
        this.securityQuestionConfigured = securityQuestionConfigured;
    }

    public List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public List<String> getQuestionList() {
        this.questionList = MoTwoFactorUtility.getQuestionList();
        return this.questionList;
    }

    public void setQuestionList(List<String> questionList) {
        this.questionList = questionList;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Integer getTotal2faEnabledUsers() {
        return this.total2faEnabledUsers;
    }

    public void setTotal2faEnabledUsers(Integer total2faEnabledUsers) {
        this.total2faEnabledUsers = total2faEnabledUsers;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    private void initializeQrCode(MoTwoFactorCommonUserSettings twoFactorUserClass) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
        this.settings.setUserSettings(username, twoFactorUserClass);
        session.setAttribute("2fa_verification", (Object)true);
    }

    public Integer getTotalConfiguredMethods() {
        return this.totalConfiguredMethods;
    }

    public Boolean getShouldShowDuoPushNotification() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowSecurityQuestion() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverSms() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowBackupCode() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverEmail() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowGoogleAuthenticator() {
        return Boolean.TRUE;
    }

    public String getEnableTwoFactorString() {
        return this.enableTwoFactorString;
    }

    public void setEnableTwoFactorString(String enableTwoFactorString) {
        this.enableTwoFactorString = enableTwoFactorString;
    }

    private String convertBooleanToString(Boolean booleanValue) {
        if (BooleanUtils.toBoolean((Boolean)booleanValue)) {
            return "true";
        }
        return "false";
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Boolean getBackupCodeConfigured() {
        return this.backupCodeConfigured;
    }

    public void setBackupCodeConfigured(Boolean backupCodeConfigured) {
        this.backupCodeConfigured = backupCodeConfigured;
    }

    public Boolean getShouldShowBackupCodeWarning() {
        return this.shouldShowBackupCodeWarning;
    }

    public void setShouldShowBackupCodeWarning(Boolean shouldShowBackupCodeWarning) {
        this.shouldShowBackupCodeWarning = shouldShowBackupCodeWarning;
    }

    public void setTotalConfiguredMethods(int totalConfiguredMethods) {
        this.totalConfiguredMethods = totalConfiguredMethods;
    }

    public void setDownloadBackupCodeUrl(String downloadBackupCodeUrl) {
        this.downloadBackupCodeUrl = downloadBackupCodeUrl;
    }

    public String getDownloadBackupCodeUrl() {
        return this.downloadBackupCodeUrl;
    }

    public Integer getTotalMethodsConfiguredByUser() {
        return this.totalMethodsConfiguredByUser;
    }

    public void setTotalMethodsConfiguredByUser(Integer totalMethodsConfiguredByUser) {
        this.totalMethodsConfiguredByUser = totalMethodsConfiguredByUser;
    }

    public String[] getTwoFactorMethodForUser() {
        return this.twoFactorMethodForUser;
    }

    public void setTwoFactorMethodForUser(String[] twoFactorMethodForUser) {
        this.twoFactorMethodForUser = twoFactorMethodForUser;
    }

    public List<String> getTwoFactorMethodForUserList() {
        return this.twoFactorMethodForUserList;
    }

    public void setTwoFactorMethodForUserList(List<String> twoFactorMethodForUserList) {
        this.twoFactorMethodForUserList = twoFactorMethodForUserList;
    }

    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    public Boolean getOtpOverEmailConfigured() {
        return this.otpOverEmailConfigured;
    }

    public void setOtpOverEmailConfigured(Boolean otpOverEmailConfigured) {
        this.otpOverEmailConfigured = otpOverEmailConfigured;
    }

    public String getOtpOverEmailConfiguredString() {
        return this.otpOverEmailConfiguredString;
    }

    public void setOtpOverEmailConfiguredString(String otpOverEmailConfiguredString) {
        this.otpOverEmailConfiguredString = otpOverEmailConfiguredString;
    }

    public Boolean getSmsGatewayConfigured() {
        return this.smsGatewayConfigured;
    }

    public void setSmsGatewayConfigured(Boolean smsGatewayConfigured) {
        this.smsGatewayConfigured = smsGatewayConfigured;
    }

    public Boolean getOtpOverSmsConfigured() {
        return this.otpOverSmsConfigured;
    }

    public void setOtpOverSmsConfigured(Boolean otpOverSmsConfigured) {
        this.otpOverSmsConfigured = otpOverSmsConfigured;
    }

    public String getCurrentDefault2faMethod() {
        return this.currentDefault2faMethod;
    }

    public void setCurrentDefault2faMethod(String currentDefault2faMethod) {
        this.currentDefault2faMethod = currentDefault2faMethod;
    }

    public Boolean getAllowToReconfigureMethod() {
        return this.allowToReconfigureMethod;
    }

    public void setAllowToReconfigureMethod(Boolean allowToReconfigureMethod) {
        this.allowToReconfigureMethod = allowToReconfigureMethod;
    }

    public Boolean getShowRemaining2FAMethodsAfterConfiguration() {
        return this.showRemaining2FAMethodsAfterConfiguration;
    }

    public void setShowRemaining2FAMethodsAfterConfiguration(Boolean showRemaining2FAMethodsAfterConfiguration) {
        this.showRemaining2FAMethodsAfterConfiguration = showRemaining2FAMethodsAfterConfiguration;
    }

    public Boolean getEnableEnforceCurrentMethod() {
        return this.enableEnforceCurrentMethod;
    }

    public void setEnableEnforceCurrentMethod(Boolean enableEnforceCurrentMethod) {
        this.enableEnforceCurrentMethod = enableEnforceCurrentMethod;
    }

    public String getPrimaryMethodForUser() {
        return this.primaryMethodForUser;
    }

    public void setPrimaryMethodForUser(String primaryMethodForUser) {
        this.primaryMethodForUser = primaryMethodForUser;
    }

    public Boolean getShowAllConfiguredMethodsDirectly() {
        return this.showAllConfiguredMethodsDirectly;
    }

    public void setShowAllConfiguredMethodsDirectly(Boolean showAllConfiguredMethodsDirectly) {
        this.showAllConfiguredMethodsDirectly = showAllConfiguredMethodsDirectly;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public Boolean getShareSecretKey() {
        return this.shareSecretKey;
    }

    public void setShareSecretKey(Boolean shareSecretKey) {
        this.shareSecretKey = shareSecretKey;
    }

    public Boolean getShowWelcomePrompt() {
        return this.showWelcomePrompt;
    }

    public void setShowWelcomePrompt(Boolean showWelcomePrompt) {
        this.showWelcomePrompt = showWelcomePrompt;
    }

    public String getShowWelcomePromptString() {
        return this.showWelcomePromptString;
    }

    public void setShowWelcomePromptString(String showWelcomePromptString) {
        this.showWelcomePromptString = showWelcomePromptString;
    }

    public Boolean getDuoPushNotificationConfigured() {
        return this.duoPushNotificationConfigured;
    }

    public void setDuoPushNotificationConfigured(Boolean duoPushNotificationConfigured) {
        this.duoPushNotificationConfigured = duoPushNotificationConfigured;
    }

    public Boolean getDuoPushNotificationSettingsConfigured() {
        return this.duoPushNotificationSettingsConfigured;
    }

    public void setDuoPushNotificationSettingsConfigured(Boolean duoPushNotificationSettingsConfigured) {
        this.duoPushNotificationSettingsConfigured = duoPushNotificationSettingsConfigured;
    }

    public String getDuoPushNotificationEnrollPortalUrl() {
        return this.duoPushNotificationEnrollPortalUrl;
    }

    public void setDuoPushNotificationEnrollPortalUrl(String duoPushNotificationEnrollPortalUrl) {
        this.duoPushNotificationEnrollPortalUrl = duoPushNotificationEnrollPortalUrl;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public Boolean getDisplayEndUserReconfigurationPage() {
        return this.displayEndUserReconfigurationPage;
    }

    public void setDisplayEndUserReconfigurationPage(Boolean displayEndUserReconfigurationPage) {
        this.displayEndUserReconfigurationPage = displayEndUserReconfigurationPage;
    }

    public Boolean getWebAuthnConfigured() {
        return this.webAuthnConfigured;
    }

    public void setWebAuthnConfigured(Boolean webAuthnConfigured) {
        this.webAuthnConfigured = webAuthnConfigured;
    }

    public Boolean getU2fHardwareTokenConfigured() {
        return this.u2fHardwareTokenConfigured;
    }

    public void setU2fHardwareTokenConfigured(Boolean u2fHardwareTokenConfigured) {
        this.u2fHardwareTokenConfigured = u2fHardwareTokenConfigured;
    }

    public Boolean getIsSslSetup() {
        return this.isSslSetup;
    }

    public void setIsSslSetup(Boolean sslSetup) {
        this.isSslSetup = sslSetup;
    }

    public String getAttestationType() {
        return this.attestationType;
    }

    public void setAttestationType(String attestationType) {
        this.attestationType = attestationType;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.authenticatorType = authenticatorType;
    }

    public String getUserVerification() {
        return this.userVerification;
    }

    public void setUserVerification(String userVerification) {
        this.userVerification = userVerification;
    }

    public String getResidentKey() {
        return this.residentKey;
    }

    public void setResidentKey(String residentKey) {
        this.residentKey = residentKey;
    }

    public Boolean getShouldShowU2FHardwareToken() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowWebAuthn() {
        return Boolean.TRUE;
    }

    public String getCurrentLoggedInUser() {
        return this.currentLoggedInUser;
    }

    public void setCurrentLoggedInUser(String currentLoggedInUser) {
        this.currentLoggedInUser = currentLoggedInUser;
    }

    public MoSettings getWebAuthnSettings() {
        return this.webAuthnSettings;
    }

    public void setWebAuthnSettings(MoSettings webAuthnSettings) {
        this.webAuthnSettings = webAuthnSettings;
    }

    public Map<String, String> getWebAuthnCreds() {
        return this.webAuthnCreds;
    }

    public void setWebAuthnCreds(Map<String, String> webAuthnCreds) {
        this.webAuthnCreds = webAuthnCreds;
    }

    public String getWebAuthnCredsString() {
        return this.webAuthnCredsString;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public void setWebAuthnCredsString(String webAuthnCredsString) {
        this.webAuthnCredsString = webAuthnCredsString;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public Map<String, String> getHardwareCreds() {
        return this.hardwareCreds;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public void setHardwareCreds(Map<String, String> hardwareCreds) {
        this.hardwareCreds = hardwareCreds;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public String getHardwareCredsString() {
        return this.hardwareCredsString;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public void setHardwareCredsString(String hardwareCredsString) {
        this.hardwareCredsString = hardwareCredsString;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }
}

