/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ehcache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ehcache.util.CacheManager;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import java.io.Serializable;
import java.util.HashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;

public class EhcacheUserManager
implements UserManager {
    public static final String USER_CACHE = EhcacheUserManager.class.getName() + ".users";
    public static final String USER_READ_ONLY_CACHE = EhcacheUserManager.class.getName() + ".users_ro";
    public static final String REPOSITORY_CACHE = Repository.class.getName() + ".repository";
    protected final UserManager underlyingUserManager;
    protected final CacheManager cacheManager;

    public EhcacheUserManager(UserManager underlyingUserManager, CacheManager cacheManager) {
        this.underlyingUserManager = underlyingUserManager;
        this.cacheManager = cacheManager;
    }

    public Pager getUsers() throws EntityException {
        return this.underlyingUserManager.getUsers();
    }

    public Pager getUserNames() throws EntityException {
        return this.underlyingUserManager.getUserNames();
    }

    public User getUser(String username) throws EntityException {
        User user = null;
        try {
            Element cachedUser = this.getUserCache().get((Serializable)((Object)username));
            if (cachedUser == null) {
                user = this.underlyingUserManager.getUser(username);
                this.cacheUser(username, user);
                return user;
            }
            user = (User)cachedUser.getValue();
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
        return user;
    }

    private void cacheUser(String username, User user) throws EntityException {
        Element cachedUser = new Element((Serializable)((Object)username), (Serializable)user);
        this.getUserCache().put(cachedUser);
    }

    private Element cacheRepository(String username, Repository repository) throws EntityException {
        Element cachedRepositoryElement = new Element((Serializable)((Object)username), (Serializable)repository);
        this.getRepositoryCache().put(cachedRepositoryElement);
        return cachedRepositoryElement;
    }

    private Element cacheUserROFlag(User user, boolean ro) throws EntityException {
        Element cachedUser = new Element((Serializable)((Object)user.getName()), (Serializable)user);
        this.getUserCache().put(cachedUser);
        return cachedUser;
    }

    private Cache getUserCache() throws EntityException {
        return this.cacheManager.getCache(USER_CACHE);
    }

    private Cache getUserROFlagCache() throws EntityException {
        return this.cacheManager.getCache(USER_READ_ONLY_CACHE);
    }

    private Cache getRepositoryCache() throws EntityException {
        return this.cacheManager.getCache(REPOSITORY_CACHE);
    }

    public User createUser(String username) throws EntityException {
        User user = this.underlyingUserManager.createUser(username);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
        return user;
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        this.underlyingUserManager.alterPassword(user, plainTextPass);
    }

    public void saveUser(User user) throws EntityException {
        this.underlyingUserManager.saveUser(user);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
    }

    public void removeUser(User user) throws EntityException {
        this.underlyingUserManager.removeUser(user);
        try {
            boolean result = this.removeUserFromCache(user);
            if (!result) {
                throw new CacheException();
            }
        }
        catch (CacheException e) {
            throw new EntityException("User removed in underlying repository but could not remove from cache");
        }
    }

    private boolean removeUserFromCache(User user) throws EntityException {
        return this.getUserCache().remove((Serializable)((Object)user.getName()));
    }

    public boolean isReadOnly(User user) throws EntityException {
        try {
            Element cachedROFlag = this.getUserROFlagCache().get((Serializable)((Object)user.getName()));
            if (cachedROFlag == null) {
                boolean ro = this.underlyingUserManager.isReadOnly(user);
                this.cacheUserROFlag(user, ro);
                return ro;
            }
            Boolean cachedBool = (Boolean)cachedROFlag.getValue();
            return cachedBool;
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
    }

    public Repository getRepository() {
        return this.underlyingUserManager.getRepository();
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository repository = null;
        try {
            Element cachedRepository = this.getRepositoryCache().get((Serializable)((Object)entity.getName()));
            if (cachedRepository == null) {
                repository = this.underlyingUserManager.getRepository(entity);
                this.cacheRepository(entity.getName(), repository);
                return repository;
            }
            repository = (Repository)cachedRepository.getValue();
            return repository;
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
    }

    public boolean isCreative() {
        return this.underlyingUserManager.isCreative();
    }

    public void init(HashMap args) {
    }
}

