/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import com.miniorange.twofactor.webauthn.utils.Algorithm;
import com.miniorange.twofactor.webauthn.utils.AttestationStatement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PackedAttestationStatement
extends AttestationStatement {
    public byte[] sig;
    public byte[] attestnCert;
    public List<byte[]> caCert;
    public Algorithm alg;
    public byte[] ecdaaKeyId;

    public PackedAttestationStatement(byte[] sig, byte[] attestnCert, List<byte[]> caCert, String alg) {
        this.sig = sig;
        this.attestnCert = attestnCert;
        this.caCert = caCert;
        this.alg = Algorithm.decode(alg);
        this.ecdaaKeyId = null;
    }

    public PackedAttestationStatement(byte[] sig, byte[] ecdaaKeyId, String alg) {
        this.sig = sig;
        this.ecdaaKeyId = ecdaaKeyId;
        this.alg = Algorithm.decode(alg);
        this.caCert = null;
        this.attestnCert = null;
    }

    public PackedAttestationStatement() {
        this.sig = null;
        this.attestnCert = null;
        this.caCert = null;
        this.alg = null;
        this.ecdaaKeyId = null;
    }

    public static PackedAttestationStatement decode(DataItem attStmt) {
        PackedAttestationStatement result = new PackedAttestationStatement();
        Map given = null;
        if (attStmt instanceof ByteString) {
            byte[] temp = ((ByteString)attStmt).getBytes();
            List<DataItem> dataItems = null;
            try {
                dataItems = CborDecoder.decode(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            given = (Map)dataItems.get(0);
        } else {
            given = (Map)attStmt;
        }
        block14: for (DataItem data : given.getKeys()) {
            if (!(data instanceof UnicodeString)) continue;
            switch (((UnicodeString)data).getString()) {
                case "x5c": {
                    Array array = (Array)given.get(data);
                    List<DataItem> list = array.getDataItems();
                    if (list.size() > 0) {
                        result.attestnCert = ((ByteString)list.get(0)).getBytes();
                    }
                    result.caCert = new ArrayList<byte[]>();
                    for (int i = 1; i < list.size(); ++i) {
                        result.caCert.add(((ByteString)list.get(i)).getBytes());
                    }
                    continue block14;
                }
                case "sig": {
                    result.sig = ((ByteString)given.get(data)).getBytes();
                    break;
                }
                case "alg": {
                    int algInt = new BigDecimal(((NegativeInteger)given.get(data)).getValue()).intValueExact();
                    result.alg = Algorithm.decode(algInt);
                    break;
                }
                case "ecdaaKeyId": {
                    result.ecdaaKeyId = ((ByteString)given.get(data)).getBytes();
                }
            }
        }
        return result;
    }

    @Override
    DataItem encode() throws CborException {
        Map result = new Map();
        if (this.attestnCert != null) {
            Array x5c = new Array();
            x5c.add(new ByteString(this.attestnCert));
            for (byte[] cert : this.caCert) {
                x5c.add(new ByteString(cert));
            }
            result.put(new UnicodeString("x5c"), x5c);
        }
        if (this.ecdaaKeyId != null) {
            result.put(new UnicodeString("ecdaaKeyId"), new ByteString(this.ecdaaKeyId));
        }
        result.put(new UnicodeString("sig"), new ByteString(this.sig));
        result.put(new UnicodeString("alg"), new UnicodeString(this.alg.toString()));
        return result;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.sig), Arrays.hashCode(this.attestnCert), this.caCert, this.alg, Arrays.hashCode(this.ecdaaKeyId)});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackedAttestationStatement)) {
            return false;
        }
        PackedAttestationStatement other = (PackedAttestationStatement)obj;
        try {
            return this.encode().equals(other.encode());
        }
        catch (CborException cborException) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "Packed Attestation";
    }
}

