/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorUserDetailsAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUserDetailsAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private Boolean userDetailsSubmitted;
    private String usernameSearchKeyword;
    private List<String> numberOfPagesList;
    private Integer numberOfRecordsPerPage;
    private List<String> configured2FAUserList;
    private List<String> enable2FAForUserList;
    private List<String> currentPageUsersList;
    private List<String> usernameList;
    private String userSearchFilter;
    private Boolean groupDetailsSubmitted;
    private String groupSearchKeyword;
    private List<String> groupNameList;
    private List<String> currentPageGroupsList;
    private List<String> enable2FAForGroupList;
    private String groupSearchFilter;
    private List<String> excludeGroupsList;
    private String[] excludeGroups;
    private String currentForm;
    private Map<String, String> lockedUserDetails;
    private Map<String, String> currentPageLockedUserDetails;
    private Boolean lockedUserDetailsSubmitted;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer total2faEnabledUsers;
    private Integer total2faConfiguredUsers;
    private Integer total2faEnabledGroups;
    private List<String> totalEnabledUserList;
    private List<String> totalConfiguredUserList;
    private List<String> totalDisabledUserList;
    private List<String> totalEnabledGroupList;
    private String exportUsersUrl;
    private String exportGroupsUrl;
    private String userManagementSelectedAction;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean enable2FAForAllUsers;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean multiLingualSupportToggle;
    private Integer totalUsers;
    private Integer totalUsersInCrowd;
    private Integer totalGroups;

    public MoTwoFactorUserDetailsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorUserDetailsAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("User_Management_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("User_Management_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                return "register";
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                return "verify";
            }
            this.exportUsersUrl = this.pluginConfiguration.getExportUsersUrl();
            this.exportGroupsUrl = this.pluginConfiguration.getExportGroupsUrl();
            this.excludeGroupsList = new ArrayList<String>();
            if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getUserManagementSelectedAction(), (CharSequence)"UserAction")) {
                Object searchFilter;
                String endIndexAsString;
                String startIndexAsString;
                if (StringUtils.isBlank((CharSequence)this.usernameSearchKeyword)) {
                    this.usernameSearchKeyword = "";
                }
                if (BooleanUtils.toBoolean((Boolean)this.userDetailsSubmitted)) {
                    startIndexAsString = "";
                    endIndexAsString = "";
                } else {
                    String searchKeyword = this.request.getParameter("usernameSearchKeywordUrl");
                    if (StringUtils.isNotBlank((CharSequence)searchKeyword)) {
                        this.usernameSearchKeyword = searchKeyword.trim();
                    }
                    if (StringUtils.isNotBlank((CharSequence)(searchFilter = this.request.getParameter("searchFilter")))) {
                        this.userSearchFilter = searchFilter.trim();
                    }
                    startIndexAsString = this.request.getParameter("startIndex");
                    endIndexAsString = this.request.getParameter("endIndex");
                }
                this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                    this.selectedPage = 1;
                    this.startIndex = 1;
                    this.endIndex = this.numberOfRecordsPerPage;
                } else {
                    this.startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                    this.endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                    this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                }
                if (StringUtils.isBlank((CharSequence)this.userSearchFilter)) {
                    this.userSearchFilter = "AllUsers";
                }
                this.totalEnabledUserList = this.settings.getEnable2FAForUsersList();
                this.totalConfiguredUserList = this.settings.getListOf2FAConfiguredUsers();
                this.totalDisabledUserList = this.settings.getDisable2FAForUsersList();
                this.enable2FAForAllUsers = this.settings.getEnable2FAForAllUsers();
                this.totalUsersInCrowd = this.pluginHandler.getTotalUserCount("");
                LOGGER.debug("totalUsersInCrowd :" + this.totalUsersInCrowd);
                LOGGER.info("Searching for users using " + this.usernameSearchKeyword);
                LOGGER.info("Apply Search on:  " + this.userSearchFilter);
                this.usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(this.usernameSearchKeyword);
                int page = (this.selectedPage - 1) * 20;
                this.usernameList = new ArrayList<String>();
                if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"EnabledUsers")) {
                    this.userSearchFilter = "EnabledUsers";
                    this.usernameList = this.pluginHandler.getFromList(this.totalEnabledUserList, this.usernameSearchKeyword.trim(), page);
                    this.totalUsers = this.pluginHandler.getSizeOfUserList(this.totalEnabledUserList, this.usernameSearchKeyword);
                    Collections.sort(this.usernameList);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"ConfiguredUsers")) {
                    this.userSearchFilter = "ConfiguredUsers";
                    this.usernameList = this.pluginHandler.getFromList(this.totalConfiguredUserList, this.usernameSearchKeyword.trim(), page);
                    this.totalUsers = this.pluginHandler.getSizeOfUserList(this.totalConfiguredUserList, this.usernameSearchKeyword);
                    Collections.sort(this.usernameList);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"DisabledUsers")) {
                    this.userSearchFilter = "DisabledUsers";
                    this.usernameList = this.pluginHandler.getFromList(this.totalDisabledUserList, this.usernameSearchKeyword.trim(), page);
                    this.totalUsers = this.pluginHandler.getSizeOfUserList(this.totalDisabledUserList, this.usernameSearchKeyword);
                    Collections.sort(this.usernameList);
                } else {
                    this.userSearchFilter = "AllUsers";
                    this.usernameList = this.pluginHandler.getUserFromCrowdUsingUsername(this.usernameSearchKeyword.trim(), page);
                    this.totalUsers = this.pluginHandler.getTotalUserCount(this.usernameSearchKeyword);
                }
                LOGGER.debug("totalUsers :" + this.totalUsers);
                this.configured2FAUserList = this.pluginHandler.getListOf2FAConfiguredUsersUsingUsername(this.usernameList);
                this.enable2FAForUserList = this.pluginHandler.getListOf2FAEnabledUsersUsingUsername(this.usernameList);
                this.currentPageUsersList = this.usernameList;
                this.numberOfPages = (int)Math.ceil((double)this.totalUsers.intValue() / 20.0);
                if (this.usernameList.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                    searchFilter = this;
                    Integer n = ((MoTwoFactorUserDetailsAction)((Object)searchFilter)).numberOfPages;
                    Integer n2 = ((MoTwoFactorUserDetailsAction)((Object)searchFilter)).numberOfPages = Integer.valueOf(((MoTwoFactorUserDetailsAction)((Object)searchFilter)).numberOfPages + 1);
                }
                this.total2faEnabledUsers = this.totalEnabledUserList.size();
                this.total2faConfiguredUsers = this.totalConfiguredUserList.size();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getUserManagementSelectedAction(), (CharSequence)"GroupAction")) {
                String endIndexAsString;
                String startIndexAsString;
                Object searchFilter;
                if (this.pageAccessType.equals("readwrite") && StringUtils.equalsIgnoreCase((CharSequence)this.currentForm, (CharSequence)"Form1")) {
                    if (this.excludeGroups != null && this.excludeGroups.length != 0) {
                        this.excludeGroupsList = Arrays.asList(StringUtils.split((String)this.excludeGroups[0], (String)","));
                        this.excludeGroupsList.removeAll(Arrays.asList(null, ""));
                        ArrayList<String> groupsToAdd = new ArrayList<String>();
                        if (this.excludeGroupsList.size() > 0) {
                            searchFilter = this.excludeGroupsList.iterator();
                            while (searchFilter.hasNext()) {
                                String group = (String)searchFilter.next();
                                groupsToAdd.add(group);
                            }
                            LOGGER.debug("Exclude Groups : " + groupsToAdd);
                            this.settings.setExclude2faForGroupList(groupsToAdd);
                            this.addActionMessage("Successfully added Groups.");
                        } else {
                            this.settings.setExclude2faForGroupList(new ArrayList<String>());
                        }
                    } else {
                        this.settings.setExclude2faForGroupList(new ArrayList<String>());
                    }
                    this.groupSearchKeyword = "";
                }
                this.excludeGroupsList = this.settings.getExclude2faForGroupList();
                LOGGER.debug("Saves Groups : " + this.excludeGroupsList);
                if (StringUtils.isBlank((CharSequence)this.groupSearchKeyword)) {
                    this.groupSearchKeyword = "";
                }
                if (BooleanUtils.toBoolean((Boolean)this.groupDetailsSubmitted)) {
                    startIndexAsString = "";
                    endIndexAsString = "";
                } else {
                    String searchKeyword = this.request.getParameter("groupSearchKeywordUrl");
                    if (searchKeyword != null) {
                        this.groupSearchKeyword = searchKeyword.trim();
                    }
                    if (StringUtils.isNotBlank((CharSequence)(searchFilter = this.request.getParameter("searchFilter")))) {
                        this.groupSearchFilter = ((String)searchFilter).trim();
                    }
                    startIndexAsString = this.request.getParameter("startIndex");
                    endIndexAsString = this.request.getParameter("endIndex");
                }
                this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                    this.selectedPage = 1;
                    this.startIndex = 1;
                    this.endIndex = this.numberOfRecordsPerPage;
                } else {
                    this.startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                    this.endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                    this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                }
                if (StringUtils.isBlank((CharSequence)this.groupSearchFilter)) {
                    this.groupSearchFilter = "AllGroups";
                }
                this.totalEnabledGroupList = this.settings.getEnable2FAForGroupsList();
                LOGGER.info("Searching for groups using " + this.groupSearchKeyword);
                LOGGER.info("Apply Search on:  " + this.groupSearchFilter);
                this.groupSearchKeyword = MoTwoFactorUtility.sanitizeText(this.groupSearchKeyword);
                int page = (this.selectedPage - 1) * 20;
                this.groupNameList = new ArrayList<String>();
                if (StringUtils.equalsIgnoreCase((CharSequence)this.groupSearchFilter, (CharSequence)"EnabledGroups")) {
                    this.groupSearchFilter = "EnabledGroups";
                    this.groupNameList = this.pluginHandler.getFromListForGroups(this.totalEnabledGroupList, this.groupSearchKeyword, page);
                    Collections.sort(this.groupNameList);
                    this.totalGroups = this.pluginHandler.getSizeOfGroupsList(this.totalEnabledGroupList, this.groupSearchKeyword);
                } else {
                    this.groupSearchFilter = "AllGroups";
                    this.groupNameList = this.pluginHandler.getGroupsFromCrowdUsingGroupname(this.groupSearchKeyword.trim(), page);
                    this.totalGroups = this.pluginHandler.getTotalGroupsSize(this.groupSearchKeyword.trim());
                }
                this.enable2FAForGroupList = this.pluginHandler.getListOf2FAEnabledGroupsUsingGroupname(this.groupNameList);
                this.currentPageGroupsList = this.groupNameList;
                this.numberOfPages = (int)Math.ceil((double)this.totalGroups.intValue() / 20.0);
                if (this.groupNameList.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                    MoTwoFactorUserDetailsAction moTwoFactorUserDetailsAction = this;
                    Integer n = moTwoFactorUserDetailsAction.numberOfPages;
                    Integer n3 = moTwoFactorUserDetailsAction.numberOfPages = Integer.valueOf(moTwoFactorUserDetailsAction.numberOfPages + 1);
                }
                Collections.sort(this.totalEnabledGroupList);
                this.total2faEnabledGroups = this.totalEnabledGroupList.size();
            } else {
                String endIndexAsString;
                String startIndexAsString;
                if (StringUtils.isBlank((CharSequence)this.usernameSearchKeyword)) {
                    this.usernameSearchKeyword = "";
                }
                if (BooleanUtils.toBoolean((Boolean)this.lockedUserDetailsSubmitted)) {
                    startIndexAsString = "";
                    endIndexAsString = "";
                } else {
                    String searchKeyword = this.request.getParameter("usernameSearchKeywordUrl");
                    if (searchKeyword != null) {
                        this.usernameSearchKeyword = searchKeyword.trim();
                    }
                    startIndexAsString = this.request.getParameter("startIndex");
                    endIndexAsString = this.request.getParameter("endIndex");
                }
                this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                    this.selectedPage = 1;
                    this.startIndex = 1;
                    this.endIndex = this.numberOfRecordsPerPage;
                } else {
                    this.startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                    this.endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                    this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                }
                LOGGER.info("Searching for User using " + this.usernameSearchKeyword);
                this.usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(this.usernameSearchKeyword);
                this.pluginHandler.performLockedUserDetailsCleanUp();
                this.lockedUserDetails = this.pluginHandler.getLockedUserDetailsUsingUsername(this.usernameSearchKeyword.trim(), 100);
                this.currentPageLockedUserDetails = this.pluginHandler.getSelectedDetailsForPagination(this.lockedUserDetails, (Integer)(this.startIndex - 1), (Integer)(this.endIndex - 1));
                this.numberOfPages = this.lockedUserDetails.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                if (this.lockedUserDetails.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                    MoTwoFactorUserDetailsAction moTwoFactorUserDetailsAction = this;
                    Integer n = moTwoFactorUserDetailsAction.numberOfPages;
                    Integer n4 = moTwoFactorUserDetailsAction.numberOfPages = Integer.valueOf(moTwoFactorUserDetailsAction.numberOfPages + 1);
                }
            }
            LOGGER.debug("Before initializeUserDetails");
            this.initializeUserDetails();
            return "success";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeUserDetails() {
        LOGGER.debug("inside initializeUserDetails...");
        this.userManagementSelectedAction = this.settings.getUserManagementSelectedAction();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Boolean getUserDetailsSubmitted() {
        return this.userDetailsSubmitted;
    }

    public void setUserDetailsSubmitted(Boolean userDetailsSubmitted) {
        this.userDetailsSubmitted = userDetailsSubmitted;
    }

    public String getUsernameSearchKeyword() {
        return this.usernameSearchKeyword;
    }

    public void setUsernameSearchKeyword(String usernameSearchKeyword) {
        this.usernameSearchKeyword = usernameSearchKeyword;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    public List<String> getCurrentPageUsersList() {
        return this.currentPageUsersList;
    }

    public List<String> getUsernameList() {
        return this.usernameList;
    }

    public void setUsernameList(List<String> usernameList) {
        this.usernameList = usernameList;
    }

    public void setCurrentPageUsersList(List<String> currentPageUsers) {
        this.currentPageUsersList = currentPageUsers;
    }

    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    public List<String> getConfigured2FAUserList() {
        return this.configured2FAUserList;
    }

    public void setConfigured2FAUserList(List<String> configured2FAUserList) {
        this.configured2FAUserList = configured2FAUserList;
    }

    public List<String> getEnable2FAForUserList() {
        return this.enable2FAForUserList;
    }

    public void setEnable2FAForUserList(List<String> enable2FAForUserList) {
        this.enable2FAForUserList = enable2FAForUserList;
    }

    public String getUserManagementSelectedAction() {
        return this.userManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String userManagementSelectedAction) {
        this.userManagementSelectedAction = userManagementSelectedAction;
    }

    public Boolean getGroupDetailsSubmitted() {
        return this.groupDetailsSubmitted;
    }

    public void setGroupDetailsSubmitted(Boolean groupDetailsSubmitted) {
        this.groupDetailsSubmitted = groupDetailsSubmitted;
    }

    public String getGroupSearchKeyword() {
        return this.groupSearchKeyword;
    }

    public void setGroupSearchKeyword(String groupSearchKeyword) {
        this.groupSearchKeyword = groupSearchKeyword;
    }

    public List<String> getGroupNameList() {
        return this.groupNameList;
    }

    public void setGroupNameList(List<String> groupNameList) {
        this.groupNameList = groupNameList;
    }

    public List<String> getCurrentPageGroupsList() {
        return this.currentPageGroupsList;
    }

    public void setCurrentPageGroupsList(List<String> currentPageGroupsList) {
        this.currentPageGroupsList = currentPageGroupsList;
    }

    public List<String> getEnable2FAForGroupList() {
        return this.enable2FAForGroupList;
    }

    public void setEnable2FAForGroupList(List<String> enable2FAForGroupList) {
        this.enable2FAForGroupList = enable2FAForGroupList;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public Map<String, String> getLockedUserDetails() {
        return this.lockedUserDetails;
    }

    public void setLockedUserDetails(Map<String, String> lockedUserDetails) {
        this.lockedUserDetails = lockedUserDetails;
    }

    public Map<String, String> getCurrentPageLockedUserDetails() {
        return this.currentPageLockedUserDetails;
    }

    public void setCurrentPageLockedUserDetails(Map<String, String> currentPageLockedUserDetails) {
        this.currentPageLockedUserDetails = currentPageLockedUserDetails;
    }

    public Boolean getLockedUserDetailsSubmitted() {
        return this.lockedUserDetailsSubmitted;
    }

    public void setLockedUserDetailsSubmitted(Boolean lockedUserDetailsSubmitted) {
        this.lockedUserDetailsSubmitted = lockedUserDetailsSubmitted;
    }

    public Integer getTotal2faEnabledUsers() {
        return this.total2faEnabledUsers;
    }

    public void setTotal2faEnabledUsers(Integer total2faEnabledUsers) {
        this.total2faEnabledUsers = total2faEnabledUsers;
    }

    public Integer getTotal2faConfiguredUsers() {
        return this.total2faConfiguredUsers;
    }

    public void setTotal2faConfiguredUsers(Integer total2faConfiguredUsers) {
        this.total2faConfiguredUsers = total2faConfiguredUsers;
    }

    public Integer getTotal2faEnabledGroups() {
        return this.total2faEnabledGroups;
    }

    public void setTotal2faEnabledGroups(Integer total2faEnabledGroups) {
        this.total2faEnabledGroups = total2faEnabledGroups;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public List<String> getTotalEnabledUserList() {
        return this.totalEnabledUserList;
    }

    public void setTotalEnabledUserList(List<String> totalEnabledUserList) {
        this.totalEnabledUserList = totalEnabledUserList;
    }

    public List<String> getTotalConfiguredUserList() {
        return this.totalConfiguredUserList;
    }

    public void setTotalConfiguredUserList(List<String> totalConfiguredUserList) {
        this.totalConfiguredUserList = totalConfiguredUserList;
    }

    public List<String> getTotalEnabledGroupList() {
        return this.totalEnabledGroupList;
    }

    public void setTotalEnabledGroupList(List<String> totalEnabledGroupList) {
        this.totalEnabledGroupList = totalEnabledGroupList;
    }

    public String getExportUsersUrl() {
        return this.exportUsersUrl;
    }

    public void setExportUsersUrl(String exportUsersUrl) {
        this.exportUsersUrl = exportUsersUrl;
    }

    public String getExportGroupsUrl() {
        return this.exportGroupsUrl;
    }

    public void setExportGroupsUrl(String exportGroupsUrl) {
        this.exportGroupsUrl = exportGroupsUrl;
    }

    public List<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    public void setExcludeGroupsList(List<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    public String[] getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(String[] excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public String getCurrentForm() {
        return this.currentForm;
    }

    public void setCurrentForm(String currentForm) {
        this.currentForm = currentForm;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public List<String> getTotalDisabledUserList() {
        return this.totalDisabledUserList;
    }

    public void setTotalDisabledUserList(List<String> totalDisabledUserList) {
        this.totalDisabledUserList = totalDisabledUserList;
    }

    public Boolean getEnable2FAForAllUsers() {
        return this.enable2FAForAllUsers;
    }

    public void setEnable2FAForAllUsers(Boolean enable2FAForAllUsers) {
        this.enable2FAForAllUsers = enable2FAForAllUsers;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }

    public Integer getTotalUsers() {
        return this.totalUsers;
    }

    public void setTotalUsers(Integer totalUsers) {
        this.totalUsers = totalUsers;
    }

    public Integer getTotalUsersInCrowd() {
        return this.totalUsersInCrowd;
    }

    public void setTotalUsersInCrowd(Integer totalUsersInCrowd) {
        this.totalUsersInCrowd = totalUsersInCrowd;
    }

    public Integer getTotalGroups() {
        return this.totalGroups;
    }

    public void setTotalGroups(Integer totalGroups) {
        this.totalGroups = totalGroups;
    }
}

