<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            window.onload = function() {
              window.scrollTo(0, 0);
            };
            var cnt = 0;
	        AJS.$(document).ready(function() {
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#ADVANCEDSETTINGS").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");

                AJS.$(document).on('change', '#smsGateway', function () {
                    if(AJS.$("#smsGateway").val() == "miniOrange Gateway"){
                        AJS.$("#custom_gateway_div").hide();
                        AJS.$("#miniorange_gateway_div").show();
                    }else{
                        AJS.$("#miniorange_gateway_div").hide();
                        AJS.$("#custom_gateway_div").show();
                    }
                });
                cnt = document.getElementById("totalGroupsWithAdminPagesAccessConfigs").value;
                for(var x=0; x<cnt; x++){
                    addGroupsToInputfield("#includeGroups_", x, true);
                }
	        });
	        AJS.$(document).on('click','#bypass2faAfterCrowdSso',function() {
                if(this.checked) {
                    AJS.$("#byPassCookieDomain").prop('disabled', false);
                } else {
                    AJS.$("#byPassCookieDomain").prop('disabled', true);
                }
            });
            function getAccessManagerFieldDiv(){
               var htmlElement = '<select <select class="select" name="PageName_'+cnt+'" id="PageName_'+cnt+'" style="vertical-align: bottom; width: 150px;"> <option value="" disabled selected>Select Page</option> <option value="Basic_Configuration">Two Factor Settings</option> <option value="Advanced_Settings">Advanced Settings</option> <option value="User_Management">User Management</option> <option value="Audit_Logs">Audit Logs</option> <option value="IP_Restriction">IP Restriction</option> <option value="LookAndFeel">Look and Feel Templates</option></select>'+'&nbsp;&nbsp;'+
                                  '<input class="select long-field" name="includeGroups_'+cnt+'" id="includeGroups_'+cnt+'" style="width: 205px; vertical-align: bottom; margin-left:0.5%;" placeholder="Enter Group name"></input>' + '&nbsp;&nbsp;'+
                                  '<select class="select" name="AccessType_'+cnt+'" id="AccessType_'+cnt+'" style="vertical-align: bottom; margin-left:0.5%; width: 153px;"> <option value="" disabled selected>Select Access type</option>  <option value="read">VIEW</option> <option value="readwrite">EDIT</option> </select>' + '&nbsp;&nbsp;'+
                                  '<input type="button" class="aui-button aui-button-primary" id="removePageAccessManagerField" name="removePageAccessManagerField" style="vertical-align: bottom; margin-left:0.6%;" onclick="removeAccessManagerField(this,'+ cnt +')" value="Remove"/>';
                                  return htmlElement;
            }
            function addAccessManagerField(){
                var accessManagerDiv = document.createElement('div');
                accessManagerDiv.innerHTML = getAccessManagerFieldDiv();
                var accessManager = document.getElementById("AccessManagerContainer");
                accessManager.insertAdjacentHTML('beforeend', accessManagerDiv.outerHTML +'<br>');
                addGroupsToInputfield("#includeGroups_", cnt, false);
                cnt++;
                document.getElementById("totalGroupsWithAdminPagesAccessConfigs").value = cnt;
            }
            function addGroupsToInputfield(id, count, isDatabase){
                AJS.$(id + count).auiSelect2({
                    placeholder: 'Select the Jira Groups',
                    ajax: {
                        url: AJS.contextPath() + '/plugins/servlet/twofactor/moapi',
                        data: function (params) {
                            var query = {
                                search: params,
                                action: 'fetchGroups'
                            }
                            return query;
                        },
                        results: function (data, page) {
                            return {
                                results: data.results
                            };
                        },
                    },
                    multiple: true
                });
                if(isDatabase === true){
                    var groups = AJS.$(id + count).val().split(",");
                    var includedgroups = [];
                    var groups_length = groups.length;
                    for(var i=0; i < groups_length; i++){
                        includedgroups.push({
                            "id": groups[i],
                            "text": groups[i]
                        });
                    }
                    AJS.$(id + count).auiSelect2('data', includedgroups);
                }
            }
            function removeAccessManagerField(div, val){
                div.parentNode.remove();
            }
            AJS.$(document).on('click','#enableBruteForceProtection',function() {
                if(this.checked) {
                    AJS.$("#emailTemplateBruteForce").prop('disabled', false);
                } else {
                    AJS.$("#emailTemplateBruteForce").prop('disabled', true);
                }
            });
            function validateDomain(input) {
                var domainRegex = /^[a-zA-Z0-9.-]{2,}$/;
                var urlRegex = /^(https?|ftp):\/\/[^\s/$.?#].[^\s]*$/i;
                var submitButton = document.querySelector('#settings-form-submit[value="Save"]');
                const domainResult = document.getElementById("domainResult");
                if (domainRegex.test(input) && !urlRegex.test(input)) {
                  domainResult.innerHTML = "Valid Domain.";
                  domainResult.style.color = "green";
                  submitButton.disabled = false;
                } else {
                  domainResult.innerHTML = "Invalid Domain.";
                  domainResult.style.color = "red";
                  submitButton.disabled = true;
                }
            }
            function enableSaveButton(){
                var submitButton = document.querySelector('#settings-form-submit[value="Save"]');
                const toggleButton = document.getElementById('bypass2faAfterCrowdSso');
                if (!toggleButton.classList.contains('active')) {
                    submitButton.disabled = false;
                }
            }
        </script>

        <style>
        	h4 {
        		display: block;
        		margin: 0px 65px 0px;
        		font-weight: bold;
        	}

            .aui-page-panel-content{
                padding: 0px !important;
            }

        	.aui-page-panel{
                margin: 0px !important;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }
            .toggle {
                position : relative ;
                display : inline-block;
                width : 44px !important;
                height : 14px !important;
                padding: 6px 8px !important;
                background-color: rgb(108,120,141);
                border-radius: 30px !important;
            }
            .toggle:after {
                content: '';
                margin: 1px;;
                position: absolute;
                width: 22px;
                height: 22px;
                border-radius: 50%;
                background-color: white;
                top: 1px;
                left: 1px;
                transition: all 0.5s;
                margin-left: 2px;
            }
            .input-checkbox:checked + .toggle::after {
                left : 34px;
            }
            .input-checkbox:checked + .toggle {
                background-color: rgb(0,135,90);
            }
            .input-checkbox:checked + .toggle:hover{
                background-color: rgb(76, 147, 123);
            }
            .input-checkbox + .toggle:hover{
                background-color: rgb(134, 135, 137);
            }
            .input-checkbox {
                display : none;
            }
            .checkmark {
                display:inline-block;
                transform: rotate(45deg);
                height: 12px;
                width: 5px;
                border-bottom: 2px solid white;
                border-right: 2px solid white;
                margin-left: 5px;
                margin-bottom: 2px;
            }
            .cross-div{
                width: 5px;
                height: 15px;
                position: relative;
                display: flex;
                justify-content: center;
                display:inline-block;
                margin-left: 20px;

            }
            .cross{
                width: 1.5px;
                height: 100%;
                background-color: white;
                position: absolute;
                border-radius: 2px;
            }
            .cross-left{
                transform: rotate(45deg);
            }
            .cross-right{
                transform: rotate(-45deg);
            }
            .main-toggle-div{
                display : inline-block;
                justify-content: end;
            }
        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane mo-aui-page-panel-content" id="settings"  role="tabpanel" >
        <#if showWarningMssg == true>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>Some of the configurations from <b>Access to Plugin Pages</b> are not saved!</p>
            </div>
        </#if>
        <#if pageAccessType.equals("read")>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2 style="margin:0px;">Advanced Settings</h2>
        <hr class="header"/>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>


            <div id="bruteForceSettingsDiv">
                <h3 class="subsection_title">Brute Force Protection</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"
                        <#if enableBruteForceProtection == true> checked="true"</#if> />
                        <label for="enableBruteForceProtection" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                 </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Brute Force Protection for Crowd
                    </span>
                    <div class="description">The Enable Brute force checkbox allows you to add restrict Crowd access based on the number of Login Attempts.
                    <br>
                    NOTE: The addon's Brute Force Protection won't be effective when Yubikey Hardware Token/Web Authentication is used as a Primary 2FA method.
                    </div>
                </div>

                <div class="field-group">
                    <label for="bruteForceNumberOfAttempts">Number of Attempts : </label>
                    <#if enableBruteForceProtection == true>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" />
                    <#else>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Select the number of invalid login attempts to lock the user account.</div>
                </div>

                <div class="field-group">
                    <label>User Locked out Period : </label>
                    <table>
                    <tr>
                    <td>
                    <#if enableBruteForceProtection == true>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" style="width: 110px;">
                    <#else>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" disabled style="width: 110px;">
                    </#if>
                        <option value="15 minutes" <#if bruteForceTimeInterval.equals("15 minutes")>selected </#if>>15 Minutes</option>
                        <option value="30 minutes" <#if bruteForceTimeInterval.equals("30 minutes")>selected </#if>>30 Minutes</option>
                        <option value="1 hour" <#if bruteForceTimeInterval.equals("1 hour")>selected </#if>>1 Hour</option>
                        <option value="5 hours" <#if bruteForceTimeInterval.equals("5 hours")>selected </#if>>5 Hours</option>
                        <option value="1 day" <#if bruteForceTimeInterval.equals("1 day")>selected </#if>>1 Day</option>
                        <option value="7 days" <#if bruteForceTimeInterval.equals("7 days")>selected </#if>>7 Days</option>
                        <option value="custom" <#if bruteForceTimeInterval.equals("custom")>selected </#if>>Custom</option>
                    </select>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:block" <#if enableBruteForceProtection != true> disabled </#if> />
                    <#else>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:none" <#if enableBruteForceProtection != true> disabled </#if> />
                    </#if>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:block" <#if enableBruteForceProtection != true> disabled </#if>>
                    <#else>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:none" <#if enableBruteForceProtection != true> disabled </#if> >
                    </#if>
                        <option value="minutes" <#if bruteForceCustomTimeInterval.equals("minutes")>selected </#if>>Minutes</option>
                        <option value="hours" <#if bruteForceCustomTimeInterval.equals("hours")>selected </#if>>Hours</option>
                        <option value="days" <#if bruteForceCustomTimeInterval.equals("days")>selected </#if>>Days</option>
                        </select>
                    </td>
                    </tr>
                    </table>
                    <div class="description">Once this time is expired, the user will be able to login to Crowd again.</div>
                </div>
                <div class="field-group">
                    <label for="emailTemplateBruteForce">Blocked Email Template : </label>
                    <textarea id="emailTemplateBruteForce" name="emailTemplateBruteForce" class="textarea long-field"
                        style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false" <#if (enableBruteForceProtection != true)> disabled </#if>>${emailTemplateBruteForce}</textarea>
                    <div class="description">You can customize email template sent to user. Use variable $$ipaddress$$ to add ipaddress in template</div>
                </div>
            </div>

            <br><br>
            <div id="multiLingualSupportDiv">
                <h3 class="subsection_title">Multilingual Support</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                         <input class="input-checkbox" type="checkbox" id="multiLingualSupportToggleId" value="true" name="multiLingualSupportToggle"
                                               <#if multiLingualSupportToggle == true> checked="true" </#if> />
                        <label for="multiLingualSupportToggleId" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Multilingual Support for Users
                    </span>
                    <div class="description">
                    By enabling this feature,  users will be able to select their preferred language on all 2FA plugin pages.
                    <br><b>NOTE</b>: If your end-user base primarily uses only one specific language, you can customize templates
                    from the <a href="${request.contextPath}/console/secure/plugins/twofactor-lookandfeeltemplates/lookandfeeltemplates.action">Look & Feel Templates</a> tab. However, if your end users
                    belongs from different regions and speak different languages then use this feature.
                    </div>
                </div>
            </div>
            <br><br>
            <div id="rememberMeDeviceSettingsDiv">
                <h3 class="subsection_title">Remember My Device</h3>

                <div class="field-group">
                    <div class="main-toggle-div">
                         <input class="input-checkbox" type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"
                                               <#if enableRememberMeDevice == true> checked="true" </#if> />
                        <label for="enableRememberMeDevice" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div">
                                    <div class="cross cross-left"></div>
                                    <div class="cross cross-right"></div>
                                </div>
                        </label>
                    </div>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Remember My Device for Users
                    </span>
                    <div class="description">The Remember My Device checkbox allows you to ignore 2FA check if the user is trying to log in from the same device.</div>
                </div>

                <div class="field-group">
                    <label for="rememberMeDeviceDuration">Expiry Time (in Days) : </label>
                    <#if (enableRememberMeDevice == true)>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration" autofocus="true"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" />
                    <#else>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration" autofocus="true"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Once the time has expired, the device information for that user will be clear.</div>
                </div>
            </div>
            <br><br>
                <div id="urlFilterSettingsDiv">
                    <h3 class="subsection_title">Skip 2FA for APIs running in backend</h3>

                    <div class="field-group">
                        <label for="skip2faUrls"> URLs for the backend APIs: </label>
                        <input type="text" id="skip2faUrls" name="skip2faUrls" value="${skip2faUrls}" class="text long-field" />
                        <div class="description">Enter the semicolon separated relative URLs(or part of the URLs) for the APIs which will run in the backend
                            for which you want to skip the 2FA verification</div>
                    </div>
                </div>

            <br><br>
                 <h3 class="subsection_title">One-time 2FA validation in Crowd authentication setups </h3>
                    <div class="field-group">
                        <div class="main-toggle-div">
                             <input class="input-checkbox" type="checkbox" id="bypass2faAfterCrowdSso" value="true" name="bypass2faAfterCrowdSso"
                                    onclick="enableSaveButton()"   <#if bypass2faAfterCrowdSso == true> checked="true" </#if> />
                            <label for="bypass2faAfterCrowdSso" class="toggle">
                                    <div class="checkmark"></div>
                                    <div class="cross-div">
                                        <div class="cross cross-left"></div>
                                        <div class="cross cross-right"></div>
                                    </div>
                            </label>
                    </div>
                    Enable this to allow one time 2FA when users login to multiple applications via Crowd Authentication.
                    <div class="description">2FA will be verified in first application and it will be skipped in all other apps.
                                            <br>
                                            Note: For this feature to work, this option must be enabled in 2FA app on all Crowd connected applications.
                    </div>
                    <label for="keyProvidedByCrowdSso">Parent Domain : </label>
                    <div>
                       <input type="text" id="byPassCookieDomain" name="byPassCookieDomain" value="${byPassCookieDomain}" class="text long-field"
                              oninput="validateDomain(this.value)" placeholder="Enter the parent Domain" <#if (bypass2faAfterCrowdSso != true)> disabled </#if>>
                        <p id="domainResult"></p>
                       <div class="description">Enter the parent domain for your Crowd deployment. Example: If your crowd domain is mycrowd.mycorp.com, </br>
                       then enter mycorp.com here. Leave this field empty if you want cookies to be set to the domain that requests are made to.</div>
                    </div>
                 </div>

            <br><br>
            <div id="advancedSettingsDiv">
                <h3 class="subsection_title">Mobile Authenticator Settings</h3>
                <div class="field-group">
                    <label for="appLabel">Mobile Authenticator Label: </label>
                    <input type="text" id="appLabel" name="appLabel" autofocus="true"
                          value="${appLabel}" class="text long-field" />
                    <div class="description">You can name the authenticator application using Label</div>
                </div>

                <div class="field-group">
                    <#if (showSupportedAppPopup == true)>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Show supported mobile app popup directly during inline registration
                    </span>
                    <div class="description">If enabled, it will show the supported mobile app popup directly to the user during inline registration.</div>
                    <#if (enableShareSecretKey == true)>
                        <input type="checkbox" id="enableShareSecretKey" value="true" name="enableShareSecretKey"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableShareSecretKey" value="true" name="enableShareSecretKey"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Common passcode (OTP) across all Atlassian applications
                    </span>
                    <div class="description">
                        When enabled, same account in the Mobile Authenticator app can be used for all Atlassian applications.
                        <br>
                        NOTE: Users can use an existing account created in the Mobile Authenticator app, provided they have the secret key associated with that account.
                        <br> If enabled, we suggest you to have a generic and a common Mobile Authenticator Label across all Atlassian applications.
                    </div>
                </div>
            </div>

            <br><br>
            <div id="webAuthnSettingsDiv">
                <h3 class="subsection_title">Web Authentication Settings</h3>

                <br>

                <div class="field-group">
                    <label>Attestation Type : </label>
                    <select class="select" id="attestationType" name="attestationType" style="width: 200px;">
                        <option value="none" <#if (attestationType.equals("none"))> selected </#if>>None</option>
                        <option value="direct" <#if (attestationType.equals("direct"))> selected </#if>>Direct</option>
                        <option value="indirect" <#if (attestationType.equals("indirect"))> selected </#if>>Indirect</option>
                    </select>
                    <div class="description">
                        Defining the semantics of attestation statements and their underlying trust models
                    </div>
                </div>

                <div class="field-group">
                    <label>Authenticator Type : </label>
                    <select class="select" id="authenticatorType" name="authenticatorType" style="width: 200px;">
                        <option value="unspecified" <#if (authenticatorType.equals("unspecified"))> selected </#if>>Unspecified</option>
                        <option value="cross-platform" <#if (authenticatorType.equals("cross-platform"))> selected </#if>>Cross-Platform</option>
                        <option value="platform" <#if (authenticatorType.equals("platform"))> selected </#if>>Platform (TPM)</option>
                    </select>
                    <div class="description">
                        Restrict the type of authenticators allowed for registration
                    </div>
                </div>

                <div class="field-group">
                    <label>User Verification : </label>
                    <select class="select" id="userVerification" name="userVerification" style="width: 200px;">
                        <option value="discouraged" <#if (userVerification.equals("discouraged"))> selected </#if>>Discouraged</option>
                        <option value="preferred" <#if (userVerification.equals("preferred"))> selected </#if>>Preferred</option>
                        <option value="required" <#if (userVerification.equals("required"))> selected </#if>>Required</option>
                    </select>
                    <div class="description">
                        User verification for login and registration operation
                    </div>
                </div>

                <div class="field-group">
                    <label>Register with Resident Key : </label>
                    <select class="select" id="residentKey" name="residentKey" style="width: 200px;">
                        <option value="false" <#if (residentKey.equals("false"))> selected </#if>>Not Required</option>
                        <option value="true" <#if (residentKey.equals("true"))> selected </#if>>Required</option>
                    </select>
                    <div class="description">
                        Allow logging in by proving a local PIN on the device
                    </div>
                </div>
            </div>
            <br>

            <div id="otpOverEmailSettingsDiv">
                <h3 class="subsection_title">OTP Over Email Settings</h3>

                <#if (smtpConfigured == false)>
                    <div class="field-group">
                        <div class="aui-message aui-message-warning">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>As Crowd's mail server is not configured yet. So add-on will not send any mails. You need to configure Crowd's mail server to do this.
                            </p>
                        </div>
                    </div>
                </#if>

                <div class="field-group">
                    <label for="emailTemplate">Email Template : </label>
                    <textarea name="emailTemplate" class="textarea long-field"
                        style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${emailTemplate}</textarea>
                    <div class="description">You need to write <b>$$username$$</b> and <b>$$otp$$</b> where you wish to place username & generated otp in this template respectively.</div>
                </div>

                <div class="field-group">
                    <label for="otpLength">OTP Length : </label>
                    <input type="number" id="otpLength" name="otpLength"
                          value="${otpLength}" class="text" min="4" max="8" style="width: 80px;" />
                    <div class="description">Enter the length of OTP. (The OTP length can vary from 4 to 8 characters)</div>
                </div>

                <div class="field-group">
                    <label for="otpValidityDuration">OTP Validity Duration (In Minutes) : </label>
                    <input type="number" id="otpValidityDuration" name="otpValidityDuration"
                          value="${otpValidityDuration}" class="text" min="1" max="30" style="width: 80px;" />
                    <div class="description">Once the time has expired, the OTP will consider as a Invalid.</div>
                </div>
            </div>

            <br><br>
            <div id="otpOverSmsSettingsDiv">
                <h3 class="subsection_title">OTP Over SMS Settings</h3>

                <div class="field-group">
                    <label for="smsGatewayOptions">SMS Gateway:</label>
                    <select class="select" name="smsGateway" id="smsGateway">
                        <#foreach options in smsGatewayOptions>
                            <option value="${options}" <#if (smsGateway.equals(options))> selected </#if>> ${options} </option>
                        </#foreach>
                    </select>
                </div>

                <div id="miniorange_gateway_div" <#if (smsGateway.equals("Custom Gateway"))> style="display:none" </#if>>
                    <div class="field-group">
                        <label for="customerKey">Customer Key : </label>
                        <input type="text" id="customerKey" name="customerKey" value="${customerKey}"
                               placeholder="Enter the Customer Key" class="text long-field" />
                    </div>

                    <div class="field-group">
                        <label for="apiKey">Customer API Key : </label>
                        <input type="text" id="apiKey" name="apiKey" value="${apiKey}"
                               placeholder="Enter the API Key" class="text long-field" />
                    </div>
                </div>

                <div id="custom_gateway_div" <#if (smsGateway.equals("miniOrange Gateway"))> style="display:none" </#if>>
                    <div class="field-group">
                        <label for="smsGatewayUrl">SMS Gateway URL : </label>
                        <textarea name="smsGatewayUrl" class="textarea long-field"
                            style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${smsGatewayUrl}</textarea>
                        <div class="description">
                            Enter the SMS gateway URL in the field above in order to be able to send OTPs to the user's phone.<br>
                        </div>
                    </div>

                    <div class="field-group">
                        <label for="smsTemplate">SMS Template : </label>
                        <textarea name="smsTemplate" class="textarea long-field"
                            style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${smsTemplate}</textarea>
                        <div class="description">
                            This OTP over SMS will be sent in the above format to the user.
                            You need to write <b>$$username$$</b> and <b>$$otp$$</b> where you wish to place username & generated otp in this template respectively.
                        </div>
                    </div>
                </div>
            </div>
            <br><br>
            <div id="pushNotificationSettingsDiv">
                <h3 class="subsection_title">Duo Push Notification Settings</h3>
                <br>

                <div class="field-group">
                    <label for="duoPushNotificationIntegrationKey">Integration Key: </label>
                    <input type="text" id="duoPushNotificationIntegrationKey" name="duoPushNotificationIntegrationKey" value="${duoPushNotificationIntegrationKey}" class="text long-field" />
                    <div class="description">Add Integration key from Duo.</div>
                </div>

                <div class="field-group">
                    <label for="duoPushNotificationSecretKey">Secret Key: </label>
                    <input type="text" id="duoPushNotificationSecretKey" name="duoPushNotificationSecretKey" value="${duoPushNotificationSecretKey}" class="text long-field" />
                    <div class="description">Add Secret key from Duo.</div>
                </div>

                <div class="field-group">
                    <label for="duoPushNotificationHostName">Host Name: </label>
                    <input type="text" id="duoPushNotificationHostName" name="duoPushNotificationHostName" value="${duoPushNotificationHostName}" class="text long-field" />
                    <div class="description">Add Hostname from Duo like <b>api-abcd.duosecurity.com</b>. Do not add https in hostname.</div>
                </div>
            </div>
            <br><br>
                <div id="disable2faForSsoUsers">
                    <h3 class="subsection_title">Skip 2FA on SSO</h3>
                    <div class="field-group">
                        <label for="ignore2FAAfterSso">Skip 2FA for Crowd SSO Users :</label>
                        <div class="main-toggle-div">
                             <input class="input-checkbox" type="checkbox" id="ignore2FAAfterSso" value="true" name="ignore2FAAfterSso"
                                                   <#if ignore2FAAfterSso == true> checked="true" </#if> />
                            <label for="ignore2FAAfterSso" class="toggle">
                                    <div class="checkmark"></div>
                                    <div class="cross-div">
                                        <div class="cross cross-left"></div>
                                        <div class="cross cross-right"></div>
                                    </div>
                            </label>
                        </div>
                        Enable this to skip the 2FA if users login via SSO.
                    </div>
                    <div class="field-group">
                        <label for="ssoLoginUrl">SSO Login URL : </label>
                        <input type="text" id="ssoLoginUrl" name="ssoLoginUrl" value="${ssoLoginUrl}" class="text long-field"
                            placeholder="Comma Separated SSO Login Or Callback URL" <#if (ignore2FAAfterSso != true)> disabled </#if>>
                        <div class="description">Add comma separated Single Sign on URL (SAML) or Callback URL(OAuth/OpenID) from your SSO provider.</div>
                    </div>
                </div>
            <br><br>
            <div id="PluginPagesAccessManager">
                <h3 class="subsection_title">Access to Plugin Pages</h3>
                <input type="hidden" name="totalGroupsWithAdminPagesAccessConfigs" id="totalGroupsWithAdminPagesAccessConfigs" value="${totalGroupsWithAdminPagesAccessConfigs}"/>
                <div class="field-group">
                    <div style="margin-top:1%">
                        Grant non-admin users access to plugin configuration pages.
                    </div>
                    <br>
                    <input type="button" class="aui-button aui-button-primary" id="" name="" onclick="addAccessManagerField()" value="Add New Access" style="margin-bottom: 2%;"/>

                    <div id="AccessManagerContainer">
                        <#if (!groupsWithAdminPagesAccess.isEmpty())>
                            <#assign cnt = 0>
                            <#foreach page in groupsWithAdminPagesAccess.keySet()>
                                <div>
                                    <select class="select" name="PageName_${cnt}" id="PageName_${cnt}" style="vertical-align: bottom; width: 150px;">
                                        <option value="" disabled selected>Select Page</option>
                                        <option value="Basic_Configuration" <#if (page.contains("Basic_Configuration"))> selected </#if>>Two Factor Settings</option>
                                        <option value="Advanced_Settings" <#if (page.contains("Advanced_Settings"))> selected </#if>>Advanced Settings</option>
                                        <option value="User_Management" <#if (page.contains("User_Management"))> selected </#if>>User Management</option>
                                        <option value="Audit_Logs" <#if (page.contains("Audit_Logs"))> selected </#if>>Audit Logs</option>
                                        <option value="IP_Restriction" <#if (page.contains("IP_Restriction"))> selected </#if>>IP Restriction</option>
                                        <option value="LookAndFeel" <#if (page.contains("LookAndFeel"))> selected </#if>>Look and Feel</option>
                                    </select> &nbsp;&nbsp;
                                    <input class="select long-field" name="includeGroups_${cnt}" id="includeGroups_${cnt}" style="width: 200px; vertical-align: bottom;" placeholder="Enter Group name" value="${groupsWithAdminPagesAccess.get(page)}"></input> &nbsp;&nbsp;
                                    <select class="select" name="AccessType_${cnt}" id="AccessType_${cnt}" style="vertical-align: bottom; width: 150px;">
                                        <option value="" disabled selected>Select Access type</option>
                                        <option value="read" <#if (page.contains("read"))> selected </#if>> VIEW</option>
                                        <option value="readwrite" <#if (page.contains("readwrite"))> selected </#if>>EDIT</option>
                                    </select> &nbsp;&nbsp;
                                    <input type="button" class="aui-button aui-button-primary" id="removePageAccessManagerField" name="removePageAccessManagerField" style="vertical-align: bottom;" onclick="removeAccessManagerField(this,${cnt})" value="Remove"/>
                                </div>
                                <br>
                                <#assign cnt = cnt+1>
                            </#foreach>
                        </#if>
                    </div>
            </div>
            <#if (pageAccessType.equals("readwrite"))>
                <div class="field-group">
                    </br>
                    <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
                </div>
            </#if>
            </div>
            </div>
        </form>
    </div>
    </div>
    </section>
</body>
</html>