/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorTroubleshootingAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorTroubleshootingAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean enableDebugLogs;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private Boolean multiLingualSupportToggle;

    public MoTwoFactorTroubleshootingAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info("Configure Action doValidate callled.");
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorTroubleshootingAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info("Configure Action doExecute called. ");
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "verify";
                }
                this.initializeConfig();
                Logger logger = Logger.getLogger((String)"com.miniorange.twofactor");
                if (BooleanUtils.toBoolean((Boolean)this.enableDebugLogs)) {
                    logger.setLevel(Level.DEBUG);
                } else {
                    logger.setLevel(Level.INFO);
                }
                return "success";
            }
            catch (PluginException e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "upm";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.pagesAccessibleToUser = new ArrayList<String>();
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }
}

