/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.scheduler.AuditLogScheduler;
import com.miniorange.twofactor.crowd.service.MoLogEntityService;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAuditLogs
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAuditLogs.class);
    MoTwoFactorCrowdPluginSettings pluginSettings;
    MoTwoFactorCommonPluginSettings settings;
    MoTwoFactorPluginHandler pluginHandler;
    MoTwoFactorPluginConfiguration pluginConfiguration;
    MoLogEntityService service;
    AuditLogScheduler auditLogScheduler;
    UserManager userManager;
    LoginUriProvider loginUriProvider;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIpSearchKeyword;
    private String filterUsersByPeriod;
    private String filterUsersByAction;
    private List<HashMap> moLogEntititesHashMap = new ArrayList<HashMap>();
    private Integer currentIndex = 1;
    private Integer startIndex;
    private Integer prevIndex;
    private Integer nextIndex;
    private Integer endIndex;
    private Integer lastIndex;
    private Integer totalLogs;
    private Integer start;
    private Integer end;
    private String exportAuditLogsUrl;
    private boolean autoDeleteAuditLogs = false;
    private String autoDeleteLogsAfterDays = "";
    private boolean autoDeleteAuditLogsSubmitted;
    private List<MoLogEntity> aoAuditLogs = new ArrayList<MoLogEntity>();
    private String deletionScheduleDate;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean multiLingualSupportToggle;

    public MoTwoFactorAuditLogs(MoTwoFactorCrowdPluginSettings pluginSettings, MoLogEntityService moLogEntityService, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler, UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.service = moLogEntityService;
        this.pluginSettings = pluginSettings;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfiguration = pluginConfiguration;
    }

    public String execute() throws IOException {
        LOGGER.debug("Execute called in MoTwoFactorAuditLogs...");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("Audit_Logs_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("Audit_Logs_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                return "register";
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                return "verify";
            }
            try {
                if (StringUtils.isBlank((CharSequence)this.auditLogUsernameSearchKeyword)) {
                    this.auditLogUsernameSearchKeyword = "";
                }
                if (StringUtils.isBlank((CharSequence)this.auditLogIpSearchKeyword)) {
                    this.auditLogIpSearchKeyword = "";
                }
                if (StringUtils.isBlank((CharSequence)this.filterUsersByAction)) {
                    this.filterUsersByAction = "All Actions";
                }
                if (StringUtils.isBlank((CharSequence)this.filterUsersByPeriod)) {
                    this.filterUsersByPeriod = "All Days";
                }
                LOGGER.debug("Username:" + this.auditLogUsernameSearchKeyword);
                this.aoAuditLogs = this.service.getLogs(this.currentIndex, this.filterUsersByAction, this.filterUsersByPeriod, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword, 20);
                this.totalLogs = this.service.getSize(this.filterUsersByAction, this.filterUsersByPeriod, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword);
                LocalDate localDate = LocalDate.now();
                this.deletionScheduleDate = localDate.plusDays(this.settings.getAutoDeleteAuditLogsAfterDays().intValue()).toString();
                ArrayList filteredLogs = new ArrayList();
                for (int i = 0; i < this.aoAuditLogs.size(); ++i) {
                    MoLogEntity moLogEntity = this.aoAuditLogs.get(i);
                    if (moLogEntity == null) continue;
                    HashMap<String, String> moLogEntityHash = new HashMap<String, String>();
                    moLogEntityHash.put("user", moLogEntity.getUserName());
                    SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
                    moLogEntityHash.put("dateTime", formatter.format(moLogEntity.getDateAndTime()));
                    moLogEntityHash.put("ipAddress", moLogEntity.getIpAddress());
                    moLogEntityHash.put("action", moLogEntity.getAction());
                    moLogEntityHash.put("type", moLogEntity.getLoginMethod());
                    filteredLogs.add(moLogEntityHash);
                }
                this.moLogEntititesHashMap = new ArrayList<HashMap>();
                this.setAuditIndexes(this.currentIndex, this.totalLogs);
                this.start = (this.currentIndex - 1) * 20;
                this.end = Math.min(this.start + 20, filteredLogs.size());
                int count = 0;
                for (int i = 0; i < filteredLogs.size(); ++i) {
                    this.moLogEntititesHashMap.add(count, (HashMap)filteredLogs.get(i));
                    ++count;
                }
                LOGGER.debug("Audit logs list size:" + this.moLogEntititesHashMap.size());
                if (this.autoDeleteAuditLogsSubmitted) {
                    LOGGER.debug("AutoDeleteAuditLogs value:" + this.autoDeleteAuditLogs);
                    LOGGER.debug("AutoDeleteAuditLogsAfterDays" + this.autoDeleteLogsAfterDays);
                    if (this.pageAccessType.equals("readwrite")) {
                        if (BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogs)) {
                            if (StringUtils.isNotBlank((CharSequence)this.autoDeleteLogsAfterDays)) {
                                int days = Integer.parseInt(this.autoDeleteLogsAfterDays);
                                if (days >= 1) {
                                    this.settings.setAutoDeleteAuditLogs(true);
                                    this.settings.setAutoDeleteAuditLogsAfterDays(days);
                                    this.auditLogScheduler.schedule();
                                } else {
                                    this.settings.setAutoDeleteAuditLogs(false);
                                }
                                localDate = LocalDate.now();
                                this.deletionScheduleDate = localDate.plusDays(this.settings.getAutoDeleteAuditLogsAfterDays().intValue()).toString();
                            } else {
                                this.settings.setAutoDeleteAuditLogs(false);
                            }
                        } else {
                            this.settings.setAutoDeleteAuditLogs(false);
                            this.auditLogScheduler.unschedule();
                        }
                    } else {
                        LOGGER.error("User does not have write access.");
                        this.addActionError("User does not have write access.");
                    }
                }
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "upm";
            }
            this.intialize();
            return "success";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void intialize() {
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.exportAuditLogsUrl = this.pluginSettings.getExportAuditLogsUrl();
        this.autoDeleteAuditLogs = this.settings.getAutoDeleteAuditLogs();
        this.autoDeleteLogsAfterDays = this.settings.getAutoDeleteAuditLogsAfterDays().toString();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
    }

    private void setAuditIndexes(Integer currentIndex, Integer tableSize) {
        this.lastIndex = tableSize % 20 != 0 ? Integer.valueOf(tableSize / 20 + 1) : Integer.valueOf(tableSize / 20);
        if (tableSize == 20) {
            this.lastIndex = 1;
        }
        this.prevIndex = currentIndex == 1 ? 1 : currentIndex - 1;
        this.nextIndex = currentIndex == this.lastIndex ? this.lastIndex : currentIndex + 1;
        this.startIndex = currentIndex % 5 == 0 ? currentIndex - 4 : currentIndex - (currentIndex % 5 - 1);
        this.endIndex = Integer.min(this.lastIndex, currentIndex % 5 == 0 ? currentIndex : currentIndex + (5 - currentIndex % 5));
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean noOfUserExceed) {
        this.isNoOfUserExceed = noOfUserExceed;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public List<HashMap> getMoLogEntititesHashMap() {
        return this.moLogEntititesHashMap;
    }

    public void setMoLogEntititesHashMap(List<HashMap> moLogEntititesHashMap) {
        this.moLogEntititesHashMap = moLogEntititesHashMap;
    }

    public Integer getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(Integer currentIndex) {
        this.currentIndex = currentIndex;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getPrevIndex() {
        return this.prevIndex;
    }

    public void setPrevIndex(Integer prevIndex) {
        this.prevIndex = prevIndex;
    }

    public Integer getNextIndex() {
        return this.nextIndex;
    }

    public void setNextIndex(Integer nextIndex) {
        this.nextIndex = nextIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(Integer lastIndex) {
        this.lastIndex = lastIndex;
    }

    public Integer getTotalLogs() {
        return this.totalLogs;
    }

    public void setTotalLogs(Integer totalLogs) {
        this.totalLogs = totalLogs;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public String getAuditLogUsernameSearchKeyword() {
        return this.auditLogUsernameSearchKeyword;
    }

    public void setAuditLogUsernameSearchKeyword(String auditLogUsernameSearchKeyword) {
        this.auditLogUsernameSearchKeyword = auditLogUsernameSearchKeyword;
    }

    public String getAuditLogIpSearchKeyword() {
        return this.auditLogIpSearchKeyword;
    }

    public void setAuditLogIpSearchKeyword(String auditLogIpSearchKeyword) {
        this.auditLogIpSearchKeyword = auditLogIpSearchKeyword;
    }

    public String getFilterUsersByPeriod() {
        return this.filterUsersByPeriod;
    }

    public void setFilterUsersByPeriod(String filterUsersByPeriod) {
        this.filterUsersByPeriod = filterUsersByPeriod;
    }

    public String getFilterUsersByAction() {
        return this.filterUsersByAction;
    }

    public void setFilterUsersByAction(String filterUsersByAction) {
        this.filterUsersByAction = filterUsersByAction;
    }

    public String getExportAuditLogsUrl() {
        return this.exportAuditLogsUrl;
    }

    public void setExportAuditLogsUrl(String exportAuditLogsUrl) {
        this.exportAuditLogsUrl = exportAuditLogsUrl;
    }

    public boolean getAutoDeleteAuditLogs() {
        return this.autoDeleteAuditLogs;
    }

    public void setAutoDeleteAuditLogs(boolean autoDeleteAuditLogs) {
        this.autoDeleteAuditLogs = autoDeleteAuditLogs;
    }

    public String getAutoDeleteLogsAfterDays() {
        return this.autoDeleteLogsAfterDays;
    }

    public void setAutoDeleteLogsAfterDays(String autoDeleteLogsAfterDays) {
        this.autoDeleteLogsAfterDays = autoDeleteLogsAfterDays;
    }

    public String getDeletionScheduleDate() {
        return this.deletionScheduleDate;
    }

    public void setDeletionScheduleDate(String deletionScheduleDate) {
        this.deletionScheduleDate = deletionScheduleDate;
    }

    public boolean isAutoDeleteAuditLogsSubmitted() {
        return this.autoDeleteAuditLogsSubmitted;
    }

    public void setAutoDeleteAuditLogsSubmitted(boolean autoDeleteAuditLogsSubmitted) {
        this.autoDeleteAuditLogsSubmitted = autoDeleteAuditLogsSubmitted;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }
}

