/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.AllRepositoriesQueryContext;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DelegatingEntityQueryParser
implements EntityQueryParser {
    private static final Logger log = Logger.getLogger(DelegatingEntityQueryParser.class);
    private final ArrayList entityQueryParsers;

    public DelegatingEntityQueryParser(ArrayList entityQueryParsers) {
        this.entityQueryParsers = entityQueryParsers;
    }

    public void init(HashMap args) {
    }

    public SearchResult findUsers(Query query) throws EntityException {
        return this.findUsers(query, new AllRepositoriesQueryContext());
    }

    public SearchResult findGroups(Query query) throws EntityException {
        return this.findGroups(query, new AllRepositoriesQueryContext());
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        Iterator iter = this.entityQueryParsers.iterator();
        DefaultSearchResult result = new DefaultSearchResult();
        while (iter.hasNext()) {
            EntityQueryParser parser = (EntityQueryParser)iter.next();
            SearchResult returned = null;
            try {
                returned = parser.findUsers(query, context);
            }
            catch (EntityException e) {
                log.info((Object)e.getMessage());
            }
            if (returned == null) continue;
            for (String repokey : returned.repositoryKeyset()) {
                result.addToResults(repokey, returned.pager(repokey));
            }
        }
        return result;
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        Iterator iter = this.entityQueryParsers.iterator();
        DefaultSearchResult result = new DefaultSearchResult();
        while (iter.hasNext()) {
            EntityQueryParser parser = (EntityQueryParser)iter.next();
            SearchResult returned = null;
            try {
                returned = parser.findGroups(query, context);
            }
            catch (EntityException e) {
                log.info((Object)e.getMessage());
            }
            if (returned == null) continue;
            for (String repokey : returned.repositoryKeyset()) {
                result.addToResults(repokey, returned.pager(repokey));
            }
        }
        return result;
    }
}

