/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.service.MoLogEntityService;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoLogEntityServiceImpl
implements MoLogEntityService {
    private static final Log LOGGER = LogFactory.getLog(MoLogEntityServiceImpl.class);
    private MoTwoFactorCommonPluginSettings settings;
    public ActiveObjects ao;
    private Date period;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIp;

    public MoLogEntityServiceImpl(ActiveObjects ao, MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
        this.ao = ao;
    }

    @Override
    public void add(final String user, final String ipAddress, final Date dateTime, final String action, final String type) {
        try {
            this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    MoLogEntity moLogEntity = (MoLogEntity)MoLogEntityServiceImpl.this.ao.create(MoLogEntity.class, new DBParam[0]);
                    moLogEntity.setUserName(user);
                    moLogEntity.setIpAddress(ipAddress);
                    moLogEntity.setDateAndTime(dateTime);
                    moLogEntity.setAction(action);
                    moLogEntity.setLoginMethod(type);
                    moLogEntity.save();
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Error in storing logs = " + e.getMessage());
        }
    }

    @Override
    public Integer getSize(String action, String date, String username, String ip) {
        LOGGER.debug("Getting size based on filter from the miniOrange 2FA plugin's Audit Table");
        this.period = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        if (StringUtils.isNotBlank((CharSequence)date) && !date.equals("All Days")) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger((String)date).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            this.period = new Date(timeInPast);
        }
        this.auditLogUsernameSearchKeyword = StringUtils.isBlank((CharSequence)username) ? "" : username;
        this.auditLogIp = StringUtils.isBlank((CharSequence)ip) ? "" : ip;
        Integer size = StringUtils.isBlank((CharSequence)action) || action.equals("All Actions") ? Integer.valueOf(this.ao.count(MoLogEntity.class, Query.select().where("DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{this.period, "%" + this.auditLogUsernameSearchKeyword + "%", "%" + this.auditLogIp + "%"}))) : Integer.valueOf(this.ao.count(MoLogEntity.class, Query.select().where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{action, this.period, "%" + this.auditLogUsernameSearchKeyword + "%", "%" + this.auditLogIp + "%"})));
        return size;
    }

    @Override
    public List<MoLogEntity> all() {
        LOGGER.debug("Getting records from the miniOrange 2FA plugin's Audit Table");
        return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoLogEntity>>(){

            public List<MoLogEntity> doInTransaction() {
                return Arrays.asList(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID ASC")));
            }
        });
    }

    @Override
    public List<MoLogEntity> getLogs(final Integer offset, final String action, String date, String username, String ip, Integer allLogs) {
        LOGGER.debug("Getting records from the miniOrange 2FA plugin's Audit Table");
        this.period = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        if (StringUtils.isNotBlank((CharSequence)date) && !date.equals("All Days")) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger((String)date).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            this.period = new Date(timeInPast);
        }
        this.auditLogUsernameSearchKeyword = StringUtils.isBlank((CharSequence)username) ? "" : username;
        this.auditLogIp = StringUtils.isBlank((CharSequence)ip) ? "" : ip;
        if (allLogs == -1) {
            return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoLogEntity>>(){

                public List<MoLogEntity> doInTransaction() {
                    if (StringUtils.isBlank((CharSequence)action) || action.equals("All Actions")) {
                        return Arrays.asList(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID DESC").where(" DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{MoLogEntityServiceImpl.this.period, "%" + MoLogEntityServiceImpl.this.auditLogUsernameSearchKeyword + "%", "%" + MoLogEntityServiceImpl.this.auditLogIp + "%"})));
                    }
                    return Arrays.asList(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID DESC").where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{action, MoLogEntityServiceImpl.this.period, "%" + MoLogEntityServiceImpl.this.auditLogUsernameSearchKeyword + "%", "%" + MoLogEntityServiceImpl.this.auditLogIp + "%"})));
                }
            });
        }
        return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoLogEntity>>(){

            public List<MoLogEntity> doInTransaction() {
                if (StringUtils.isBlank((CharSequence)action) || action.equals("All Actions")) {
                    return Arrays.asList(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID DESC").where(" DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{MoLogEntityServiceImpl.this.period, "%" + MoLogEntityServiceImpl.this.auditLogUsernameSearchKeyword + "%", "%" + MoLogEntityServiceImpl.this.auditLogIp + "%"}).offset((offset - 1) * 20).limit(20)));
                }
                return Arrays.asList(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID DESC").where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND USER_NAME LIKE ? AND IP_ADDRESS LIKE ?", new Object[]{action, MoLogEntityServiceImpl.this.period, "%%" + MoLogEntityServiceImpl.this.auditLogUsernameSearchKeyword + "%", "%" + MoLogEntityServiceImpl.this.auditLogIp + "%"}).offset((offset - 1) * 20).limit(20)));
            }
        });
    }

    @Override
    public void delete(Integer days) {
        if (days == 0) {
            try {
                this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                    public Void doInTransaction() {
                        LOGGER.debug("Deleting records from the miniOrange plugin's Audit Table");
                        MoLogEntityServiceImpl.this.ao.delete(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().order("ID ASC")));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            long timeMilliSecs = calendar.getTimeInMillis();
            long daysForAutoDeleteLogsInLong = days.intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            this.period = new Date(timeInPast);
            LOGGER.debug("\n date before which logs will be deleted :" + this.period);
            try {
                this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                    public Void doInTransaction() {
                        LOGGER.debug("Deleting records from the miniOrange plugin's Audit Table");
                        MoLogEntityServiceImpl.this.ao.delete(MoLogEntityServiceImpl.this.ao.find(MoLogEntity.class, Query.select().where(" DATE_AND_TIME <  ? ", new Object[]{MoLogEntityServiceImpl.this.period})));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

