/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.common;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorCommonPluginSettings {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorCommonPluginSettings.class);
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;

    public MoTwoFactorCommonPluginSettings(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getSecret() {
        return "80000";
    }

    public Boolean getEnableTwoFactor() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR"))), (boolean)false);
    }

    public void setEnableTwoFactor(Boolean enableTwoFactor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR", (Object)BooleanUtils.toString((Boolean)enableTwoFactor, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableTwoFactorForSoftware() {
        Object enableTwoFactorForSoftware = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE");
        if (enableTwoFactorForSoftware == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)enableTwoFactorForSoftware));
    }

    public void setEnableTwoFactorForSoftware(Boolean enableTwoFactorSoftware) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE", (Object)BooleanUtils.toString((Boolean)enableTwoFactorSoftware, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableTwoFactorForJsd() {
        Object enableTwoFactorForJSD = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_JSD");
        if (enableTwoFactorForJSD == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)enableTwoFactorForJSD));
    }

    public void setEnableTwoFactorForJsd(Boolean enableTwoFactorJsd) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_JSD", (Object)BooleanUtils.toString((Boolean)enableTwoFactorJsd, (String)"true", (String)"false", (String)"false"));
    }

    public String getUserManagementSelectedAction() {
        String userManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION")), (CharSequence)"UserAction");
        userManagementSelectedAction = userManagementSelectedAction.replaceAll(" ", "");
        return userManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String userManagementSelectedAction) {
        userManagementSelectedAction = userManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)userManagementSelectedAction, (CharSequence)"UserAction"))));
    }

    public Boolean getEnableBackupMethod() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD"))), (boolean)false);
    }

    public void setEnableBackupMethod(Boolean enableBackupMethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD", (Object)BooleanUtils.toString((Boolean)enableBackupMethod, (String)"true", (String)"false", (String)"false"));
    }

    public String getAppLabel(String defaultValue) {
        String appLabel = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_APP_LABEL")), (CharSequence)defaultValue);
        appLabel = appLabel.replaceAll(" ", "");
        return appLabel;
    }

    public void setAppLabel(String appLabel, String defaultValue) {
        appLabel = appLabel.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_APP_LABEL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)appLabel, (CharSequence)defaultValue))));
    }

    public Boolean getEnableRememberMeDevice() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE"))), (boolean)false);
    }

    public void setEnableRememberMeDevice(Boolean enableRememberMeDevice) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE", (Object)BooleanUtils.toString((Boolean)enableRememberMeDevice, (String)"true", (String)"false", (String)"false"));
    }

    public void setBypass2faAfterCrowdSso(Boolean bypass2faAfterCrowdSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO", (Object)BooleanUtils.toString((Boolean)bypass2faAfterCrowdSso, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getBypass2faAfterCrowdSso() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO"))), (boolean)false);
    }

    public Integer getRememberMeDeviceDuration() {
        String rememberMeDeviceDuration = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION");
        if (NumberUtils.isDigits((String)rememberMeDeviceDuration)) {
            return NumberUtils.createInteger((String)rememberMeDeviceDuration);
        }
        return 1;
    }

    public void setRememberMeDeviceDuration(Integer rememberMeDeviceDuration) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION", (Object)String.valueOf(rememberMeDeviceDuration));
    }

    public List<String> getBackupMethodForUserList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER");
        if (value == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)value;
    }

    public void setBackupMethodForUserList(List<String> backupMethodList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER", backupMethodList);
    }

    public void addTo2FAConfiguredUsersList(String username) {
        List<String> configuredUsers = this.getListOf2FAConfiguredUsers();
        if (!configuredUsers.contains(username)) {
            configuredUsers.add(username);
            this.setListOf2FAConfiguredUsers(configuredUsers);
        }
    }

    public List<String> getListOf2FAConfiguredUsers() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setListOf2FAConfiguredUsers(List<String> configuredUsers) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST", configuredUsers);
    }

    public String getEncryptionKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENCRYPTION_KEY")), (CharSequence)"");
    }

    public void setEncryptionKey(String encryptionKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENCRYPTION_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)encryptionKey, (CharSequence)""))));
    }

    public void setUserSettings(String username, MoTwoFactorCommonUserSettings userRelatedSettings) {
        JsonObject jsonObject = this.convertToJsonObject(userRelatedSettings);
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username, (Object)jsonObject.toString());
    }

    public MoTwoFactorCommonUserSettings getUserSettings(String username) {
        Object userRelatedSettings = this.pluginSettings.get("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username);
        if (userRelatedSettings != null) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.getFromJsonObject((String)userRelatedSettings);
            return twoFactorUserClass;
        }
        return new MoTwoFactorCommonUserSettings();
    }

    public void setIsWebAuthnConfigured(String username, Boolean isWebAuthnConfigured) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username, (Object)BooleanUtils.toString((Boolean)isWebAuthnConfigured, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsWebAuthnConfigured(String username) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username))), (boolean)false);
    }

    public List<String> getEnable2FAForUsersList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setEnable2FAForUsersList(List<String> enable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST", enable2FAFor);
    }

    public List<String> getDisable2FAForUsersList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setDisable2FAForUsersList(List<String> disable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST", disable2FAFor);
    }

    public List<String> getEnable2FAForGroupsList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setEnable2FAForGroupsList(List<String> enable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST", enable2FAFor);
    }

    public Boolean getEnable2FAForAllUsers() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS"))), (boolean)false);
    }

    public void setEnable2FAForAllUsers(Boolean enableTwoFactorForAllUsers) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS", (Object)BooleanUtils.toString((Boolean)enableTwoFactorForAllUsers, (String)"true", (String)"false", (String)"false"));
    }

    public String getIpManagementSelectedAction() {
        String ipManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION")), (CharSequence)"WhitelistIpAction");
        ipManagementSelectedAction = ipManagementSelectedAction.replaceAll(" ", "");
        return ipManagementSelectedAction;
    }

    public void setIpManagementSelectedAction(String ipManagementSelectedAction) {
        ipManagementSelectedAction = ipManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)ipManagementSelectedAction, (CharSequence)"WhitelistIpAction"))));
    }

    public String getSkip2faUrls() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SKIP_2FA_URLS")), (CharSequence)"");
    }

    public void setSkip2faUrls(String skip2faUrls) {
        Object[] urls = skip2faUrls.split(";");
        for (int index = 0; index < urls.length; ++index) {
            urls[index] = StringUtils.trim((String)urls[index]);
        }
        skip2faUrls = StringUtils.join((Object[])urls, (String)";");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SKIP_2FA_URLS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)skip2faUrls, (CharSequence)""))));
    }

    public void setGroupsWithAdminPagesAccess(Map<String, String> groupsWithAdminPagesAccess) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS", groupsWithAdminPagesAccess);
    }

    public Map<String, String> getGroupsWithAdminPagesAccess() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS");
        }
        return new HashMap<String, String>();
    }

    public void setWhitelistIpAddresses(List<String> whitelistIpAddresses) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES", whitelistIpAddresses);
    }

    public List<String> getWhitelistIpAddresses() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES");
        }
        return new ArrayList<String>();
    }

    public void setWhitelistIpAddressWithMessages(Map<String, String> whitelistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", whitelistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getWhitelistIpAddressWithMessages() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        }
        return new HashMap<String, String>();
    }

    public void setWhitelistIpAddressAndMessagesInMap(Map<String, String> whitelistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", whitelistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getWhitelistIpAddressWithMessagesOld() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_WITH_COMMENT") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_WITH_COMMENT");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddressWithMessages(Map<String, String> blacklistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", blacklistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getBlacklistIpAddressWithMessages() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddressAndMessagesInMap(Map<String, String> blacklistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", blacklistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getBlacklistIpAddressWithMessagesOld() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_WITH_COMMENT") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_WITH_COMMENT");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddresses(List<String> blacklistIpAddresses) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES", blacklistIpAddresses);
    }

    public List<String> getBlacklistIpAddresses() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES");
        }
        return new ArrayList<String>();
    }

    public void setLockedUserDetails(Map<String, String> lockedUserDetails) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS", lockedUserDetails);
    }

    public Map<String, String> getLockedUserDetails() {
        HashMap lockedUserDetails = (HashMap)this.pluginSettings.get("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS");
        if (lockedUserDetails == null) {
            return new HashMap<String, String>();
        }
        return lockedUserDetails;
    }

    public Boolean getEnableBruteForceProtection() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION"))), (boolean)false);
    }

    public void setEnableBruteForceProtection(Boolean enableBruteForceProtection) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION", (Object)BooleanUtils.toString((Boolean)enableBruteForceProtection, (String)"true", (String)"false", (String)"false"));
    }

    public Integer getBruteForceNumberOfAttempts() {
        String bruteForceNumberOfAttempts = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS");
        if (NumberUtils.isDigits((String)bruteForceNumberOfAttempts)) {
            return NumberUtils.createInteger((String)bruteForceNumberOfAttempts);
        }
        return 3;
    }

    public void setBruteForceNumberOfAttempts(Integer bruteForceNumberOfAttempts) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS", (Object)String.valueOf(bruteForceNumberOfAttempts));
    }

    public String getBruteForceTimeInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL")), (CharSequence)"30 minutes");
    }

    public void setBruteForceTimeInterval(String bruteForceTimeInterval) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bruteForceTimeInterval, (CharSequence)"30 minutes"))));
    }

    public String getBruteForceCustomTimeInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL")), (CharSequence)"minutes");
    }

    public void setBruteForceCustomTimeInterval(String bruteForceCustomTimeInterval) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bruteForceCustomTimeInterval, (CharSequence)"minutes"))));
    }

    public Integer getBruteForceCustomTimeDuration() {
        String bruteForceNumberOfAttempts = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION");
        if (NumberUtils.isDigits((String)bruteForceNumberOfAttempts)) {
            return NumberUtils.createInteger((String)bruteForceNumberOfAttempts);
        }
        return 30;
    }

    public void setBruteForceCustomTimeDuration(Integer bruteForceNumberOfAttempts) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION", (Object)String.valueOf(bruteForceNumberOfAttempts));
    }

    public List<String> get2FAMethodForUserList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER");
        if (value == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("GoogleAuthenticator");
            return arrayList;
        }
        return (ArrayList)value;
    }

    public void set2FAMethodForUserList(List<String> methodForUserList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER", methodForUserList);
    }

    public Boolean getAllowToReconfigureConfigured2faMethod() {
        String allowToReconfigureConfigured2faMethod = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD");
        if (StringUtils.isBlank((CharSequence)allowToReconfigureConfigured2faMethod)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)allowToReconfigureConfigured2faMethod);
    }

    public void setAllowToReconfigureConfigured2faMethod(Boolean allowToReconfigureConfigured2faMethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD", (Object)BooleanUtils.toString((Boolean)allowToReconfigureConfigured2faMethod, (String)"true", (String)"false", (String)"false"));
    }

    public void setCombineIpAddressAndIpMessage(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCombineIpAddressAndIpMessage() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED"))), (boolean)false);
    }

    public Boolean getCombineIpAddressAndIpMessageInMapMigration() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_COMMENTS_TO_IN_MAP_MIGRATED"))), (boolean)false);
    }

    public void setCombineIpAddressAndCommentsInMap(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_COMMENTS_TO_IN_MAP_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableEnforce2faMethodForUser() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER"))), (boolean)false);
    }

    public void setDisableUsersListMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DISABLED_USERS_LIST_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getDisableUsersListMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_USERS_LIST_MIGRATED"))), (boolean)false);
    }

    public void setEnableEnforce2faMethodForUser(Boolean enableEnforceCurrentmethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER", (Object)BooleanUtils.toString((Boolean)enableEnforceCurrentmethod, (String)"true", (String)"false", (String)"false"));
    }

    public String getPrimary2faMethodForUser() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER")), (CharSequence)"GoogleAuthenticator");
    }

    public void setPrimary2faMethodForUser(String primary2faMethodForUser) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)primary2faMethodForUser, (CharSequence)"GoogleAuthenticator"))));
    }

    public String getEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE")), (CharSequence)"Dear $$username$$, Your OTP is $$otp$$ Use this Passcode to complete your action. Thank you.");
    }

    public void setEmailTemplate(String emailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplate, (CharSequence)"Dear $$username$$, Your OTP is $$otp$$ Use this Passcode to complete your action. Thank you."))));
    }

    public String getEmailTemplateBruteForce() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE")), (CharSequence)"Due to several failed attempts from $$ipaddress$$, your Crowd account is temporarily locked. If it is not you then please contact your administrator and change your password as soon as possible.");
    }

    public void setEmailTemplateBruteForce(String emailTemplateBruteForce) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplateBruteForce, (CharSequence)"Due to several failed attempts from $$ipaddress$$, your Crowd account is temporarily locked. If it is not you then please contact your administrator and change your password as soon as possible."))));
    }

    public String getEmailTemplateBruteForceForSoloAdmin() {
        return "Dear $$username$$,\n\nYour organization has introduced Two-factor Authentication(2FA) in your system to increase the security of your account.\n \nSeveral failed 2FA attempts were observed from <b>$$ipaddress$$</b> address. <br>If it is not you then it is likely that your account has been hacked. Please change your credentials as soon as possible to ensure security.\n\nBest Regards!";
    }

    public String getSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_TEMPLATE")), (CharSequence)"Dear $$username$$, Your OTP is $$otp$$. Use this Passcode to complete your transaction. Thank you.");
    }

    public void setEnableShareSecretKey(Boolean enableShareSecretKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_SHARE_SECRET_KEY", (Object)BooleanUtils.toString((Boolean)enableShareSecretKey, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableShareSecretKey() {
        Object enableShareSecretkey = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_SHARE_SECRET_KEY");
        if (enableShareSecretkey == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)enableShareSecretkey));
    }

    public void setBypass2FACookieDomain(String bypass2FACookieDomain) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BYPASS_2FA_COOKIE_DOMAIN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bypass2FACookieDomain, (CharSequence)""))));
    }

    public String getBypass2FACookieDomain() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BYPASS_2FA_COOKIE_DOMAIN")), (CharSequence)"");
    }

    public String getConfigureDuoPushNotificationTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_DUO_PUSH_NOTIFICATION_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_DUO_PUSH_NOTIFICATION_TEMPLATE", (Object)duoPushNotificationTemplate);
    }

    public String getValidateDuoPushNotificationTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_DUO_PUSH_NOTIFICATION_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_DUO_PUSH_NOTIFICATION_TEMPLATE", (Object)duoPushNotificationTemplate);
    }

    public void setSmsTemplate(String emailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplate, (CharSequence)"Dear $$username$$, Your OTP is $$otp$$. Use this Passcode to complete your transaction. Thank you."))));
    }

    public Integer getOtpLength() {
        String otpLength = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_LENGTH");
        if (NumberUtils.isDigits((String)otpLength)) {
            return NumberUtils.createInteger((String)otpLength);
        }
        return 6;
    }

    public void setOtpLength(Integer otpLength) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_LENGTH", (Object)String.valueOf(otpLength));
    }

    public Integer getOtpValidityDuration() {
        String otpValidityTime = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION");
        if (NumberUtils.isDigits((String)otpValidityTime)) {
            return NumberUtils.createInteger((String)otpValidityTime);
        }
        return 2;
    }

    public void setOtpValidityDuration(Integer otpValidityTime) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION", (Object)String.valueOf(otpValidityTime));
    }

    public String getSmsGateway() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_GATEWAY")), (CharSequence)"miniOrange Gateway");
    }

    public void setSmsGateway(String smsGateway) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_GATEWAY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)smsGateway, (CharSequence)""))));
    }

    public String getCustomerKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY")), (CharSequence)"");
    }

    public void setCustomerKey(String customerKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customerKey, (CharSequence)""))));
    }

    public String getApiKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY")), (CharSequence)"");
    }

    public void setApiKey(String apiKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)apiKey, (CharSequence)""))));
    }

    public String getSmsGatewayUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL")), (CharSequence)"");
    }

    public void setSmsGatewayUrl(String smsGatewayUrl) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)smsGatewayUrl, (CharSequence)""))));
    }

    public void setShowWelcomePrompt(Boolean showWelcomePrompt) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WELCOME_PROMPT", (Object)BooleanUtils.toString((Boolean)showWelcomePrompt, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowWelcomePrompt() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_WELCOME_PROMPT")), (String)"true"));
    }

    public Boolean getShowSupportedAppPopup() {
        Object showSupportedAppPopup = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP");
        if (showSupportedAppPopup == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)showSupportedAppPopup));
    }

    public void setShowSupportedAppPopup(Boolean showSupportedAppPopup) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP", (Object)BooleanUtils.toString((Boolean)showSupportedAppPopup, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIgnore2FAAfterSso() {
        Object ignore2FAAfterSso = this.pluginSettings.get("miniorange.twofactor.MO2FA_IGNORE_2FA_AFTER_SSO");
        if (ignore2FAAfterSso == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)ignore2FAAfterSso));
    }

    public void setIgnore2FAAfterSso(Boolean ignore2FAAfterSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IGNORE_2FA_AFTER_SSO", (Object)BooleanUtils.toString((Boolean)ignore2FAAfterSso, (String)"true", (String)"false", (String)"false"));
    }

    public String getSsoLoginUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SSO_LOGIN_URL")), (CharSequence)"");
    }

    public void setSsoLoginUrl(String ssoUrlsList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SSO_LOGIN_URL", (Object)ssoUrlsList);
    }

    public List<String> getExclude2faForGroupList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS");
        if (value == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)value;
    }

    public void setExclude2faForGroupList(List<String> exclude2faForGroupList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS", exclude2faForGroupList);
    }

    public Boolean getShowAllConfiguredMethodToUser() {
        Object showAllConfiguredMethodToUser = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER");
        if (showAllConfiguredMethodToUser == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)showAllConfiguredMethodToUser));
    }

    public void setShowAllConfiguredMethodToUser(Boolean showAllConfiguredMethodToUser) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER", (Object)BooleanUtils.toString((Boolean)showAllConfiguredMethodToUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowRemaining2FAMethodsAfterInlineRegistration() {
        Object showRemaining2FAMethodsAfterConfiguration = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION");
        if (showRemaining2FAMethodsAfterConfiguration == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)showRemaining2FAMethodsAfterConfiguration));
    }

    public void setShowRemaining2FAMethodsAfterInlineRegistration(Boolean showRemaining2FAMethodsAfterConfiguration) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION", (Object)BooleanUtils.toString((Boolean)showRemaining2FAMethodsAfterConfiguration, (String)"true", (String)"false", (String)"false"));
    }

    public String getAttestationType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ATTESTATION_TYPE")), (CharSequence)"none");
    }

    public void setAttestationType(String attestationType) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ATTESTATION_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)attestationType, (CharSequence)"none"))));
    }

    public String getAuthenticatorType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE")), (CharSequence)"unspecified");
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)authenticatorType, (CharSequence)"unspecified"))));
    }

    public String getUserVerification() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USER_VERIFICATION")), (CharSequence)"discouraged");
    }

    public void setUserVerification(String userVerification) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USER_VERIFICATION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)userVerification, (CharSequence)"discouraged"))));
    }

    public String getResidentKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_RESIDENT_KEY")), (CharSequence)"false");
    }

    public void setResidentKey(String residentKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_RESIDENT_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)residentKey, (CharSequence)"false"))));
    }

    public Boolean getMultiLingualSupportToggle() {
        Object multiLingualSupportToggle = this.pluginSettings.get("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE");
        if (multiLingualSupportToggle == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)multiLingualSupportToggle));
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE", (Object)BooleanUtils.toString((Boolean)multiLingualSupportToggle, (String)"true", (String)"false", (String)"false"));
    }

    public void clearPluginSettings(List<String> allAvailableConfluenceUserNameList) {
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_APP_LABEL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_JSD");
        for (String user : allAvailableConfluenceUserNameList) {
            this.removeUserSettings(user);
        }
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_2FA_METHODS_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_CURRENT_2FA_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SECURITY_QUESTION_ANSWER_CONFIGURED_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_TOTP_SECRET");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_SALT");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENCRYPTION_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_USER_MESSAGE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_OTP_LENGTH");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SKIP_2FA_URLS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_GATEWAY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ATTESTATION_TYPE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_VERIFICATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_RESIDENT_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS");
        this.pluginSettings.remove("miniorange.twofactor.AUTODELETE_AUDITLOGS");
        this.pluginSettings.remove("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE");
    }

    public void removeUserSettings(String username) {
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username);
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username);
        this.pluginSettings.remove(username);
    }

    public MoTwoFactorCommonUserSettings getFromJsonObject(String jsonObject) {
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        MoTwoFactorCommonUserSettings twoFactorUserSettings = gson.fromJson((JsonElement)parser.parse(jsonObject).getAsJsonObject(), MoTwoFactorCommonUserSettings.class);
        return twoFactorUserSettings;
    }

    private JsonObject convertToJsonObject(MoTwoFactorCommonUserSettings userRelatedSettings) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("enable2FaForUser", userRelatedSettings.getEnable2FaForUser());
        jsonObject.addProperty("totpSecret", userRelatedSettings.getTotpSecret());
        jsonObject.addProperty("userSalt", userRelatedSettings.getUserSalt());
        jsonObject.addProperty("current2FAMethod", userRelatedSettings.getCurrent2FAMethod());
        JsonArray configured2FAMethodsByUserArray = new JsonArray();
        for (String string : userRelatedSettings.getConfigured2FAMethodsByUser()) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(string);
            configured2FAMethodsByUserArray.add(jsonPrimitive);
        }
        jsonObject.add("configured2FAMethodsByUser", configured2FAMethodsByUserArray);
        JsonObject securityQuestionAnswerObj = new JsonObject();
        if (userRelatedSettings.getSecurityQuestionAnswer() != null) {
            for (String string : userRelatedSettings.getSecurityQuestionAnswer().keySet()) {
                if (string == null) continue;
                securityQuestionAnswerObj.addProperty(string, userRelatedSettings.getSecurityQuestionAnswer().get(string));
            }
        }
        jsonObject.add("securityQuestionAnswer", securityQuestionAnswerObj);
        JsonArray jsonArray = new JsonArray();
        for (String deviceDetails : userRelatedSettings.getRememberMeDeviceDetails()) {
            JsonPrimitive defaultGroupObject = new JsonPrimitive(deviceDetails);
            jsonArray.add(defaultGroupObject);
        }
        jsonObject.add("rememberMeDeviceDetails", jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (String backupCode : userRelatedSettings.getBackupCodes()) {
            JsonPrimitive backupCodeElement = new JsonPrimitive(backupCode);
            jsonArray2.add(backupCodeElement);
        }
        jsonObject.add("backupCodes", jsonArray2);
        jsonObject.addProperty("countryCode", userRelatedSettings.getCountryCode());
        jsonObject.addProperty("mobileNumber", userRelatedSettings.getMobileNumber());
        return jsonObject;
    }

    public void deleteUserAction(String username) {
        List<String> userList = this.getListOf2FAConfiguredUsers();
        userList.removeAll(Collections.singleton(username));
        this.setListOf2FAConfiguredUsers(userList);
        List<String> twoFactorEnabledUsers = this.getEnable2FAForUsersList();
        twoFactorEnabledUsers.removeAll(Collections.singleton(username));
        this.setEnable2FAForUsersList(twoFactorEnabledUsers);
        List<String> twoFactorDisabledUsers = this.getDisable2FAForUsersList();
        twoFactorDisabledUsers.removeAll(Collections.singleton(username));
        this.setDisable2FAForUsersList(twoFactorDisabledUsers);
        this.removeUserSettings(username);
    }

    public void deleteGroupAction(String groupName) {
        List<String> groupList = this.getEnable2FAForGroupsList();
        groupList.removeAll(Collections.singleton(groupName));
        this.setEnable2FAForGroupsList(groupList);
    }

    public void setRememberMeMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRememberMeMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED"))), (boolean)false);
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setUsernameMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUsernameMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED"))), (boolean)false);
    }

    public String getWelcomeMessageTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE")), (CharSequence)"");
    }

    public void setWelcomeMessageTemplate(String welcomeMessageTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE", (Object)welcomeMessageTemplate);
    }

    public String getInlineRegistration_2faMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_2faMethodListTemplate(String inlineRegistration_2faMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE", (Object)inlineRegistration_2faMethodListTemplate);
    }

    public String getValidate_2faMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setValidate_2faMethodListTemplate(String validate_2faMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE", (Object)validate_2faMethodListTemplate);
    }

    public String getInlineRegistration_backupMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_backupMethodListTemplate(String inlineRegistration_backupMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE", (Object)inlineRegistration_backupMethodListTemplate);
    }

    public String getInlineRegistration_remaining2faMethodsListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_remaining2faMethodsListTemplate(String inlineRegistration_remaining2faMethodsListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE", (Object)inlineRegistration_remaining2faMethodsListTemplate);
    }

    public String getConfigureGoogleAuthenticatorTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE", (Object)googleAuthenticatorTemplate);
    }

    public String getValidateGoogleAuthenticatorTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE", (Object)googleAuthenticatorTemplate);
    }

    public String getConfigureSecurityQuestionTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE", (Object)securityQuestionTemplate);
    }

    public String getValidateSecurityQuestionTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE", (Object)securityQuestionTemplate);
    }

    public String getConfigureWebAuthnHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureWebAuthnHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getConfigureU2FHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureU2FHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getValidateU2FHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateU2FHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public void setValidateWebAuthnHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getValidateWebAuthnHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public String getConfigureWebAuthnAs2faMethodTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureWebAuthnAs2faMethodTemplate(String weAuthn2faTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE", (Object)weAuthn2faTemplate);
    }

    public void setValidateWebAuthnAs2faMethodTemplate(String webAuthnAs2faMethodTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE", (Object)webAuthnAs2faMethodTemplate);
    }

    public String getValidateWebAuthnAs2faMethodTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE")), (CharSequence)"");
    }

    public String getConfigureOtpOverEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE", (Object)otpOverEmailTemplate);
    }

    public String getValidateOtpOverEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE", (Object)otpOverEmailTemplate);
    }

    public String getConfigureOtpOverSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE", (Object)otpOverSmsTemplate);
    }

    public String getValidateOtpOverSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE", (Object)otpOverSmsTemplate);
    }

    public String getConfigureBackupCodeTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureBackupCodeTemplate(String backupCodeTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE", (Object)backupCodeTemplate);
    }

    public String getValidateBackupCodeTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateBackupCodeTemplate(String backupCodeTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE", (Object)backupCodeTemplate);
    }

    public String getLockedUserTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE")), (CharSequence)"");
    }

    public void setLockedUserTemplate(String lockedUserTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE", (Object)lockedUserTemplate);
    }

    public String getContactAdminTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONTACT_ADMIN_TEMPLATE")), (CharSequence)"");
    }

    public void setContactAdminTemplate(String contactAdminTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONTACT_ADMIN_TEMPLATE", (Object)contactAdminTemplate);
    }

    public String getBlocklistIpTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE")), (CharSequence)"");
    }

    public void setBlocklistIpTemplate(String blocklistIpTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE", (Object)blocklistIpTemplate);
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.TROUBLESHOOTING"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.twofactor.TROUBLESHOOTING", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public String getClientIpRequestHeader() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER")), (CharSequence)"X-FORWARDED-FOR");
    }

    public void setClientIpRequestHeader(String clientIpRequestHeader) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)clientIpRequestHeader, (CharSequence)"X-FORWARDED-FOR"))));
    }

    public boolean getAutoDeleteAuditLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.AUTODELETE_AUDITLOGS"))), (boolean)false);
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.pluginSettings.put("miniorange.twofactor.AUTODELETE_AUDITLOGS", (Object)BooleanUtils.toString((Boolean)autoDeleteAuditLogs, (String)"true", (String)"false", (String)"false"));
    }

    public Integer getAutoDeleteAuditLogsAfterDays() {
        String days = (String)this.pluginSettings.get("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS");
        if (NumberUtils.isDigits((String)days)) {
            return NumberUtils.createInteger((String)days);
        }
        return 60;
    }

    public void setAutoDeleteAuditLogsAfterDays(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS", (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public String getDuoPushNotificationIntegrationKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY")), (CharSequence)"");
    }

    public void setDuoPushNotificationIntegrationKey(String duoPushNotificationIntegrationKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationIntegrationKey, (CharSequence)""))));
    }

    public String getDuoPushNotificationSecretKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY")), (CharSequence)"");
    }

    public void setDuoPushNotificationSecretKey(String duoPushNotificationSecretKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationSecretKey, (CharSequence)""))));
    }

    public String getDuoPushNotificationHostName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME")), (CharSequence)"");
    }

    public void setDuoPushNotificationHostName(String duoPushNotificationHostName) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationHostName, (CharSequence)""))));
    }

    public Map<String, String> getRequestInfo(HttpServletRequest request) {
        if (request != null) {
            String[] VALID_IP_HEADER_CANDIDATES;
            Enumeration headerNames = request.getHeaderNames();
            HashMap<String, String> requestInfo = new HashMap<String, String>();
            requestInfo.put("HTTP Request Header", "");
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = request.getHeader(key);
                requestInfo.put(key, value);
            }
            for (String header : VALID_IP_HEADER_CANDIDATES = new String[]{"X-FORWARDED-FOR", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "Set-Cookie"}) {
                if (request.getHeader(header) == null) {
                    requestInfo.put(header, "-");
                    continue;
                }
                requestInfo.put(header, request.getHeader(header));
            }
            LOGGER.debug("requestInfo" + requestInfo);
            return requestInfo;
        }
        return new HashMap<String, String>();
    }
}

