/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.ldap.DefaultLDAPUserFactory;
import com.atlassian.user.impl.ldap.LDAPValidator;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Category;

public class LDAPUserManagerReadOnly
extends ReadOnlyUserManager {
    public static final Category log = Category.getInstance(LDAPUserManagerReadOnly.class);
    private LDAPRepository repository;
    private LDAPUserAdaptor userAdaptor;

    public LDAPUserManagerReadOnly() {
    }

    public LDAPUserManagerReadOnly(LDAPRepository repository) throws ConfigurationException {
        this.repository = repository;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository);
        InitializationCheck.validateArgs(args, new String[]{"repository"}, this);
    }

    public Pager getUsers() throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUsers");
        LDAPPagerInfo info = this.userAdaptor.search(null);
        LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.repository), info);
        this.profilePop(this.getClass().getName() + "_getUsers");
        return pager;
    }

    public Pager getUserNames() throws EntityException {
        LDAPPagerInfo info = this.userAdaptor.search(null, new String[]{this.repository.getUsernameAttribute()});
        return new LDAPSingleStringPager(this.repository, info);
    }

    public User getUser(String username) throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUser(" + username + ")");
        User user = null;
        try {
            LDAPPagerInfo info = this.userAdaptor.search((Filter)new EqualsFilter(this.repository.getUsernameAttribute(), username));
            LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.repository), info);
            if (pager.getCurrentPage().size() > 0) {
                user = (User)pager.getCurrentPage().get(0);
            }
        }
        catch (EntityException e) {
            log.error((Object)("Error retrieving user: '" + username + "' from LDAP."), (Throwable)e);
        }
        this.profilePop(this.getClass().getName() + "_getUser(" + username + ")");
        return user;
    }

    public User createUser(String username) throws EntityException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration is read-only");
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        throw new UnsupportedOperationException("This manager does not handle user creation, so does not use a PasswordEncryptor");
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(entity)) {
            return null;
        }
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    private void profilePush(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)key);
        }
    }

    private void profilePop(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)key);
        }
    }
}

