/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Caching;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.HibernateUserManager;
import java.io.Serializable;
import net.sf.hibernate.HibernateException;

public class CachingHibernateUserManager
extends HibernateUserManager
implements Caching {
    protected static final String CACHE_KEY = CachingHibernateUserManager.class.getName() + ".username";
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public User getUser(String username) throws EntityException {
        Cache nameCache = this.cacheManager.getCache(CACHE_KEY);
        Long id = (Long)nameCache.get(username);
        if (id != null) {
            try {
                return (User)this.getSession().get(DefaultHibernateUser.class, (Serializable)id);
            }
            catch (HibernateException e) {
                throw new EntityException(e);
            }
        }
        User user = super.getUser(username);
        if (user != null) {
            nameCache.put(username, new Long(((DefaultHibernateUser)user).getId()));
        }
        return user;
    }

    public void removeUser(User user) throws EntityException {
        Cache nameCache = this.cacheManager.getCache(CACHE_KEY);
        try {
            super.removeUser(user);
            nameCache.remove(user.getName());
        }
        catch (Exception e) {
            throw new EntityException("Error removing username from cache: " + user.getName(), e);
        }
    }
}

