/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.miniorange.twofactor.webauthn.utils.AttestationExtension;
import java.util.ArrayList;
import java.util.List;

public class CableRegistrationData
implements AttestationExtension {
    public static final String KEY = "cableRegistration";
    List<Integer> versions;
    Integer maxVersion;
    byte[] publicKey;

    public static CableRegistrationData parseFromCbor(DataItem cborCableData) {
        CableRegistrationData cableData = new CableRegistrationData();
        Map cborMap = (Map)cborCableData;
        for (DataItem data : cborMap.getKeys()) {
            if (!(data instanceof UnicodeString)) continue;
            switch (((UnicodeString)data).getString()) {
                case "version": {
                    cableData.versions = new ArrayList<Integer>();
                    cableData.versions.add(((UnsignedInteger)cborMap.get(data)).getValue().intValue());
                    break;
                }
                case "maxVersion": {
                    cableData.maxVersion = ((UnsignedInteger)cborMap.get(data)).getValue().intValue();
                    break;
                }
                case "authenticatorPublicKey": {
                    cableData.publicKey = ((ByteString)cborMap.get(data)).getBytes();
                }
            }
        }
        return cableData;
    }

    @Override
    public AttestationExtension.Type getType() {
        return AttestationExtension.Type.CABLE;
    }
}

